/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.cache;

import com.pcbsys.foundation.concurrent.CacheLinePadAtomicLong;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.persist.cache.fEventCache;
import java.lang.ref.SoftReference;
import java.util.TreeMap;

public class fFixedSizeSoftEventCache
implements fEventCache {
    private final TreeMap<Long, SoftReference<fBaseEvent>> myCache;
    private final int myMaxSize;
    private CacheLinePadAtomicLong myCacheHits;
    private CacheLinePadAtomicLong myCacheMiss;
    private CacheLinePadAtomicLong myMemoryUsage;

    fFixedSizeSoftEventCache(int n) {
        this.myMaxSize = n;
        this.myCache = new TreeMap();
        this.myCacheHits = new CacheLinePadAtomicLong(0L);
        this.myCacheMiss = new CacheLinePadAtomicLong(0L);
        this.myMemoryUsage = new CacheLinePadAtomicLong(0L);
    }

    @Override
    public long getCacheHits() {
        return this.myCacheHits.longValue();
    }

    @Override
    public synchronized long getCacheMiss() {
        return this.myCacheMiss.longValue();
    }

    public synchronized long getMemoryUsage() {
        return this.myMemoryUsage.longValue();
    }

    @Override
    public synchronized int size() {
        return this.myCache.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.myCache.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(long l) {
        return this.myCache.containsKey(l);
    }

    @Override
    public synchronized fBaseEvent get(long l) {
        fBaseEvent fBaseEvent2 = this.lookup(this.myCache.get(l));
        if (fBaseEvent2 != null) {
            this.myCacheHits.incrementAndGet();
        } else {
            this.myCacheMiss.incrementAndGet();
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized fBaseEvent put(fBaseEvent fBaseEvent2) {
        fBaseEvent fBaseEvent3;
        SoftReference<fBaseEvent> softReference = new SoftReference<fBaseEvent>(fBaseEvent2);
        this.myCache.put(fBaseEvent2.getKey(), softReference);
        this.myMemoryUsage.addAndGet(fBaseEvent2.getSize());
        if (this.myCache.size() >= this.myMaxSize && (fBaseEvent3 = this.lookup(this.myCache.remove(this.myCache.firstEntry().getKey()))) != null) {
            this.myMemoryUsage.addAndGet(-fBaseEvent3.getSize());
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized fBaseEvent remove(long l) {
        fBaseEvent fBaseEvent2 = null;
        SoftReference<fBaseEvent> softReference = this.myCache.remove(l);
        if (softReference != null && (fBaseEvent2 = softReference.get()) != null) {
            this.myMemoryUsage.addAndGet(-fBaseEvent2.getSize());
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized void clear() {
        this.myCache.clear();
        this.myMemoryUsage.set(0L);
    }

    private fBaseEvent lookup(SoftReference<fBaseEvent> softReference) {
        fBaseEvent fBaseEvent2 = null;
        if (softReference != null) {
            return softReference.get();
        }
        return fBaseEvent2;
    }
}

