/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.cache;

import com.pcbsys.foundation.concurrent.CacheLinePadAtomicLong;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.persist.cache.fEventCache;
import java.lang.ref.WeakReference;
import java.util.TreeMap;

public class fFixedSizeWeakEventCache
implements fEventCache {
    private final TreeMap<Long, WeakReference<WeakObjectReference>> myCache;
    private final int myMaxSize;
    private CacheLinePadAtomicLong myCacheHits;
    private CacheLinePadAtomicLong myCacheMiss;
    private CacheLinePadAtomicLong myMemoryUsage;

    fFixedSizeWeakEventCache(int n) {
        this.myMaxSize = n;
        this.myCache = new TreeMap();
        this.myCacheHits = new CacheLinePadAtomicLong(0L);
        this.myCacheMiss = new CacheLinePadAtomicLong(0L);
        this.myMemoryUsage = new CacheLinePadAtomicLong(0L);
    }

    @Override
    public long getCacheHits() {
        return this.myCacheHits.longValue();
    }

    @Override
    public synchronized long getCacheMiss() {
        return this.myCacheMiss.longValue();
    }

    public synchronized long getMemoryUsage() {
        return this.myMemoryUsage.longValue();
    }

    @Override
    public synchronized int size() {
        return this.myCache.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.myCache.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(long l) {
        return this.myCache.containsKey(l);
    }

    @Override
    public synchronized fBaseEvent get(long l) {
        fBaseEvent fBaseEvent2 = this.lookup(this.myCache.get(l));
        if (fBaseEvent2 != null) {
            this.myCacheHits.incrementAndGet();
        } else {
            this.myCacheMiss.incrementAndGet();
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized fBaseEvent put(fBaseEvent fBaseEvent2) {
        fBaseEvent fBaseEvent3;
        WeakReference<WeakObjectReference> weakReference = new WeakReference<WeakObjectReference>(new WeakObjectReference(fBaseEvent2));
        this.myCache.put(fBaseEvent2.getKey(), weakReference);
        this.myMemoryUsage.addAndGet(fBaseEvent2.getSize());
        if (this.myCache.size() >= this.myMaxSize && (fBaseEvent3 = this.lookup(this.myCache.remove(this.myCache.firstEntry().getKey()))) != null) {
            this.myMemoryUsage.addAndGet(-fBaseEvent3.getSize());
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized fBaseEvent remove(long l) {
        WeakObjectReference weakObjectReference;
        fBaseEvent fBaseEvent2 = null;
        WeakReference<WeakObjectReference> weakReference = this.myCache.remove(l);
        if (weakReference != null && (weakObjectReference = (WeakObjectReference)weakReference.get()) != null) {
            weakObjectReference.isRemoved = true;
            fBaseEvent2 = weakObjectReference.myEvent;
            if (fBaseEvent2 != null) {
                this.myMemoryUsage.addAndGet(-fBaseEvent2.getSize());
            }
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized void clear() {
        this.myCache.clear();
        this.myMemoryUsage.set(0L);
    }

    private fBaseEvent lookup(WeakReference<WeakObjectReference> weakReference) {
        WeakObjectReference weakObjectReference;
        fBaseEvent fBaseEvent2 = null;
        if (weakReference != null && (weakObjectReference = (WeakObjectReference)weakReference.get()) != null) {
            fBaseEvent2 = weakObjectReference.myEvent;
        }
        return fBaseEvent2;
    }

    private class WeakObjectReference {
        private fBaseEvent myEvent;
        private boolean isRemoved;

        WeakObjectReference(fBaseEvent fBaseEvent2) {
            this.myEvent = fBaseEvent2;
            this.isRemoved = false;
        }

        public void finalize() throws Throwable {
            long l = this.myEvent.getKey();
            this.myEvent = null;
            if (!this.isRemoved) {
                fFixedSizeWeakEventCache.this.remove(l);
            }
            super.finalize();
        }
    }
}

