/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.persist.event.fBaseEventHolder;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.fEventModifier;
import com.pcbsys.foundation.persist.fIndexManagement;
import com.pcbsys.foundation.persist.fMaintenanceListener;
import com.pcbsys.foundation.persist.fMemoryMappedBuffer;
import com.pcbsys.foundation.persist.fPersistentConstants;
import com.pcbsys.foundation.persist.streamHelpers.BufferedRandomAccessFileReader;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class fBufferedEventManager
extends fEventManager {
    protected fMemoryMappedBuffer myMappedBuffer;
    protected boolean cacheReloadedEvents;
    protected RandomAccessFile myFileIn;
    protected fEventInputStream myInputStream;
    protected BufferedRandomAccessFileReader myBufferedInput;
    protected FileOutputStream myFileOut;
    protected fEventOutputStream myOutputStream;
    private long myCacheHit;
    private long myCacheMiss;
    protected long myStorageSpace;
    protected long myFreeSpace;
    protected boolean hasCachedEvents;
    protected boolean allowCaching;
    protected String myFileName;
    protected long myFileOutPtr;
    private boolean isCorrupted;
    private final String myLogHeader;

    public fBufferedEventManager(int n, fBaseEventFactory fBaseEventFactory2, String string, boolean bl, boolean bl2, fIndexManagement fIndexManagement2) {
        super(fPersistentConstants.getPageSize(), fBaseEventFactory2, bl2, fIndexManagement2);
        this.allowCaching = bl;
        this.myFileIn = null;
        this.myFileOut = null;
        this.myOutputStream = null;
        this.myInputStream = null;
        this.myCacheHit = 0L;
        this.myCacheMiss = 0L;
        this.hasCachedEvents = false;
        this.myFileName = string;
        this.myFileOutPtr = 0L;
        this.myFreeSpace = 0L;
        this.myStorageSpace = 0L;
        this.myLogHeader = fPersistentConstants.sMyNames[n] + "-Store> " + this.getName() + " : ";
        this.isCorrupted = false;
    }

    @Override
    public void performSync() throws IOException {
        this.myFileOut.getChannel().force(false);
        this.myFileIn.getChannel().force(false);
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    protected void setCorrupted(boolean bl) {
        this.isCorrupted = bl;
    }

    protected void reset() {
        this.inmem.removeAllElements();
        try {
            boolean bl = fEnvironment.isWindows() && this.myMappedBuffer != null;
            this.myFileOut.close();
            if (bl) {
                this.myMappedBuffer.close();
            }
            this.myFileIn.setLength(8L);
            if (bl) {
                this.myMappedBuffer = new fMemoryMappedBuffer(this.myFileName, this.myFileIn);
            }
            this.myFileOut = fFile.openFileOutputStream(this.myFileName + ".mem", true);
            this.myOutputStream = new fEventOutputStream(new BufferedOutputStream(this.myFileOut, fPersistentConstants.getBufferSize()), this.myFactory, false);
            this.myFileOutPtr = 8L;
            this.myFreeSpace = 0L;
            this.myStorageSpace = 0L;
        }
        catch (Exception exception) {
            this.log(fLogLevel.ERROR, exception);
        }
    }

    protected synchronized void closeAllIO() {
        this.IOClosed = true;
        try {
            if (this.myOutputStream != null) {
                this.myOutputStream.flush();
                this.myOutputStream.close();
                this.myOutputStream = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.myFileOut != null) {
                this.myFileOut.close();
                this.myFileOut = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.myInputStream != null) {
                this.myInputStream.close();
                this.myInputStream = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.myFileIn != null) {
                if (this.getSyncManager().getSyncFlag()) {
                    this.myFileIn.getChannel().force(true);
                }
                this.myFileIn.close();
                this.myFileIn = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void updateMappedId(long l) throws IOException {
        if (this.myMappedBuffer != null && this.isActive) {
            this.myMappedBuffer.position(0);
            this.myMappedBuffer.put(fBufferedEventManager.writeNativeLong(l));
        } else {
            this.myFileIn.seek(0L);
            this.myFileIn.write(fBufferedEventManager.writeNativeLong(l));
        }
    }

    @Override
    public String getName() {
        return this.myFileName + ".mem";
    }

    @Override
    public float getCacheHitRatio() {
        if (this.myCacheMiss == 0L || this.myCacheHit == 0L) {
            return 0.0f;
        }
        float f = this.myCacheMiss + this.myCacheHit;
        return (float)this.myCacheHit / f * 100.0f;
    }

    @Override
    public long getPercentFree() {
        if (this.myStorageSpace != 0L) {
            return 100L - (this.myStorageSpace - this.myFreeSpace) * 100L / this.myStorageSpace;
        }
        return 0L;
    }

    @Override
    public long size() {
        return this.inmem.size();
    }

    @Override
    public long getUsage() {
        return this.myStorageSpace;
    }

    @Override
    public long usedSpace() {
        return this.myStorageSpace;
    }

    protected synchronized fBaseEvent getEvent(fBaseEventHolder fBaseEventHolder2) {
        try {
            if (fBaseEventHolder2.getEvent() != null) {
                ++this.myCacheHit;
                return fBaseEventHolder2.getEvent();
            }
            ++this.myCacheMiss;
            this.myBufferedInput.seek(fBaseEventHolder2.getPos() + 12L);
            return this.processRead(this.myInputStream, fBaseEventHolder2);
        }
        catch (Exception exception) {
            this.log(fLogLevel.ERROR, exception);
            fBaseEventHolder2.setEvent(null);
            return null;
        }
    }

    private fBaseEvent processRead(fEventInputStream fEventInputStream2, fBaseEventHolder fBaseEventHolder2) throws IOException {
        fBaseEvent fBaseEvent2 = fEventInputStream2.readEvent();
        byte[] byArray = fBaseEvent2.getData();
        if (this.allowCaching && (byArray == null || byArray.length < fPersistentConstants.getMaxCacheableSize())) {
            this.incrementMemoryUsage(fBaseEvent2);
            fBaseEventHolder2.setEvent(fBaseEvent2);
            this.hasCachedEvents = true;
        }
        return fBaseEvent2;
    }

    @Override
    public synchronized void performMaintenance() {
        this.performMaintenance(null, null, null);
    }

    @Override
    public synchronized void performMaintenance(fMaintenanceListener fMaintenanceListener2) {
        this.performMaintenance(null, fMaintenanceListener2, null);
    }

    @Override
    public synchronized void performMaintenance(fEventModifier fEventModifier2) {
        this.performMaintenance(null, null, fEventModifier2);
    }

    @Override
    public synchronized void performMaintenance(String string) {
        this.performMaintenance(string, null, null);
    }

    @Override
    public void performMaintenance(String string, fMaintenanceListener fMaintenanceListener2, fEventModifier fEventModifier2) {
        try {
            this.myBufferedInput.reset();
        }
        catch (IOException iOException) {
            fBufferedEventManager.checkIOException(iOException);
            this.log(fLogLevel.ERROR, iOException);
        }
    }

    protected void log(fLogLevel fLogLevel2, String string) {
        if (fConstants.logger.canLog(fLogLevel2)) {
            fConstants.logger.report(fLogLevel2, this.myLogHeader + string);
        }
    }

    protected void log(fLogLevel fLogLevel2, Throwable throwable) {
        fConstants.logger.report(fLogLevel2, this.myLogHeader + " Exception Follows:");
        fConstants.logger.report(fLogLevel2, throwable);
    }

    protected void report(String string) {
        fConstants.logger.log("Validation : " + string);
    }
}

