/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.base.fAutoDeleteEventListener;
import com.pcbsys.foundation.base.fBaseObject;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.collections.SortedVector;
import com.pcbsys.foundation.concurrent.CacheLinePadAtomicLong;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.memory.fMappedMemoryManager;
import com.pcbsys.foundation.memory.fMemoryUser;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.event.fBaseEventHolder;
import com.pcbsys.foundation.persist.fEventModifier;
import com.pcbsys.foundation.persist.fFileSyncManager;
import com.pcbsys.foundation.persist.fIndexManagement;
import com.pcbsys.foundation.persist.fMaintenanceListener;
import com.pcbsys.foundation.persist.fPurgeListener;
import com.pcbsys.foundation.persist.fStoreChangeListener;
import com.pcbsys.foundation.persist.fStoreMonitor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.CRC32;

public abstract class fEventManager
extends fBaseObject
implements fMemoryUser {
    protected final fBaseEventFactory myFactory;
    protected SortedVector inmem;
    protected final ConcurrentLinkedQueue<fBaseEvent> myDeadEventList;
    protected boolean isActive = true;
    protected volatile boolean myEnableAutoPurge = true;
    protected boolean IOClosed = false;
    protected long myTTL = -1L;
    protected long myCapacity = -1L;
    protected fPurgeListener myDeadEventListener = null;
    protected final fIndexManagement myIndexManager;
    protected final ArrayList<fStoreChangeListener> myChangeListener;
    private long myStoreSize = 0L;
    private long myOnHeapEvents = 0L;
    private final fFileSyncManager mySyncManager;
    private fStoreMonitor myMonitor = null;
    protected fAutoDeleteEventListener autoDelListener;
    private CacheLinePadAtomicLong lastKey = new CacheLinePadAtomicLong(-1L);

    public fEventManager(int n, fBaseEventFactory fBaseEventFactory2, boolean bl) {
        this(n, fBaseEventFactory2, bl, null);
    }

    public fEventManager(int n, fBaseEventFactory fBaseEventFactory2, boolean bl, fIndexManagement fIndexManagement2) {
        if (n > 0) {
            this.inmem = new SortedVector(n);
        }
        this.myFactory = fBaseEventFactory2;
        this.mySyncManager = new fFileSyncManager(this);
        this.mySyncManager.setSyncFlag(bl);
        this.myChangeListener = new ArrayList();
        this.myIndexManager = fIndexManagement2;
        this.myDeadEventList = new ConcurrentLinkedQueue();
    }

    public void close() {
        this.isActive = false;
        this.mySyncManager.close();
    }

    public void setAutoDelEventListener(fAutoDeleteEventListener fAutoDeleteEventListener2) {
        this.autoDelListener = fAutoDeleteEventListener2;
    }

    public synchronized void addStoreListener(fStoreChangeListener fStoreChangeListener2) {
        if (!this.myChangeListener.contains(fStoreChangeListener2)) {
            this.myChangeListener.add(fStoreChangeListener2);
        }
    }

    public synchronized void delStoreListener(fStoreChangeListener fStoreChangeListener2) {
        this.myChangeListener.remove(fStoreChangeListener2);
    }

    public fFileSyncManager getSyncManager() {
        return this.mySyncManager;
    }

    public synchronized long getStoreSize() {
        if (this.inmem != null) {
            return (long)this.inmem.size() * this.eventHolderSizeEstimate() + this.myStoreSize;
        }
        return this.myStoreSize;
    }

    protected abstract long eventHolderSizeEstimate();

    public void syncStream() throws IOException {
        this.mySyncManager.syncStream();
    }

    public synchronized void forceSync() throws IOException {
        this.mySyncManager.performSync();
    }

    public void setTTL(long l) {
        this.myTTL = l;
    }

    public synchronized void setCapacity(long l) {
        this.myCapacity = l;
    }

    public long getTTL() {
        return this.myTTL;
    }

    public synchronized long getCapacity() {
        return this.myCapacity;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public long getSize() {
        if (this.inmem != null) {
            return this.inmem.size();
        }
        return 0L;
    }

    public boolean supportCaching() {
        return true;
    }

    public void validate() {
    }

    public Queue<fBaseEvent> getDeadEventQueue() {
        return this.myDeadEventList;
    }

    @Override
    public synchronized int releaseMemory(boolean bl) {
        if (this.inmem != null) {
            this.inmem.trimToSize();
        }
        return this.releaseStoreSpace(bl);
    }

    public SortedVector getIndex() {
        return this.inmem;
    }

    public void setAutoPurge(boolean bl) {
        this.myEnableAutoPurge = bl;
    }

    public synchronized boolean isIOClosed() {
        return this.IOClosed;
    }

    public void addPurgeListener(fPurgeListener fPurgeListener2) {
        this.myDeadEventListener = fPurgeListener2;
    }

    public synchronized void addMonitor(fStoreMonitor fStoreMonitor2) {
        this.myMonitor = fStoreMonitor2;
    }

    public synchronized void updateEvent(fBaseEvent fBaseEvent2) throws fException {
        if (!this.containsEvent(fBaseEvent2.getKey())) {
            throw new fException("Event not found in store");
        }
        this.purgeEvents(fBaseEvent2.getKey());
        this.putEvent(fBaseEvent2);
    }

    public synchronized void atomicSwapEvent(fBaseEvent fBaseEvent2, long l) {
        this.purgeEvents(l, l);
        this.putEvent(fBaseEvent2);
    }

    public synchronized long getNoEvents() {
        if (this.inmem != null) {
            if ((long)this.inmem.size() > this.getCapacity() && this.getCapacity() > 0L) {
                this.checkCapacity(this.getCapacity());
            }
            return this.inmem.size();
        }
        return 0L;
    }

    public synchronized long getOnHeapEvents() {
        return this.myOnHeapEvents;
    }

    public synchronized void purgeAll() {
        if (this.inmem != null && this.inmem.size() != 0) {
            this.purgeEvents(this.getFirstStoredKey(), this.getLastStoredKey());
        }
    }

    public synchronized int copy(fLongOrderedQueue fLongOrderedQueue2, fFilter fFilter2, long l) {
        int n = this.inmem.findPreviousNearest(l);
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < this.inmem.size(); ++i) {
            long l2 = ((fBaseEventHolder)this.inmem.elementAt(i)).getKey();
            if (l2 <= l || fFilter2 != null && !fFilter2.isMatch(this.getEvent(l2))) continue;
            fLongOrderedQueue2.add(l2);
        }
        return fLongOrderedQueue2.size();
    }

    public synchronized long copy(fLongOrderedQueue fLongOrderedQueue2, fFilter fFilter2, long l, long l2) {
        int n;
        long l3 = -1L;
        if (l >= l2) {
            return l3;
        }
        if (this.inmem.size() == 0) {
            if (l2 < this.getLastKey()) {
                return l2;
            }
            return this.getLastKey();
        }
        for (int i = n = this.inmem.findIdx(l) + 1; i < this.inmem.size(); ++i) {
            fBaseEventHolder fBaseEventHolder2 = (fBaseEventHolder)this.inmem.elementAt(i);
            l3 = fBaseEventHolder2.getKey();
            if (l3 > l2) {
                l3 = l2;
                break;
            }
            if (l3 <= l || fFilter2 != null && !fFilter2.isMatch(fBaseEventHolder2.getEvent())) continue;
            fLongOrderedQueue2.add(l3);
        }
        return l3;
    }

    public boolean eventCanOverrideTTL() {
        return false;
    }

    public abstract boolean supportMemory();

    public abstract boolean supportDisk();

    public abstract boolean putEvent(fBaseEvent var1);

    public abstract int purgeEvents(long var1);

    public abstract int purgeEvents(long var1, long var3);

    public abstract int purgeEvents(long var1, long var3, boolean var5);

    public abstract int purgeEvents(long var1, long var3, fFilter var5);

    public abstract fBaseEvent getEvent(long var1);

    public abstract int getEvents(long var1, Object[] var3);

    public abstract long getEventTimeStored(long var1) throws fException;

    public abstract boolean containsEvent(long var1);

    public abstract void updateEventId() throws IOException;

    public abstract long getPreviousKey(long var1);

    public abstract long getPercentFree();

    public abstract long size();

    public abstract void checkCapacity(long var1);

    public abstract long maintainCache(long var1);

    public abstract long checkTTL(long var1);

    @Override
    public abstract String getName();

    public abstract long usedSpace();

    public abstract void performSync() throws IOException;

    public boolean supportSyncOps() {
        return false;
    }

    protected abstract int releaseStoreSpace(boolean var1);

    public abstract void performMaintenance();

    public abstract void performMaintenance(fMaintenanceListener var1);

    public abstract void performMaintenance(String var1);

    public abstract void performMaintenance(fEventModifier var1);

    public abstract void performMaintenance(String var1, fMaintenanceListener var2, fEventModifier var3);

    public float getCacheHitRatio() {
        return 100.0f;
    }

    public synchronized fBaseEvent[] getEvents(fFilter fFilter2) {
        if (this.inmem == null || this.inmem.size() <= 0) {
            return null;
        }
        long l = this.getFirstStoredKey();
        long l2 = this.getLastStoredKey();
        if (l2 < l) {
            return null;
        }
        fBaseEventHolder fBaseEventHolder2 = null;
        while (fBaseEventHolder2 == null && l <= l2 && this.isActive) {
            fBaseEventHolder2 = (fBaseEventHolder)this.inmem.find(l);
            if (fBaseEventHolder2 != null) continue;
            try {
                int n = this.inmem.findNextNearest(l);
                if (n > 0 && n < this.inmem.size()) {
                    fBaseEventHolder2 = (fBaseEventHolder)this.inmem.elementAt(n);
                }
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
            if (fBaseEventHolder2 != null) {
                l = fBaseEventHolder2.getKey();
                continue;
            }
            ++l;
        }
        if (fBaseEventHolder2 != null) {
            Object object;
            ArrayList<fBaseEvent[]> arrayList = new ArrayList<fBaseEvent[]>();
            int n = this.inmem.findIdx(fBaseEventHolder2.getKey());
            while (l <= l2 && this.inmem.size() >= n && this.isActive) {
                object = this.getEvent(fBaseEventHolder2.getKey());
                boolean bl = false;
                if (object != null) {
                    bl = fFilter2.isMatch(object);
                }
                if (bl) {
                    arrayList.add((fBaseEvent[])object);
                }
                if (++n < this.inmem.size()) {
                    fBaseEventHolder2 = (fBaseEventHolder)this.inmem.elementAt(n);
                    if (fBaseEventHolder2 == null) continue;
                    l = fBaseEventHolder2.getKey();
                    continue;
                }
                l = l2 + 1L;
            }
            if (arrayList.size() > 0) {
                object = new fBaseEvent[arrayList.size()];
                arrayList.toArray((T[])object);
                return object;
            }
        }
        return null;
    }

    public synchronized long getNextKey() {
        return this.lastKey.incrementAndGet();
    }

    public long getLastKey() {
        return this.lastKey.get();
    }

    protected void setLastEIDMemoryOnly(long l) {
        this.lastKey.getAndSet(l);
    }

    public synchronized void setLastEID(long l) throws IOException {
        if (this.lastKey.get() != l) {
            this.setLastEIDMemoryOnly(l);
            this.updateEventId();
        }
    }

    public synchronized long getFirstStoredKey() {
        try {
            if (this.inmem != null && this.inmem.size() > 0) {
                fBaseEventHolder fBaseEventHolder2;
                int n = 0;
                if (this.myEnableAutoPurge) {
                    if (this.myCapacity < 0L) {
                        this.myCapacity = 0L;
                    }
                    if (this.myCapacity != 0L && this.myCapacity < (long)this.inmem.size()) {
                        n = this.inmem.size() - (int)this.myCapacity - 1;
                    }
                }
                if ((fBaseEventHolder2 = (fBaseEventHolder)this.inmem.elementAt(n)) != null) {
                    return fBaseEventHolder2.getKey();
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
        return this.lastKey.get();
    }

    public synchronized long getLastStoredKey() {
        try {
            fBaseEventHolder fBaseEventHolder2;
            if (this.inmem != null && this.inmem.size() > 0 && (fBaseEventHolder2 = (fBaseEventHolder)this.inmem.elementAt(this.inmem.size() - 1)) != null) {
                return fBaseEventHolder2.getKey();
            }
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
        return this.lastKey.get();
    }

    protected void add(fBaseEvent fBaseEvent2) {
        if (this.myIndexManager != null) {
            this.myIndexManager.add(this, fBaseEvent2);
        }
        if (this.myMonitor != null) {
            this.myMonitor.eventAdded();
        }
        for (fStoreChangeListener fStoreChangeListener2 : this.myChangeListener) {
            fStoreChangeListener2.add(fBaseEvent2);
        }
    }

    protected boolean hasDeleteInterest() {
        return this.myDeadEventListener != null || this.myIndexManager != null && this.myIndexManager.hasInterest();
    }

    protected boolean del(fBaseEvent fBaseEvent2) {
        return this.del(fBaseEvent2, true);
    }

    protected boolean del(fBaseEvent fBaseEvent2, boolean bl) {
        boolean bl2 = true;
        if (this.myIndexManager != null) {
            this.myIndexManager.del(this, fBaseEvent2);
        }
        if (this.myDeadEventListener != null && !bl) {
            this.myDeadEventList.add(fBaseEvent2);
        }
        if (this.myMonitor != null) {
            this.myMonitor.eventRemoved();
        }
        return bl2;
    }

    protected void clearAllKeys() {
        for (fStoreChangeListener fStoreChangeListener2 : this.myChangeListener) {
            fStoreChangeListener2.delAll();
        }
    }

    protected void clearKey(long l) {
        for (fStoreChangeListener fStoreChangeListener2 : this.myChangeListener) {
            fStoreChangeListener2.del(l);
        }
    }

    public void destroy(boolean bl) {
        if (this.myIndexManager != null) {
            this.myIndexManager.destroy();
        }
    }

    public static void unmap(String string, RandomAccessFile randomAccessFile, MappedByteBuffer mappedByteBuffer) {
        fFile.unmappingFile(string);
        fMappedMemoryManager.getInstance().unmap(string, randomAccessFile, mappedByteBuffer);
    }

    protected static MappedByteBuffer map(String string, RandomAccessFile randomAccessFile) {
        return fEventManager.map(string, randomAccessFile, 8);
    }

    public static MappedByteBuffer map(String string, RandomAccessFile randomAccessFile, int n) {
        fFile.mappingFile(string);
        return fMappedMemoryManager.getInstance().map(string, randomAccessFile, n);
    }

    public static void checkIOException(IOException iOException) {
        if (iOException.getMessage().equals("The device is not ready")) {
            System.out.println("Fatal I/O Error> Unable to continue, exiting, please consult with Software AG support");
            System.exit(1);
        }
    }

    protected static String parseFileName(String string) {
        String string2 = string.replace('/', '~');
        string2 = string2.replace('\\', '~');
        int n = string2.indexOf("~~");
        while (n != -1) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
            n = string2.indexOf("~~");
        }
        string2 = string2.replace('~', File.separatorChar);
        return string2;
    }

    protected static void makeDirectories(File file) throws IOException {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        File file2 = new File(string2);
        if (!file2.mkdirs() && !file2.exists() && file2.isDirectory()) {
            fConstants.logger.error("Unable to create directory path " + string2);
        }
    }

    public synchronized long getStoreCRC() {
        CRC32 cRC32 = new CRC32();
        if (this.inmem != null) {
            cRC32.update(this.inmem.size());
            cRC32.update(fEventManager.writeNativeLong(this.getLastStoredKey()));
            for (int i = 0; i < this.inmem.size(); ++i) {
                fBaseEventHolder fBaseEventHolder2 = (fBaseEventHolder)this.inmem.elementAt(i);
                cRC32.update(fEventManager.writeNativeLong(fBaseEventHolder2.getKey()));
            }
        }
        return cRC32.getValue();
    }

    protected static byte[] writeNativeLong(long l) {
        byte[] byArray = new byte[]{(byte)(l >>> 56 & 0xFFL), (byte)(l >>> 48 & 0xFFL), (byte)(l >>> 40 & 0xFFL), (byte)(l >>> 32 & 0xFFL), (byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)l};
        return byArray;
    }

    protected static byte[] writeNativeInt(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)n};
        return byArray;
    }

    protected static long readNativeLong(byte[] byArray) {
        long l = 0L;
        l = ((long)byArray[0] & 0xFFL) << 56 | l;
        l = ((long)byArray[1] & 0xFFL) << 48 | l;
        l = ((long)byArray[2] & 0xFFL) << 40 | l;
        l = ((long)byArray[3] & 0xFFL) << 32 | l;
        l = ((long)byArray[4] & 0xFFL) << 24 | l;
        l = ((long)byArray[5] & 0xFFL) << 16 | l;
        l = ((long)byArray[6] & 0xFFL) << 8 | l;
        l = (long)byArray[7] & 0xFFL | l;
        return l;
    }

    protected void incrementMemoryUsage(fBaseEvent fBaseEvent2) {
        if (fBaseEvent2 != null) {
            this.myStoreSize += fBaseEvent2.getHeapUsageEstimate();
            ++this.myOnHeapEvents;
        }
    }

    protected void decrementMemoryUsage(fBaseEvent fBaseEvent2) {
        if (fBaseEvent2 != null) {
            this.myStoreSize -= fBaseEvent2.getHeapUsageEstimate();
            --this.myOnHeapEvents;
        }
    }

    protected void resetMemoryUsage() {
        this.myStoreSize = 0L;
        this.myOnHeapEvents = 0L;
    }
}

