/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.base.fDuration;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.fManagerSyncListener;
import com.pcbsys.foundation.persist.fPersistentConstants;
import java.io.IOException;

public class fFileSyncManager {
    private final fEventManager myManager;
    private fManagerSyncListener mySyncListener = null;
    private fDuration myTimer;
    private int myBatchBeforeSync;
    private int myTimeBetweenSync;
    private long q0;
    private long q1;
    private long q2;
    private long q3;
    private long q4;
    private long q5;
    private long q6;
    private long myLastSync;
    private long p0;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long myEventCount;
    protected boolean syncWrites;

    public fFileSyncManager(fEventManager fEventManager2) {
        this.myManager = fEventManager2;
        this.myEventCount = 0L;
        this.myBatchBeforeSync = fPersistentConstants.getDefaultBatchSize();
        this.myTimeBetweenSync = fPersistentConstants.getMaxTimeBetweenSync();
    }

    public void close() {
    }

    public void syncStream(boolean bl) throws IOException {
        if (this.syncWrites) {
            if (bl) {
                ++this.myEventCount;
            }
            if (this.myEventCount > 0L && this.myEventCount >= (long)this.myBatchBeforeSync || this.myTimeBetweenSync > 0 && this.myLastSync + (long)this.myTimeBetweenSync < fTimer.getTicks()) {
                if (this.myTimer == null) {
                    this.myTimer = new fDuration();
                } else {
                    this.myTimer.start();
                }
                this.performSync();
                if (this.myTimer.getDuration() > fPersistentConstants.getMaxSyncTime()) {
                    fConstants.logger.error("Time to sync " + this.myTimer.getDuration() + " on store " + this.myManager.getName());
                }
                this.myLastSync = fTimer.getTicks();
                this.myEventCount = 0L;
            }
        }
    }

    protected void syncStream() throws IOException {
        this.syncStream(true);
    }

    public void performSync() throws IOException {
        if (this.mySyncListener != null) {
            this.mySyncListener.syncStart(this.myManager);
        }
        this.myManager.performSync();
        if (this.myTimer != null) {
            this.myTimer.stop();
        }
        if (this.mySyncListener != null) {
            this.mySyncListener.syncComplete(this.myManager);
        }
    }

    public boolean getSyncFlag() {
        return this.syncWrites;
    }

    public void setSyncFlag(boolean bl) {
        this.syncWrites = bl;
    }

    public int getSyncBatchSize() {
        return this.myBatchBeforeSync;
    }

    public void setSyncBatchSize(int n) {
        this.myBatchBeforeSync = n;
    }

    public int getSyncBatchTime() {
        return this.myTimeBetweenSync;
    }

    public void setSyncBatchTime(int n) {
        this.myTimeBetweenSync = n;
    }

    public fManagerSyncListener getSyncListener() {
        return this.mySyncListener;
    }

    public void setSyncListener(fManagerSyncListener fManagerSyncListener2) {
        this.mySyncListener = fManagerSyncListener2;
    }
}

