/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.utils.fEnvironment;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;

public class fMemoryMappedBuffer {
    private static final boolean sDebug = fEnvironment.isDebugEnabled("MemoryMapping");
    private final MappedByteBuffer myBuffer;
    private final RandomAccessFile myFile;
    private final String myFileName;
    private Exception closeStack;
    private boolean isClosed;

    public fMemoryMappedBuffer(String string, RandomAccessFile randomAccessFile) {
        this.myFileName = string;
        this.myFile = randomAccessFile;
        this.myBuffer = fEventManager.map(this.myFileName, this.myFile);
        this.isClosed = false;
    }

    public fMemoryMappedBuffer(String string, RandomAccessFile randomAccessFile, int n) {
        this.myFileName = string;
        this.myFile = randomAccessFile;
        this.myBuffer = fEventManager.map(this.myFileName, this.myFile, n);
        this.isClosed = false;
    }

    public void close() {
        if (this.isClosed) {
            this.logError();
            return;
        }
        this.isClosed = true;
        if (this.myBuffer != null) {
            fEventManager.unmap(this.myFileName, this.myFile, this.myBuffer);
        }
        if (sDebug) {
            this.closeStack = new Exception("Closed by thread");
            this.closeStack.fillInStackTrace();
        }
    }

    public long getLong(int n) {
        if (this.isClosed) {
            this.logError();
            return -1L;
        }
        return this.myBuffer.getLong(n);
    }

    public double getDouble(int n) {
        if (this.isClosed) {
            this.logError();
            return -1.0;
        }
        return this.myBuffer.getDouble(n);
    }

    public int getInt(int n) {
        if (this.isClosed) {
            this.logError();
            return -1;
        }
        return this.myBuffer.getInt(n);
    }

    public ByteBuffer putDouble(int n, double d) {
        if (this.isClosed) {
            this.logError();
            return null;
        }
        return this.myBuffer.putDouble(n, d);
    }

    public ByteBuffer putInt(int n, int n2) {
        if (this.isClosed) {
            this.logError();
            return null;
        }
        return this.myBuffer.putInt(n, n2);
    }

    public ByteBuffer putLong(int n, long l) {
        if (this.isClosed) {
            this.logError();
            return null;
        }
        return this.myBuffer.putLong(n, l);
    }

    public void position(int n) {
        if (this.isClosed) {
            this.logError();
        }
        this.myBuffer.position(n);
    }

    public ByteBuffer put(byte[] byArray) {
        if (this.isClosed) {
            this.logError();
            return null;
        }
        return this.myBuffer.put(byArray);
    }

    public LongBuffer asLongBuffer() {
        if (this.isClosed) {
            this.logError();
            return null;
        }
        return this.myBuffer.asLongBuffer();
    }

    public void flush() {
        if (this.isClosed) {
            this.logError();
        } else {
            this.myBuffer.force();
        }
    }

    private void logError() {
        IOException iOException = new IOException("MemoryMappedBuffer access while buffer closed");
        iOException.fillInStackTrace();
        fConstants.logger.warn(iOException);
        if (this.closeStack != null) {
            fConstants.logger.warn(this.closeStack);
        }
    }
}

