/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.SortedVector;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.persist.cache.fEventCache;
import com.pcbsys.foundation.persist.cache.fEventCacheFactory;
import com.pcbsys.foundation.persist.event.fMultiFileReliableEventHolder;
import com.pcbsys.foundation.persist.fMemoryMappedBuffer;
import com.pcbsys.foundation.persist.fMultiFileStoreDeleteListener;
import com.pcbsys.foundation.persist.fPersistentConstants;
import com.pcbsys.foundation.persist.streamHelpers.BufferedRandomAccessFileReader;
import com.pcbsys.foundation.system.memory.Constants;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicLong;

public class fMultiFileStore
implements Comparable<Long> {
    static final int INDEX_OUT_OF_RANGE = -1;
    private static final Field wordField;
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    private final fEventCache myCache;
    private final long myStartKey;
    private final long myEndKey;
    private final long myTTL;
    private final AtomicLong myFileLength;
    private final String myFileName;
    private final fBaseEventFactory myFactory;
    private final fMultiFileStoreDeleteListener myListener;
    private final BitSet myBitSet;
    private final SortedVector<fMultiFileReliableEventHolder> myInMemoryEvents;
    private final RandomAccessFile myFile;
    private final BufferedRandomAccessFileReader myBufferedReader;
    private final boolean myDiskOnly;
    private fMemoryMappedBuffer myMap;
    private LongBuffer myMappedBuffer;
    private fEventInputStream myInputStream;
    private fEventOutputStream myFileStreamOut;
    private FileOutputStream myFileOut;
    private long myEventCount;
    private long myEarliestTTL;
    private boolean isClosed;
    private boolean myEnableAutoPurge = true;

    public void setEnableAutoPurge(boolean bl) {
        this.myEnableAutoPurge = bl;
    }

    fMultiFileStore(long l, long l2, String string, fBaseEventFactory fBaseEventFactory2, long l3, fMultiFileStoreDeleteListener fMultiFileStoreDeleteListener2, boolean bl, fEventCacheFactory.CACHE_TYPE cACHE_TYPE) throws IOException {
        this.myDiskOnly = bl;
        this.myEventCount = 0L;
        this.isClosed = false;
        this.myStartKey = l;
        this.myEndKey = l2;
        this.myTTL = l3;
        this.myFactory = fBaseEventFactory2;
        this.myFileName = string;
        this.myListener = fMultiFileStoreDeleteListener2;
        this.myEarliestTTL = 0L;
        this.myCache = fEventCacheFactory.create(cACHE_TYPE);
        this.myInMemoryEvents = new SortedVector((int)(l2 - l + 1L) / 10);
        this.myBitSet = new BitSet((int)(l2 - l + 1L));
        File file = new File(string);
        this.myFile = fFile.openRandomAccessFile(file, "rw");
        long l4 = l2 - l + 1L;
        boolean bl2 = true;
        if (this.myFile.length() < l4 * 16L) {
            this.myFile.setLength(l4 * 16L);
            bl2 = false;
        }
        this.myMap = new fMemoryMappedBuffer(this.myFileName, this.myFile, (int)l4 * 16);
        this.myMappedBuffer = this.myMap.asLongBuffer();
        if (!bl2) {
            int n = 0;
            while ((long)n < l4) {
                this.myMappedBuffer.put(0L);
                this.myMappedBuffer.put(1L);
                ++n;
            }
        } else {
            int n = 0;
            while ((long)n < l4) {
                long l5 = this.myMappedBuffer.get();
                if (l5 > 0L) {
                    ++this.myEventCount;
                    this.myBitSet.set(n);
                } else if (l5 < 0L) {
                    this.myMappedBuffer.put(n << 1, 0L);
                }
                this.updateStoreTTL(this.myMappedBuffer.get());
                ++n;
            }
        }
        this.myMap.flush();
        this.myFileOut = fFile.openFileOutputStream(file, true);
        this.myFileStreamOut = new fEventOutputStream(new BufferedOutputStream(this.myFileOut, fPersistentConstants.getBufferSize()), fBaseEventFactory2, false);
        this.myBufferedReader = new BufferedRandomAccessFileReader(this.myFile, fPersistentConstants.getBufferSize());
        this.myInputStream = fStreamFactory.createInputStream((InputStream)this.myBufferedReader, this.myFactory, false);
        this.myInputStream.setMaxBufferSize(-1);
        this.myFileLength = new AtomicLong(this.myFile.length());
    }

    int getAllIncludingPurged(ArrayList<fBaseEvent> arrayList, BitSet bitSet) throws IOException {
        long l = this.myEndKey - this.myStartKey + 1L;
        this.myBufferedReader.seek(l * 16L);
        boolean bl = true;
        while (bl) {
            try {
                this.myInputStream.readLong();
                fBaseEvent fBaseEvent2 = this.myFactory.getEvent(this.myInputStream.readInt());
                if (fBaseEvent2 == null) continue;
                fBaseEvent2.readExternal(this.myInputStream);
                arrayList.add(fBaseEvent2);
                if (!this.myBitSet.get((int)(fBaseEvent2.getKey() - this.myStartKey))) continue;
                bitSet.set((int)fBaseEvent2.getKey());
            }
            catch (EOFException eOFException) {
                bl = false;
            }
        }
        return arrayList.size();
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.myMap.close();
            this.isClosed = true;
            this.myInputStream.close();
            this.myFileStreamOut.close();
            this.myFile.close();
        }
    }

    public void delete() throws IOException {
        this.close();
        fFile.delete(new File(this.myFileName));
    }

    public long getEventCount() {
        return this.myEventCount;
    }

    public boolean isEmpty() {
        return this.myEventCount == 0L;
    }

    public long getStartKey() {
        return this.myStartKey;
    }

    public long getEndKey() {
        return this.myEndKey;
    }

    public long getNextKey(long l) {
        int n = this.myBitSet.nextSetBit((int)(l - this.myStartKey) + 1);
        if (n < 0) {
            return -1L;
        }
        return (long)n + this.myStartKey;
    }

    public void add(fBaseEvent fBaseEvent2) throws IOException {
        int n = (int)(fBaseEvent2.getKey() - this.myStartKey);
        if (n < 0 || fBaseEvent2.getKey() > this.myEndKey) {
            throw new IOException("Event Key outside of range for store");
        }
        this.myBitSet.set(n);
        n <<= 1;
        long l = this.myTTL;
        if (fBaseEvent2.getTTL() > 0L) {
            l = fBaseEvent2.getTTL();
        }
        if (l > 0L) {
            this.updateStoreTTL(l += fTimer.currentTimeMillis());
        } else {
            l = 0L;
        }
        if (fBaseEvent2.isPersistant() || this.myDiskOnly) {
            this.myMappedBuffer.put(n, this.myFileLength.get());
            this.myMappedBuffer.put(n + 1, l);
            try {
                long l2 = this.myFileStreamOut.getByteCount();
                this.myFileStreamOut.writeLong(fTimer.currentTimeMillis());
                this.myFileStreamOut.writeEvent(fBaseEvent2);
                l2 = this.myFileStreamOut.getByteCount() - l2;
                this.myFileLength.addAndGet(l2);
                this.myFileStreamOut.flush();
                this.myCache.put(fBaseEvent2);
            }
            catch (IOException iOException) {
                this.myMappedBuffer.put(n, 0L);
                this.myMappedBuffer.put(n + 1, 0L);
                throw new IOException("Multi file store, reset file headers due to underlying exception, key:" + fBaseEvent2.getKey(), iOException);
            }
        }
        try {
            this.myInMemoryEvents.add(new fMultiFileReliableEventHolder(fBaseEvent2));
        }
        catch (Exception exception) {
            fConstants.logger.warn(exception);
        }
        this.myMappedBuffer.put(n, -1L);
        this.myMappedBuffer.put(n + 1, l);
        ++this.myEventCount;
    }

    public void delete(long l) throws IOException {
        int n = (int)(l - this.myStartKey);
        if (n < 0 || l > this.myEndKey) {
            throw new IOException("Event Key outside of range for store");
        }
        if (this.myBitSet.get(n)) {
            this.clearEntry(n <<= 1);
            this.myInMemoryEvents.remove(l);
            this.myCache.remove(l);
        }
    }

    public fBaseEvent get(long l) throws IOException {
        return this.get(l, false);
    }

    public fBaseEvent get(long l, boolean bl) throws IOException {
        fBaseEvent fBaseEvent2;
        int n = (int)(l - this.myStartKey);
        if (n < 0 || l > this.myEndKey) {
            throw new IOException("Event Key outside of range for store Key:" + l + " StartKey:" + this.myStartKey + " EndKey:" + this.myEndKey);
        }
        if (this.isClosed) {
            return null;
        }
        if (this.myBitSet.get(n)) {
            this.myMappedBuffer.position(n <<= 1);
            long l2 = this.myMappedBuffer.get();
            if (bl && l2 > 0L) {
                return null;
            }
            long l3 = this.myMappedBuffer.get();
            fBaseEvent2 = this.myCache.get(l);
            if (l2 > 0L) {
                try {
                    if (this.myEnableAutoPurge && l3 != 0L && l3 < fTimer.currentTimeMillis()) {
                        this.purge(l, fBaseEvent2, false);
                        return null;
                    }
                    if (fBaseEvent2 == null) {
                        long l4;
                        if (com.pcbsys.foundation.store.Constants.sDebug && (l4 = this.myCache.getCacheMiss()) % 10000L == 0L) {
                            fConstants.logger.log("MultiFileStore: " + this.myFileName + " did not find event " + l + " in cache, total cache misses: " + l4);
                        }
                        fBaseEvent2 = this.loadEvent(l2);
                    }
                }
                catch (EOFException eOFException) {
                    fBaseEvent2 = null;
                    this.myMappedBuffer.put(n, 0L);
                    this.myMappedBuffer.put(n + 1, 0L);
                    fConstants.logger.log("MultiFileStore: " + this.myFileName + " attempted to lookup event with ID " + l + " however the event was corrupt, removed reference " + l2 + " to event.");
                }
            } else if (l2 < 0L) {
                try {
                    fMultiFileReliableEventHolder fMultiFileReliableEventHolder2 = this.myInMemoryEvents.find(l);
                    if (fMultiFileReliableEventHolder2 != null) {
                        fBaseEvent2 = fMultiFileReliableEventHolder2.getEvent();
                        if (this.myEnableAutoPurge && l3 != 0L && l3 < fTimer.currentTimeMillis()) {
                            fBaseEvent2 = null;
                        }
                    }
                }
                catch (Exception exception) {
                    fConstants.logger.warn(exception);
                }
            }
        } else {
            fBaseEvent2 = this.myCache.get(l);
        }
        return fBaseEvent2;
    }

    public long getCacheHits() {
        return this.myCache.getCacheHits();
    }

    public long getCacheMiss() {
        return this.myCache.getCacheMiss();
    }

    public boolean contains(long l) throws IOException {
        int n = (int)(l - this.myStartKey);
        if (n < 0 || l > this.myEndKey) {
            throw new IOException("Event Key outside of range for store. Key:" + l);
        }
        return this.myBitSet.get(n);
    }

    public long getPreviousKey(long l) {
        int n = (int)(l - this.myStartKey);
        int n2 = this.previousBit(n);
        if (n2 != -1) {
            return this.myStartKey + (long)n2;
        }
        return n2;
    }

    public long getFirstEID() {
        return this.myStartKey + (long)this.myBitSet.nextSetBit(0);
    }

    public long getLastEID() {
        long[] lArray = this.toLongArray();
        int n = lArray.length - 1;
        if (n < 0) {
            return this.myStartKey;
        }
        while (lArray[n] == 0L && n > 0) {
            --n;
        }
        long l = n * 64;
        int n2 = Long.numberOfLeadingZeros(lArray[n]);
        l = l + (long)(64 - n2) - 1L;
        return this.myStartKey + l;
    }

    public int releaseStoreSpace() {
        int n = 0;
        for (int i = 0; i < this.myInMemoryEvents.size(); ++i) {
            fMultiFileReliableEventHolder fMultiFileReliableEventHolder2 = this.myInMemoryEvents.elementAt(i);
            if (fMultiFileReliableEventHolder2.getEvent() == null) continue;
            ++n;
            fMultiFileReliableEventHolder2.getEvent().resetCache();
        }
        if (com.pcbsys.foundation.store.Constants.sDebug) {
            fConstants.logger.log("MultiFileStore: " + this.myFileName + " clearing cache, removed " + this.myCache.size() + " cached events.");
        }
        this.myCache.clear();
        return n;
    }

    public void checkTTL() {
        long l = fTimer.currentTimeMillis();
        if (this.myEnableAutoPurge && this.myEarliestTTL > 0L && this.myEarliestTTL < l) {
            this.myEarliestTTL = 0L;
            int n = 0;
            int n2 = this.myBitSet.nextSetBit(n);
            while (n2 != -1) {
                n = n2 << 1;
                long l2 = this.myMappedBuffer.get(n + 1);
                if (l2 != 0L && l2 < l) {
                    try {
                        this.purge(this.myStartKey + (long)n2, null, false);
                    }
                    catch (IOException iOException) {
                        fConstants.logger.error(iOException);
                    }
                } else {
                    this.updateStoreTTL(l2);
                }
                n2 = this.myBitSet.nextSetBit(n2 + 1);
            }
        }
    }

    public void sync() throws IOException {
        this.myFile.getFD().sync();
        this.myFileOut.getFD().sync();
    }

    @Override
    public int compareTo(long l) {
        if (this.getStartKey() <= l) {
            if (l <= this.getEndKey()) {
                return 0;
            }
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object instanceof fMultiFileStore) {
            fMultiFileStore fMultiFileStore2 = (fMultiFileStore)object;
            return fMultiFileStore2.myStartKey == this.myStartKey && fMultiFileStore2.myEndKey == this.myEndKey;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public int compareTo(Long l) {
        if (l == null) {
            throw new NullPointerException("Key must not be null");
        }
        if (this.getStartKey() <= l) {
            if (l <= this.getEndKey()) {
                return 0;
            }
            return -1;
        }
        return 1;
    }

    public String toString() {
        return this.myFileName + ", EventCount:" + this.myEventCount + ", Earliest TTL:" + this.myEarliestTTL;
    }

    void shrink() throws IOException {
    }

    long getEarliestTTL() {
        return this.myEarliestTTL;
    }

    long getFileSize() {
        try {
            return this.myFile.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    long getTimeStored(long l) {
        int n = (int)(l - this.myStartKey);
        this.myMappedBuffer.position(n << 1);
        long l2 = this.myMappedBuffer.get();
        if (l2 < 0L) {
            fMultiFileReliableEventHolder fMultiFileReliableEventHolder2 = this.myInMemoryEvents.find(l);
            if (fMultiFileReliableEventHolder2 != null) {
                return fMultiFileReliableEventHolder2.getTime();
            }
        } else if (l2 > 0L) {
            try {
                this.myBufferedReader.seek(l2);
                return this.myInputStream.readLong();
            }
            catch (IOException iOException) {
                fConstants.logger.warn(iOException);
            }
        }
        return 0L;
    }

    BitSet getInternalBitSet() {
        return this.myBitSet;
    }

    private void updateStoreTTL(long l) {
        if (l != 0L && (this.myEarliestTTL == 0L || l < this.myEarliestTTL)) {
            this.myEarliestTTL = l;
        }
    }

    private void clearEntry(int n) {
        this.myMappedBuffer.put(n, 0L);
        this.myMappedBuffer.put(n + 1, 0L);
        --this.myEventCount;
        this.myBitSet.clear(n >> 1);
    }

    private long[] toLongArray() {
        try {
            return (long[])wordField.get(this.myBitSet);
        }
        catch (IllegalAccessException illegalAccessException) {
            fConstants.logger.warn(illegalAccessException);
            return new long[0];
        }
    }

    private int wordIndex(int n) {
        return n >> 6;
    }

    private int previousBit(int n) {
        if (n < 0) {
            return -1;
        }
        long[] lArray = this.toLongArray();
        int n2 = this.wordIndex(n);
        if (n2 >= lArray.length) {
            return lArray.length - 1;
        }
        long l = lArray[n2] & -1L >>> -(n + 1);
        while (l == 0L) {
            if (n2-- == 0) {
                return -1;
            }
            l = lArray[n2];
        }
        return (n2 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
    }

    private fBaseEvent loadEvent(long l) throws IOException {
        this.myBufferedReader.seek(l + 8L);
        fBaseEvent fBaseEvent2 = this.myFactory.getEvent(this.myInputStream.readInt());
        if (fBaseEvent2 != null) {
            fBaseEvent2.readExternal(this.myInputStream);
            this.myCache.put(fBaseEvent2);
        }
        return fBaseEvent2;
    }

    public void purge(long l, fBaseEvent fBaseEvent2, boolean bl) throws IOException {
        int n = (int)(l - this.myStartKey);
        if (n < 0 || l > this.myEndKey) {
            throw new IOException("Purge Event Key outside of range for store Key:" + l + " StartKey:" + this.myStartKey + " EndKey:" + this.myEndKey);
        }
        if (this.myBitSet.get(n)) {
            this.myMappedBuffer.position(n <<= 1);
            long l2 = this.myMappedBuffer.get();
            if (fBaseEvent2 == null) {
                if (l2 > 0L && this.myListener.hasInterest()) {
                    try {
                        fBaseEvent2 = this.myCache.get(l);
                        if (fBaseEvent2 == null) {
                            long l3;
                            if (com.pcbsys.foundation.store.Constants.sDebug && (l3 = this.myCache.getCacheMiss()) % 10000L == 0L) {
                                fConstants.logger.log("MultiFileStore: " + this.myFileName + " did not find event " + l + " in cache, total cache misses: " + l3);
                            }
                            fBaseEvent2 = this.loadEvent(l2);
                        }
                    }
                    catch (EOFException eOFException) {
                        fBaseEvent2 = null;
                        fConstants.logger.log("MultiFileStore: " + this.myFileName + " attempted to lookup event with ID " + l + " however the event was corrupt, removed reference " + l2 + " to event.");
                    }
                } else if (l2 < 0L) {
                    try {
                        fMultiFileReliableEventHolder fMultiFileReliableEventHolder2 = this.myInMemoryEvents.find(l);
                        if (fMultiFileReliableEventHolder2 != null) {
                            fBaseEvent2 = fMultiFileReliableEventHolder2.getEvent();
                        }
                    }
                    catch (Exception exception) {
                        fConstants.logger.warn(exception);
                    }
                }
            }
            this.myListener.purgingEvent(l, fBaseEvent2, bl);
            this.delete(l);
        } else {
            this.myBitSet.clear(n);
        }
    }

    static {
        Field field = null;
        try {
            Class<BitSet> clazz = BitSet.class;
            field = clazz.getDeclaredField("words");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Constants.debugMsg(noSuchFieldException);
        }
        wordField = field;
    }
}

