/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.SortedVector;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.io.fBaseEventFactory;
import com.pcbsys.foundation.memory.fMemoryManager;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.cache.fEventCacheFactory;
import com.pcbsys.foundation.persist.event.fMultiFileStoreTempEventHolder;
import com.pcbsys.foundation.persist.fEventIterator;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.fEventModifier;
import com.pcbsys.foundation.persist.fIndexManagement;
import com.pcbsys.foundation.persist.fMaintenanceListener;
import com.pcbsys.foundation.persist.fMemoryMappedBuffer;
import com.pcbsys.foundation.persist.fMultiFileStore;
import com.pcbsys.foundation.persist.fMultiFileStoreDeleteListener;
import com.pcbsys.foundation.persist.fMultiFileStoreListener;
import com.pcbsys.foundation.store.fStoreAttributes;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class fMultiFileStoreManager
extends fEventManager {
    private static final int sStoreLastKey = 0;
    private static final int sStoreStatePos = 8;
    private static final int sStoreVersion = 16;
    private static final int sStoreSizePos = 24;
    private static final int sStoreHeaderSize = 32;
    private static final long sOpened = 4537968240197507602L;
    private static final long sClosed = -4537968240197507603L;
    private static final double sVersion = 1.0;
    private static final String sStateFile = "state.mem";
    private static final StoreComparator sStoreComparator = new StoreComparator();
    private static final FileFilter sFileFilter = new FileFilter();
    private volatile String myFileName;
    private final ArrayList<fMultiFileStore> myStore;
    private final MultiFileStoreDeleteListener myListener;
    private final int myEventsPerStore;
    private final boolean myDiskOnly;
    private final fEventCacheFactory.CACHE_TYPE myCacheType;
    private volatile RandomAccessFile myStoreState;
    private volatile fMemoryMappedBuffer myStateMap;
    private fMultiFileStoreListener myRecoveryListener;
    private long myNumberOfEvents = -1L;
    private long myEarliestTTL = 0L;

    public fMultiFileStoreManager(fStoreAttributes fStoreAttributes2, boolean bl) throws IOException {
        this(fStoreAttributes2.getFileName(), fStoreAttributes2.getEventFactory(), fStoreAttributes2.getInitialID(), fStoreAttributes2.getIndexManagement(), fStoreAttributes2.getTtl(), fStoreAttributes2.getCapacity(), bl, fStoreAttributes2.getEventsPerSpindle(), fStoreAttributes2.getEventCache());
    }

    public fMultiFileStoreManager(String string, fBaseEventFactory fBaseEventFactory2, long l, fIndexManagement fIndexManagement2, long l2, long l3, boolean bl, int n) throws IOException {
        this(string, fBaseEventFactory2, l, fIndexManagement2, l2, l3, bl, n, fEventCacheFactory.CACHE_TYPE.NULL);
    }

    public fMultiFileStoreManager(String string, fBaseEventFactory fBaseEventFactory2, long l, fIndexManagement fIndexManagement2, long l2, long l3, boolean bl, int n, fEventCacheFactory.CACHE_TYPE cACHE_TYPE) throws IOException {
        this(string, fBaseEventFactory2, l, fIndexManagement2, l2, l3, bl, n, cACHE_TYPE, true);
    }

    fMultiFileStoreManager(String string, fBaseEventFactory fBaseEventFactory2, long l, fIndexManagement fIndexManagement2, long l2, long l3, boolean bl, int n, fEventCacheFactory.CACHE_TYPE cACHE_TYPE, boolean bl2) throws IOException {
        super(0, fBaseEventFactory2, false, fIndexManagement2);
        long l4;
        String[] stringArray;
        super.setTTL(l2);
        super.setCapacity(l3);
        this.inmem = null;
        this.myDiskOnly = bl;
        this.myFileName = string;
        this.myCacheType = cACHE_TYPE;
        this.myListener = new MultiFileStoreDeleteListener();
        this.myStore = new ArrayList();
        File file = new File(this.myFileName);
        int n2 = -1;
        if (!file.exists() && !file.mkdirs()) {
            fConstants.logger.info("MultiFileStore: " + this.myFileName + "> Unable to create directory structure for the files");
        }
        if ((stringArray = file.list(sFileFilter)) != null) {
            for (String string2 : stringArray) {
                if (string2.contains(".mem")) {
                    long l5;
                    try {
                        l5 = Long.parseLong(string2.substring(0, string2.indexOf("_")));
                        l4 = Long.parseLong(string2.substring(string2.indexOf("_") + 1, string2.indexOf(".")));
                    }
                    catch (Exception exception) {
                        fConstants.logger.log("MultiFileStore: " + this.myFileName + "> Attempted to reload file " + string2 + "however the following exception occurred", exception);
                        continue;
                    }
                    fMultiFileStore fMultiFileStore2 = new fMultiFileStore(l5, l4, this.myFileName + File.separator + string2, this.myFactory, this.myTTL, this.myListener, this.myDiskOnly, this.myCacheType);
                    fMultiFileStore2.setEnableAutoPurge(this.myEnableAutoPurge);
                    if (n2 == -1) {
                        n2 = (int)(l4 - l5) + 1;
                    } else if ((long)n2 != l4 - l5 + 1L) {
                        fConstants.logger.fatal("MultiFileStore: " + this.myFileName + "> Store sizes changed within the stores, this is not supported... Was : " + n2 + " now " + (l4 - l5) + " Please contact Software AG Support");
                        fBaseApplication.getApplication().fileOperationFailure("MultiFileStore: " + this.myFileName + "> Store sizes changed within the stores, this is not supported... Was : " + n2 + " now " + (l4 - l5) + " Please contact Software AG Support");
                    }
                    if (fMultiFileStore2.getEventCount() != 0L || !bl2) {
                        this.myStore.add(fMultiFileStore2);
                        continue;
                    }
                    fMultiFileStore2.delete();
                    continue;
                }
                fConstants.logger.log("MultiFileStore: " + this.myFileName + "> Did not reload file " + string2 + " as it is an unknown type");
            }
        }
        Collections.sort(this.myStore, sStoreComparator);
        if (n < 10000) {
            fConstants.logger.fatal("MultiFileStore: " + this.myFileName + "> Store size set lower than recommended " + n);
        }
        int n3 = n;
        File file2 = new File(this.myFileName + File.separator + sStateFile);
        int n4 = file2.exists() ? 1 : 0;
        this.myStoreState = fFile.openRandomAccessFile(file2, "rw");
        this.myStateMap = new fMemoryMappedBuffer(this.myFileName, this.myStoreState, 32);
        boolean bl3 = false;
        if (n4 != 0) {
            this.setLastEIDMemoryOnly(this.myStateMap.getLong(0));
            double d = this.myStateMap.getDouble(16);
            if (d != 1.0) {
                fConstants.logger.info("MultiFileStore: " + this.myFileName + "> Detected different store version File:" + d + " Software:" + 1.0);
                this.performConversion();
            }
            l4 = this.myStateMap.getLong(8);
            n3 = this.myStateMap.getInt(24);
            if (n3 == 0) {
                if (this.myStore.size() == 0) {
                    n3 = n;
                    fConstants.logger.fatal("MultiFileStore: " + this.myFileName + "> Store sizes has been reloaded as 0, this is indicative of something wrong, Resetting the store size to default " + n3);
                } else {
                    if (n2 == 0) {
                        fConstants.logger.fatal("MultiFileStore: " + this.myFileName + "> Store size has been calculated as 0 from existing files, this is not supported, Please contact Software AG Support");
                        fBaseApplication.getApplication().fileOperationFailure("MultiFileStore: " + this.myFileName + "> Store size has been calculated as 0 from existing files, this is not supported, Please contact Software AG Support");
                    }
                    n3 = n2;
                    fConstants.logger.fatal("MultiFileStore: " + this.myFileName + "> Store sizes has been reloaded as 0, this is indicative of something wrong, Resetting the store size to calculated store size " + n3);
                }
                this.myStateMap.putInt(24, n3);
            }
            if (l4 == -4537968240197507603L) {
                fConstants.logger.debug("MultiFileStore: " + this.myFileName + "> Detected clean close of store, no validation required");
            } else {
                if (l4 == 4537968240197507602L) {
                    fConstants.logger.debug("MultiFileStore: " + this.myFileName + "> Detected store not closed correctly but was left open");
                } else {
                    fConstants.logger.debug("MultiFileStore: " + this.myFileName + "> Detected store state corruption, validation required");
                }
                bl3 = true;
            }
            if (fIndexManagement2 != null && fIndexManagement2.hasInterest()) {
                this.reloadEvents();
            }
        } else {
            this.myStateMap.putDouble(16, 1.0);
            this.myStateMap.putInt(24, n3);
        }
        this.myStateMap.putLong(8, 4537968240197507602L);
        this.myEventsPerStore = n3;
        if (this.myStore.isEmpty()) {
            this.findStore(l, true);
        }
        if (bl3) {
            this.validateStore();
        }
        this.updateNumberOfEvents();
        this.updateEarliestTTLCache();
        fMemoryManager.getInstance().addMemoryUser(this);
        this.myStateMap.flush();
    }

    @Override
    public synchronized void close() {
        fMemoryManager.getInstance().delMemoryUser(this);
        if (this.isActive) {
            super.close();
            this.closeAllStores();
            this.myStateMap.putLong(8, -4537968240197507603L);
            this.myStateMap.close();
            try {
                this.myStoreState.close();
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
    }

    @Override
    public synchronized int copy(fLongOrderedQueue fLongOrderedQueue2, fFilter fFilter2, long l) {
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            long l2 = fMultiFileStore2.getFirstEID();
            long l3 = fMultiFileStore2.getLastEID();
            if (l >= l3) continue;
            while (l2 != -1L) {
                if (l2 > l && (fFilter2 == null || fFilter2.isMatch(this.getEvent(l2)))) {
                    fLongOrderedQueue2.offer(l2);
                }
                l2 = fMultiFileStore2.getNextKey(l2);
            }
        }
        return fLongOrderedQueue2.size();
    }

    @Override
    public synchronized long copy(fLongOrderedQueue fLongOrderedQueue2, fFilter fFilter2, long l, long l2) {
        long l3 = -1L;
        if (l >= l2) {
            return l3;
        }
        long l4 = this.getLastKey();
        long l5 = l2 = l2 < l4 ? l2 : l4;
        if (this.myStore.size() == 0) {
            return l2;
        }
        Iterator<fMultiFileStore> iterator = this.myStore.iterator();
        while (iterator.hasNext()) {
            fMultiFileStore fMultiFileStore2 = iterator.next();
            if (l2 < fMultiFileStore2.getStartKey()) {
                l3 = l2;
                break;
            }
            if (l > fMultiFileStore2.getEndKey()) {
                l3 = fMultiFileStore2.getEndKey();
                continue;
            }
            long l6 = l2 <= fMultiFileStore2.getEndKey() ? l2 : fMultiFileStore2.getEndKey();
            long l7 = l < fMultiFileStore2.getStartKey() ? fMultiFileStore2.getStartKey() - 1L : l;
            long l8 = this.copyIndividualStore(fMultiFileStore2, fLongOrderedQueue2, fFilter2, l7, l6);
            this.checkForEmptyStore(fMultiFileStore2, iterator);
            if (l8 == -1L) {
                l3 = l6;
                continue;
            }
            l3 = l8;
        }
        return l3;
    }

    private long copyIndividualStore(fMultiFileStore fMultiFileStore2, fLongOrderedQueue fLongOrderedQueue2, fFilter fFilter2, long l, long l2) {
        long l3;
        long l4 = -1L;
        if (l < l2 && (l3 = fMultiFileStore2.getNextKey(l)) >= fMultiFileStore2.getStartKey()) {
            l4 = l3;
            while (l4 != -1L) {
                if (l4 > l2) {
                    l4 = l2;
                    break;
                }
                if (fFilter2 == null) {
                    fLongOrderedQueue2.offer(l4);
                } else {
                    fBaseEvent fBaseEvent2 = null;
                    try {
                        fBaseEvent2 = fMultiFileStore2.get(l4);
                    }
                    catch (IOException iOException) {
                        fMultiFileStoreManager.checkIOException(iOException);
                        fConstants.logger.warn(iOException);
                    }
                    if (fBaseEvent2 != null && fFilter2.isMatch(fBaseEvent2)) {
                        fLongOrderedQueue2.offer(l4);
                    }
                }
                l4 = fMultiFileStore2.getNextKey(l4);
            }
        }
        return l4;
    }

    @Override
    public synchronized void destroy(boolean bl) {
        if (this.isActive) {
            this.close();
        }
        if (bl) {
            File file;
            for (fMultiFileStore comparable2 : this.myStore) {
                try {
                    comparable2.delete();
                }
                catch (IOException iOException) {
                    fMultiFileStoreManager.checkIOException(iOException);
                    fConstants.logger.warn(iOException);
                }
            }
            this.myStore.clear();
            File file2 = new File(this.myFileName + File.separator + sStateFile);
            if (!fFile.delete(file2)) {
                fConstants.logger.warn("fMultiFileStore> Unable to delete file " + file2.toString());
            }
            if (!fFile.delete(file = new File(this.myFileName))) {
                fConstants.logger.warn("fMultiFileStore> Unable to delete file " + file.toString());
            }
        }
        super.destroy(bl);
    }

    @Override
    public synchronized void purgeAll() {
        while (!this.myStore.isEmpty()) {
            try {
                this.myStore.get(0).delete();
                this.myStore.remove(0);
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
        this.resetMemoryUsage();
        this.myNumberOfEvents = 0L;
    }

    @Override
    public synchronized long getNoEvents() {
        if (this.myNumberOfEvents > this.getCapacity()) {
            this.checkCapacity(this.getCapacity());
        }
        return this.myNumberOfEvents;
    }

    private void updateNumberOfEvents() {
        this.myNumberOfEvents = 0L;
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            this.myNumberOfEvents += fMultiFileStore2.getEventCount();
        }
    }

    @Override
    public float getCacheHitRatio() {
        long l = 0L;
        long l2 = 0L;
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            l += fMultiFileStore2.getCacheHits();
            l2 += fMultiFileStore2.getCacheMiss();
        }
        float f = l + l2;
        if (f == 0.0f) {
            return 0.0f;
        }
        f = (float)l / f * 100.0f;
        return f;
    }

    @Override
    public synchronized void performSync() throws IOException {
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            fMultiFileStore2.sync();
        }
        this.myStoreState.getFD().sync();
    }

    @Override
    public synchronized long getFirstStoredKey() {
        if (this.myStore.size() == 0) {
            return this.getLastKey();
        }
        fMultiFileStore fMultiFileStore2 = this.myStore.get(0);
        if (fMultiFileStore2 == null) {
            return this.getLastKey();
        }
        if (fMultiFileStore2.isEmpty()) {
            if (this.getLastKey() > fMultiFileStore2.getEndKey() && this.checkForEmptyStore(fMultiFileStore2)) {
                return this.getFirstStoredKey();
            }
            return this.getLastKey();
        }
        return fMultiFileStore2.getFirstEID();
    }

    @Override
    public synchronized long getLastStoredKey() {
        if (this.myStore.size() > 0) {
            fMultiFileStore fMultiFileStore2 = this.myStore.get(this.myStore.size() - 1);
            if (fMultiFileStore2 == null) {
                return this.getLastKey();
            }
            if (fMultiFileStore2.getEventCount() != 0L) {
                return fMultiFileStore2.getLastEID();
            }
        }
        return this.getLastKey();
    }

    @Override
    public synchronized boolean putEvent(fBaseEvent fBaseEvent2) {
        fMultiFileStore fMultiFileStore2 = this.findStore(fBaseEvent2.getKey(), true);
        try {
            if (fMultiFileStore2.contains(fBaseEvent2.getKey())) {
                if (fConstants.logger.isDebugEnabled()) {
                    fConstants.logger.debug("fMultiFileStore> Event  " + fBaseEvent2.getKey() + " is already contained in " + this.myFileName);
                }
                this.purgeEvents(fBaseEvent2.getKey(), true, false);
            }
            fMultiFileStore2.add(fBaseEvent2);
            this.updateEventId();
            if (this.myRecoveryListener != null) {
                this.myRecoveryListener.addEvent(new fMultiFileStoreTempEventHolder(fBaseEvent2.getKey()));
            }
            if (fBaseEvent2.isPersistant()) {
                this.syncStream();
            }
            ++this.myNumberOfEvents;
            if (this.getLastKey() < fBaseEvent2.getKey()) {
                this.setLastEIDMemoryOnly(fBaseEvent2.getKey());
            }
            this.updateEarliestTTLCache(fMultiFileStore2);
            if (!fBaseEvent2.isPersistant() && !this.myDiskOnly) {
                this.incrementMemoryUsage(fBaseEvent2);
            }
            if (this.myCapacity > 0L) {
                this.checkCapacity(this.myCapacity);
            }
            super.add(fBaseEvent2);
            return true;
        }
        catch (IOException iOException) {
            fMultiFileStoreManager.checkIOException(iOException);
            fConstants.logger.error("fMultiFileStoreManager> IO exception when adding event to store", iOException);
            fBaseApplication.getApplication().fileOperationFailure(iOException.getMessage());
            return false;
        }
    }

    private void updateEarliestTTLCache() {
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            this.updateEarliestTTLCache(fMultiFileStore2);
        }
    }

    private void updateEarliestTTLCache(fMultiFileStore fMultiFileStore2) {
        if (fMultiFileStore2.getEarliestTTL() > 0L) {
            this.myEarliestTTL = this.myEarliestTTL == 0L ? fMultiFileStore2.getEarliestTTL() : Math.min(this.myEarliestTTL, fMultiFileStore2.getEarliestTTL());
        }
    }

    @Override
    public synchronized int purgeEvents(long l) {
        return this.purgeEvents(l, true, true);
    }

    @Override
    public synchronized int purgeEvents(long l, long l2) {
        return this.purgeEvents(l, l2, true);
    }

    @Override
    public int purgeEvents(long l, long l2, boolean bl) {
        long l3 = Math.max(l, this.getFirstStoredKey());
        long l4 = Math.min(l2, this.getLastStoredKey());
        int n = 0;
        for (long i = l3; i <= l4; ++i) {
            n += this.purgeEvents(i, bl, true);
        }
        return n;
    }

    @Override
    public synchronized int purgeEvents(long l, long l2, fFilter fFilter2) {
        long l3 = Math.max(l, this.getFirstStoredKey());
        long l4 = Math.min(l2, this.getLastStoredKey());
        int n = 0;
        for (long i = l3; i <= l4; ++i) {
            if (fFilter2 != null) {
                fMultiFileStore fMultiFileStore2 = this.findStore(i, false);
                if (fMultiFileStore2 == null) continue;
                fBaseEvent fBaseEvent2 = null;
                try {
                    fBaseEvent2 = fMultiFileStore2.get(i);
                }
                catch (IOException iOException) {
                    fMultiFileStoreManager.checkIOException(iOException);
                    fConstants.logger.log(iOException);
                }
                if (fBaseEvent2 == null || !fFilter2.isMatch(fBaseEvent2)) continue;
                n += this.purgeEvents(fMultiFileStore2, fBaseEvent2, fBaseEvent2.getKey(), true, true);
                continue;
            }
            n += this.purgeEvents(i);
        }
        return n;
    }

    @Override
    public synchronized fBaseEvent getEvent(long l) {
        fMultiFileStore fMultiFileStore2 = this.findStore(l, false);
        if (fMultiFileStore2 != null) {
            try {
                fBaseEvent fBaseEvent2 = fMultiFileStore2.get(l);
                this.checkForEmptyStore(fMultiFileStore2);
                return fBaseEvent2;
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
        return null;
    }

    @Override
    public synchronized int getEvents(long l, Object[] objectArray) {
        long l2 = l;
        if (l2 < 0L && this.myStore.size() > 0) {
            l2 = this.myStore.get(0).getFirstEID();
        }
        int n = 0;
        fMultiFileStore fMultiFileStore2 = this.findStore(l2, false, true);
        if (fMultiFileStore2 == null) {
            return n;
        }
        l2 = this.getFirstKey(l2, fMultiFileStore2);
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                if (l2 > fMultiFileStore2.getEndKey()) {
                    fMultiFileStore2 = this.findStore(l2, false, true);
                    if (fMultiFileStore2 == null) {
                        return n;
                    }
                    l2 = this.getFirstKey(l2, fMultiFileStore2);
                }
                fBaseEvent fBaseEvent2 = fMultiFileStore2.get(l2);
                while (fBaseEvent2 == null && fMultiFileStore2 != null) {
                    long l3 = fMultiFileStore2.getNextKey(l2);
                    if (l3 == -1L) {
                        l2 = fMultiFileStore2.getEndKey() + 1L;
                        if ((fMultiFileStore2 = this.findStore(l2, false, true)) == null || (fBaseEvent2 = fMultiFileStore2.get(fMultiFileStore2.getStartKey())) != null || (l3 = fMultiFileStore2.getNextKey(fMultiFileStore2.getStartKey())) == -1L) continue;
                        l2 = l3;
                        fBaseEvent2 = fMultiFileStore2.get(l2);
                        continue;
                    }
                    l2 = l3;
                    fBaseEvent2 = fMultiFileStore2.get(l2);
                }
                if (fBaseEvent2 != null) {
                    ++n;
                } else {
                    return n;
                }
                objectArray[i] = fBaseEvent2;
                l2 = fBaseEvent2.getKey() + 1L;
                continue;
            }
            catch (IOException iOException) {
                fConstants.logger.error(iOException);
            }
        }
        return n;
    }

    @Override
    public synchronized long getEventTimeStored(long l) throws fException {
        long l2 = 0L;
        fMultiFileStore fMultiFileStore2 = this.findStore(l, false);
        if (fMultiFileStore2 != null) {
            l2 = fTimer.convertMillisToTick(fMultiFileStore2.getTimeStored(l));
        }
        return l2;
    }

    @Override
    public synchronized boolean containsEvent(long l) {
        fMultiFileStore fMultiFileStore2 = this.findStore(l, false);
        if (fMultiFileStore2 != null) {
            try {
                return fMultiFileStore2.contains(l);
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
        return false;
    }

    @Override
    public synchronized void updateEventId() throws IOException {
        if (this.isActive) {
            this.myStateMap.putLong(0, this.getLastKey());
        } else {
            fConstants.logger.warn("fMultiFileStore> Unable to update the event ID, store has been closed");
        }
    }

    @Override
    public synchronized long getPreviousKey(long l) {
        if (l < 0L) {
            return -1L;
        }
        long l2 = 0L;
        long l3 = l - 1L;
        fMultiFileStore fMultiFileStore2 = this.findStore(l3, false);
        if (fMultiFileStore2 != null && (l2 = fMultiFileStore2.getPreviousKey(l3)) < 0L) {
            l3 = fMultiFileStore2.getStartKey() - 1L;
            return this.getPreviousKey(l3);
        }
        return l2;
    }

    @Override
    protected synchronized int releaseStoreSpace(boolean bl) {
        int n = 0;
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            n += fMultiFileStore2.releaseStoreSpace();
        }
        return n;
    }

    @Override
    public synchronized long usedSpace() {
        long l = 0L;
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            l += fMultiFileStore2.getFileSize();
        }
        return l;
    }

    @Override
    public long getSize() {
        return this.getNoEvents();
    }

    @Override
    public long getPercentFree() {
        return 0L;
    }

    @Override
    public long getUsage() {
        return this.size();
    }

    @Override
    public synchronized long size() {
        int n = 0;
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            n = (int)((long)n + fMultiFileStore2.getEventCount());
        }
        return n;
    }

    @Override
    public synchronized void checkCapacity(long l) {
        if (!this.isActive || l == 0L) {
            return;
        }
        long l2 = 0L;
        long l3 = -1L;
        long l4 = -1L;
        while (l < this.myNumberOfEvents) {
            l4 = l3 == -1L ? (l3 = this.getFirstStoredKey()) : this.getFirstStoredKey();
            l2 += (long)this.purgeEvents(l4, false, true);
        }
    }

    @Override
    public synchronized long maintainCache(long l) {
        return -1L;
    }

    @Override
    public long getTTL() {
        long l = this.myTTL;
        if (this.myEarliestTTL != 0L) {
            l = this.myEarliestTTL - fTimer.currentTimeMillis();
            if (l <= 0L) {
                l = 1000L;
            } else if (this.myTTL != 0L && l > this.myTTL) {
                l = this.myTTL;
            }
        }
        return l;
    }

    @Override
    public synchronized void setAutoPurge(boolean bl) {
        super.setAutoPurge(bl);
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            fMultiFileStore2.setEnableAutoPurge(bl);
        }
    }

    @Override
    public synchronized long checkTTL(long l) {
        long l2 = 0L;
        if (this.isActive && this.myEnableAutoPurge && this.myEarliestTTL != 0L && this.myEarliestTTL < fTimer.currentTimeMillis()) {
            this.myEarliestTTL = 0L;
            for (fMultiFileStore fMultiFileStore2 : this.myStore) {
                fMultiFileStore2.checkTTL();
                this.updateEarliestTTLCache(fMultiFileStore2);
            }
            this.scanForEmptyStores();
        }
        return l2;
    }

    @Override
    public synchronized SortedVector getIndex() {
        SortedVector<fMultiFileStoreTempEventHolder> sortedVector = new SortedVector<fMultiFileStoreTempEventHolder>();
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            BitSet bitSet = fMultiFileStore2.getInternalBitSet();
            int n = 0;
            int n2 = (int)(fMultiFileStore2.getEndKey() - fMultiFileStore2.getStartKey()) + 1;
            while (n < n2) {
                int n3 = bitSet.nextSetBit(n);
                if (n3 >= 0) {
                    long l = fMultiFileStore2.getStartKey() + (long)n3;
                    try {
                        sortedVector.add(new fMultiFileStoreTempEventHolder(l));
                    }
                    catch (Exception exception) {
                        fConstants.logger.warn(exception);
                    }
                    n = n3 + 1;
                    continue;
                }
                n = bitSet.size() + 1;
            }
        }
        return sortedVector;
    }

    @Override
    public String getName() {
        return this.myFileName;
    }

    @Override
    public boolean supportSyncOps() {
        return true;
    }

    @Override
    public boolean eventCanOverrideTTL() {
        return true;
    }

    @Override
    public boolean supportCaching() {
        return false;
    }

    @Override
    public boolean supportMemory() {
        return !this.myDiskOnly;
    }

    @Override
    public boolean supportDisk() {
        return true;
    }

    public void addListener(fMultiFileStoreListener fMultiFileStoreListener2) {
        this.myRecoveryListener = fMultiFileStoreListener2;
    }

    public void delListener(fMultiFileStoreListener fMultiFileStoreListener2) {
        if (this.myRecoveryListener == fMultiFileStoreListener2) {
            this.myRecoveryListener = null;
        }
    }

    @Override
    public void performMaintenance() {
    }

    @Override
    public void performMaintenance(fMaintenanceListener fMaintenanceListener2) {
    }

    @Override
    public void performMaintenance(String string) {
    }

    @Override
    public void performMaintenance(fEventModifier fEventModifier2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performMaintenance(String string, fMaintenanceListener fMaintenanceListener2, fEventModifier fEventModifier2) {
        fMultiFileStoreManager fMultiFileStoreManager2 = this;
        synchronized (fMultiFileStoreManager2) {
            try {
                File[] fileArray;
                fMultiFileStoreManager fMultiFileStoreManager3 = new fMultiFileStoreManager(string, this.myFactory, this.getFirstStoredKey(), this.myIndexManager, this.myTTL, this.myCapacity, this.myDiskOnly, this.myEventsPerStore);
                this.myIndexManager.reset();
                long l = this.getNoEvents();
                fEventIterator fEventIterator2 = new fEventIterator(this);
                int n = 0;
                while ((long)n < l) {
                    fBaseEvent fBaseEvent2 = fEventIterator2.elementAt(n);
                    fMultiFileStoreManager3.putEvent(fEventModifier2.modify(fBaseEvent2));
                    ++n;
                }
                String string2 = this.myFileName;
                this.myFileName = string;
                for (fMultiFileStore comparable2 : this.myStore) {
                    comparable2.close();
                }
                this.myStore.clear();
                this.myStore.addAll(fMultiFileStoreManager3.myStore);
                this.myStateMap.close();
                this.myStoreState.close();
                this.myStateMap = fMultiFileStoreManager3.myStateMap;
                this.myStoreState = fMultiFileStoreManager3.myStoreState;
                boolean bl = false;
                File file = new File(string2);
                if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                    for (File file2 : fileArray) {
                        if (!file2.isDirectory() && file2.delete()) continue;
                        fConstants.logger.error("fMultiFileStoreManager> Error when deleting " + file2.getName());
                        bl = true;
                        break;
                    }
                }
                if (bl || !file.delete()) {
                    fConstants.logger.error("fMultiFileStoreManager> Error when deleting " + file.getName());
                }
            }
            catch (IOException iOException) {
                fConstants.logger.error("fMultiFileStoreManager> Error when converting to a cluster wide channel " + this.myFileName, iOException);
            }
        }
    }

    @Override
    protected long eventHolderSizeEstimate() {
        return 0L;
    }

    private void closeAllStores() {
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            try {
                fMultiFileStore2.close();
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
    }

    private void performConversion() throws IOException {
        this.closeAllStores();
        this.myStore.clear();
        this.myStateMap.getLong(8);
        int n = this.myStateMap.getInt(24);
        this.myStateMap.close();
        this.myStoreState.close();
        File file = new File(this.myFileName);
        File file2 = new File(this.myFileName + "-unsupported_Version");
        if (!file.renameTo(file2)) {
            fConstants.logger.info("MultiFileStore: " + this.myFileName + "> Unable to rename file to " + this.myFileName + "-unsupported_Version");
        }
        if (!file.mkdirs()) {
            fConstants.logger.info("MultiFileStore: " + this.myFileName + "> Unable to create directory structure for the files");
        }
        File file3 = new File(this.myFileName + File.separator + sStateFile);
        this.myStoreState = fFile.openRandomAccessFile(file3, "rw");
        this.myStateMap = new fMemoryMappedBuffer(this.myFileName, this.myStoreState, 32);
        this.myStateMap.putDouble(16, 1.0);
        this.myStateMap.putInt(24, n);
        this.myStateMap.putLong(8, 4537968240197507602L);
        this.myStateMap.position(0);
    }

    private void validateStore() {
    }

    private long getFirstKey(long l, fMultiFileStore fMultiFileStore2) {
        long l2 = fMultiFileStore2.getFirstEID();
        if (fMultiFileStore2.getStartKey() > l2) {
            return fMultiFileStore2.getEndKey() + 1L;
        }
        if (l < l2) {
            return l2;
        }
        return l;
    }

    private fMultiFileStore findStore(long l, boolean bl) {
        return this.findStore(l, bl, false);
    }

    private fMultiFileStore findStore(long l, boolean bl, boolean bl2) {
        int n;
        fMultiFileStore fMultiFileStore2 = null;
        if (l < 0L) {
            l = 0L;
        }
        if ((n = this.myStore.size()) > 0) {
            fMultiFileStore fMultiFileStore3 = this.myStore.get(n - 1);
            int n2 = fMultiFileStore3.compareTo(l);
            if (n2 == 0) {
                fMultiFileStore2 = fMultiFileStore3;
            } else if (n2 > 0) {
                if (this.myStore.get(0).compareTo(l) == 0) {
                    fMultiFileStore2 = this.myStore.get(0);
                } else if (n > 1) {
                    int n3 = Collections.binarySearch(this.myStore, l);
                    if (n3 >= 0) {
                        fMultiFileStore3 = this.myStore.get(n3);
                        if (fMultiFileStore3.compareTo(l) == 0) {
                            fMultiFileStore2 = fMultiFileStore3;
                        }
                    } else if (bl2) {
                        n3 = Math.abs(n3) - 1;
                        fMultiFileStore2 = fMultiFileStore3 = this.myStore.get(n3);
                    }
                } else if (bl2) {
                    fMultiFileStore2 = this.myStore.get(0);
                }
            }
        }
        try {
            if (fMultiFileStore2 == null && bl) {
                long l2 = l / (long)this.myEventsPerStore;
                fMultiFileStore2 = new fMultiFileStore(l2 * (long)this.myEventsPerStore, (l2 + 1L) * (long)this.myEventsPerStore - 1L, this.myFileName + File.separator + l2 * (long)this.myEventsPerStore + "_" + ((l2 + 1L) * (long)this.myEventsPerStore - 1L) + ".mem", this.myFactory, this.myTTL, this.myListener, this.myDiskOnly, this.myCacheType);
                fMultiFileStore2.setEnableAutoPurge(this.myEnableAutoPurge);
                this.myStore.add(fMultiFileStore2);
                Collections.sort(this.myStore, sStoreComparator);
            }
        }
        catch (IOException iOException) {
            fMultiFileStoreManager.checkIOException(iOException);
            fConstants.logger.warn(iOException);
        }
        return fMultiFileStore2;
    }

    private int purgeEvents(long l, boolean bl, boolean bl2) {
        return this.purgeEvents(null, null, l, bl, bl2);
    }

    private int purgeEvents(fMultiFileStore fMultiFileStore2, fBaseEvent fBaseEvent2, long l, boolean bl, boolean bl2) {
        int n = 0;
        if (fMultiFileStore2 == null) {
            fMultiFileStore2 = this.findStore(l, false);
        }
        try {
            if (fMultiFileStore2 != null) {
                if (fMultiFileStore2.contains(l)) {
                    fMultiFileStore2.purge(l, fBaseEvent2, bl);
                    n = 1;
                }
                if (fMultiFileStore2.isEmpty() && bl2) {
                    if (fMultiFileStore2.getStartKey() >= this.getLastKey() || this.getLastKey() >= fMultiFileStore2.getEndKey()) {
                        this.myStore.remove(fMultiFileStore2);
                        fMultiFileStore2.delete();
                    } else {
                        fMultiFileStore2.shrink();
                    }
                }
            }
        }
        catch (IOException iOException) {
            fMultiFileStoreManager.checkIOException(iOException);
            fConstants.logger.log(iOException);
        }
        return n;
    }

    private boolean checkForEmptyStore(fMultiFileStore fMultiFileStore2) {
        if (this.myStore.size() > 1 && fMultiFileStore2.isEmpty()) {
            try {
                this.myStore.remove(fMultiFileStore2);
                fMultiFileStore2.delete();
                return true;
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
        return false;
    }

    private boolean checkForEmptyStore(fMultiFileStore fMultiFileStore2, Iterator<fMultiFileStore> iterator) {
        if (this.myStore.size() > 1 && fMultiFileStore2.isEmpty()) {
            try {
                iterator.remove();
                fMultiFileStore2.delete();
                return true;
            }
            catch (IOException iOException) {
                fMultiFileStoreManager.checkIOException(iOException);
                fConstants.logger.warn(iOException);
            }
        }
        return false;
    }

    private void scanForEmptyStores() {
        if (this.myStore.size() > 1) {
            Iterator<fMultiFileStore> iterator = this.myStore.iterator();
            while (iterator.hasNext() && this.myStore.size() > 1) {
                fMultiFileStore fMultiFileStore2 = iterator.next();
                this.checkForEmptyStore(fMultiFileStore2, iterator);
            }
        }
    }

    int getEventsIncludingPurged(ArrayList<fBaseEvent> arrayList, BitSet bitSet) throws IOException {
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            fMultiFileStore2.getAllIncludingPurged(arrayList, bitSet);
        }
        return arrayList.size();
    }

    private void reloadEvents() throws IOException {
        for (fMultiFileStore fMultiFileStore2 : this.myStore) {
            long l = fMultiFileStore2.getStartKey();
            while (l != -1L) {
                try {
                    fBaseEvent fBaseEvent2 = fMultiFileStore2.get(l);
                    if (fBaseEvent2 != null) {
                        super.add(fBaseEvent2);
                    }
                    l = fMultiFileStore2.getNextKey(l);
                }
                catch (Exception exception) {
                    fConstants.logger.warn("Unable to reload event for key:" + l + ", skipping over for next key");
                    fMultiFileStore2.delete(l);
                    l = fMultiFileStore2.getNextKey(l);
                }
            }
        }
    }

    private class MultiFileStoreDeleteListener
    implements fMultiFileStoreDeleteListener {
        private MultiFileStoreDeleteListener() {
        }

        @Override
        public boolean hasInterest() {
            return fMultiFileStoreManager.this.hasDeleteInterest();
        }

        @Override
        public void purgingEvent(long l, fBaseEvent fBaseEvent2, boolean bl) {
            if (fBaseEvent2 != null) {
                if (!fBaseEvent2.isPersistant() && !fMultiFileStoreManager.this.myDiskOnly) {
                    fMultiFileStoreManager.this.decrementMemoryUsage(fBaseEvent2);
                }
                if (fMultiFileStoreManager.this.hasDeleteInterest()) {
                    fMultiFileStoreManager.super.del(fBaseEvent2, bl);
                }
            }
            if (fMultiFileStoreManager.this.myRecoveryListener != null) {
                fMultiFileStoreManager.this.myRecoveryListener.delEvent(l);
            }
            fMultiFileStoreManager.this.clearKey(l);
            if (!bl && fMultiFileStoreManager.this.myEnableAutoPurge && fMultiFileStoreManager.this.autoDelListener != null) {
                fMultiFileStoreManager.this.autoDelListener.eventsDeletedByManagementTask(l, l);
            }
            fMultiFileStoreManager.this.myNumberOfEvents--;
        }
    }

    private static class FileFilter
    implements FilenameFilter {
        private FileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return !string.equals(fMultiFileStoreManager.sStateFile);
        }
    }

    private static class StoreComparator
    implements Comparator<fMultiFileStore>,
    Serializable {
        private StoreComparator() {
        }

        @Override
        public int compare(fMultiFileStore fMultiFileStore2, fMultiFileStore fMultiFileStore3) {
            long l = fMultiFileStore2.getStartKey() - fMultiFileStore3.getStartKey();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

