/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist;

import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;

public class fPersistentConstants {
    public static final boolean sDebug = fEnvironment.isDebugEnabled("EventManager");
    protected static final int sMixed = 0;
    protected static final int sPeristent = 1;
    protected static final int sMyEventHeaderSize = 12;
    protected static final int sEventHeaderSize = 16;
    protected static final String[] sMyNames = new String[]{"Mixed", "Persistent"};
    protected static int sMaxFileSize = Integer.parseInt(fSystemConfiguration.getProperty("MaxFileSize", fPersistentConstants.getMaintenanceThresholdFileSize() + ""));
    protected static int sMaxMemSize = Integer.parseInt(fSystemConfiguration.getProperty("MaxMemSize", fPersistentConstants.getMaintenanceMemoryThreshold() + ""));
    public static final int CACHE_SIZE = Integer.parseInt(fSystemConfiguration.getProperty("CACHE_SIZE", "10000"));
    protected static int sMyPageSize = 5000;
    private static boolean sAllowCaching = false;
    private static boolean sEnableBufferedReads = true;
    private static long sMaxSyncTime = 1000L;
    private static int sDefaultBatchSize = 50;
    private static int sMaxTimeBetweenSync = 20;
    private static int sBufferSize = 32768;
    private static int sFactoryBufferSize = 0x100000;
    private static int sMaxCacheableSize = 0x100000;
    public static final String PERSISTED_STORE_FILE_EXTENSION = ".mem";

    public static void setMaxFileSize(int n) {
        sMaxFileSize = n;
    }

    public static int getMaxMemSize() {
        return sMaxMemSize;
    }

    public static void setMaxMemSize(int n) {
        sMaxMemSize = n;
    }

    public static int getMaxCacheableSize() {
        return sMaxCacheableSize;
    }

    public static void setMaxCacheableSize(int n) {
        sMaxCacheableSize = n;
    }

    public static int getPageSize() {
        return sMyPageSize;
    }

    public static void setPageSize(int n) {
        sMyPageSize = n;
    }

    public static boolean getAllowCaching() {
        return sAllowCaching;
    }

    public static void setAllowCaching(boolean bl) {
        sAllowCaching = bl;
    }

    public static int getFactoryBufferSize() {
        return sFactoryBufferSize;
    }

    public static void setFactoryBufferSize(int n) {
        sFactoryBufferSize = n;
    }

    public static int getBufferSize() {
        return sBufferSize;
    }

    public static void setBufferSize(int n) {
        sBufferSize = n;
    }

    public static int getDefaultBatchSize() {
        return sDefaultBatchSize;
    }

    public static void setDefaultBatchSize(int n) {
        sDefaultBatchSize = n;
    }

    public static int getMaxTimeBetweenSync() {
        return sMaxTimeBetweenSync;
    }

    public static void setMaxTimeBetweenSync(int n) {
        sMaxTimeBetweenSync = n;
    }

    public static int getMaintenanceThresholdFileSize() {
        return 0x6400000;
    }

    public static int getMaintenanceMemoryThreshold() {
        return 0x6400000;
    }

    public static long getMaxSyncTime() {
        return sMaxSyncTime;
    }

    public static void setMaxSyncTime(long l) {
        sMaxSyncTime = l;
    }
}

