/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.streamHelpers;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFileReader
extends InputStream {
    private final RandomAccessFile myFile;
    private long myFilePos = -1L;
    private final byte[] myBuffer;
    private int myBufPos = -1;
    private int myBufEnd;
    private final ByteArrayInputStream myBufferedRead;

    public BufferedRandomAccessFileReader(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.myFile = randomAccessFile;
        this.myBuffer = new byte[n];
        this.myBufferedRead = new ByteArrayInputStream(this.myBuffer);
    }

    public void seek(long l) throws IOException {
        int n;
        int n2;
        if (this.myFilePos > 0L && (n2 = (int)(l - this.myFilePos)) >= 0 && n2 < this.myBufEnd && (n = n2 - this.myBufPos) >= 0) {
            if ((long)n != this.myBufferedRead.skip(n)) {
                throw new IOException("Unable to skip " + n + " bytes in buffer");
            }
            this.myBufPos += n;
            return;
        }
        this.myFilePos = l;
        this.reloadBuffer();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.myBufPos < 0) {
            this.reloadBuffer();
        }
        if (n2 <= this.myBufEnd - this.myBufPos) {
            int n3 = this.myBufferedRead.read(byArray, n, n2);
            this.myBufPos += n2;
            return n3;
        }
        int n4 = 0;
        if (this.myBufEnd - this.myBufPos > 0) {
            n4 = this.myBufferedRead.read(byArray, n, this.myBufEnd - this.myBufPos);
        }
        this.seek(this.myFilePos + (long)this.myBufEnd);
        this.reloadBuffer();
        return n4;
    }

    @Override
    public int read() throws IOException {
        int n = this.myBufferedRead.read();
        ++this.myBufPos;
        if (this.myBufPos == this.myBufEnd) {
            this.reloadBuffer();
        }
        return n;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.myBufPos = 0;
        if (this.myFilePos != 0L) {
            this.myFilePos = 0L;
            this.reloadBuffer();
        }
    }

    private void reloadBuffer() throws IOException {
        this.myBufferedRead.reset();
        this.myBufPos = 0;
        this.myFile.seek(this.myFilePos);
        this.myBufEnd = this.myFile.read(this.myBuffer, 0, this.myBuffer.length);
        if (this.myBufEnd == -1) {
            throw new EOFException("Attempted to load requested buffer however we have hit EOF");
        }
    }
}

