/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.tasks;

import com.pcbsys.foundation.base.fChangeNotifiable;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.tasks.Constants;
import com.pcbsys.foundation.persist.tasks.fEventManagerTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.util.Random;

public class fCapacityMonitorTask
extends fEventManagerTask {
    private final long myCapacity;
    private long myNextSchedule = 20000L;
    private long myEventsRemoved = 0L;
    private int count = 0;

    public fCapacityMonitorTask(Object object, fEventManager fEventManager2, fChangeNotifiable fChangeNotifiable2, Random random, long l) {
        super(object, fEventManager2, fChangeNotifiable2);
        this.myCapacity = l;
        this.myNextSchedule = (long)random.nextInt((int)(Constants.sMyMaxScheduleTime & Integer.MAX_VALUE)) + Constants.sMyMinScheduleTime;
    }

    public long getCapacity() {
        return this.myCapacity;
    }

    @Override
    public String getName() {
        return "Store Capacity Monitor task for " + this.myManager.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reSchedule() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (super.reSchedule() < 0L) {
                return -1L;
            }
            if (this.myManager.getNoEvents() <= this.myCapacity && this.myEventsRemoved == 0L) {
                ++this.count;
                if (this.count > 5) {
                    this.count = 0;
                    if (Constants.sDebug) {
                        Constants.debug("Stopping Capacity Monitoring for " + this.myManager.getName());
                    }
                    this.isScheduled = false;
                    return -1L;
                }
            }
            return this.myNextSchedule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventAdded() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (!this.isScheduled && this.myManager.getNoEvents() > this.myManager.getCapacity()) {
                this.isScheduled = true;
                if (Constants.sDebug) {
                    Constants.debug("Starting Capacity Monitoring for " + this.myManager.getName());
                }
                fThreadScheduler.getInstance().addTask(this, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.isActive) {
            return;
        }
        if (this.myManager.isActive()) {
            if (Constants.sDebug) {
                Constants.debug("Starting Capacity Monitoring for " + this.myManager.getName());
            }
            Object object = this.mySyncObject;
            synchronized (object) {
                if (this.isPaused) {
                    return;
                }
                long l = this.myManager.getNoEvents();
                this.myManager.checkCapacity(this.myCapacity);
                this.myEventsRemoved = l - this.myManager.getNoEvents();
            }
            if (Constants.sDebug) {
                Constants.debug("Completed Capacity Monitoring for " + this.myManager.getName() + " removed " + this.myEventsRemoved + " events");
            }
            this.myNextSchedule = this.myEventsRemoved > 100L ? Constants.sMyMinScheduleTime : Constants.sMyMaxScheduleTime;
            if (this.myEventsRemoved > 0L && this.myChangeNotifiable != null) {
                this.myChangeNotifiable.hasChanged();
            }
        }
    }
}

