/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.tasks;

import com.pcbsys.foundation.base.fChangeNotifiable;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.fPersistentConstants;
import com.pcbsys.foundation.persist.tasks.Constants;
import com.pcbsys.foundation.persist.tasks.fEventManagerTask;
import java.util.Random;

public class fMaintenanceMonitorTask
extends fEventManagerTask {
    public static final long MAINTENANCE_THRESHOLD_DISABLED = -1L;
    private long myPercentFree = -1L;
    private long myNextSchedule;

    public fMaintenanceMonitorTask(Object object, fEventManager fEventManager2, fChangeNotifiable fChangeNotifiable2, Random random, long l) {
        super(object, fEventManager2, fChangeNotifiable2);
        this.myPercentFree = l;
        this.myNextSchedule = (long)random.nextInt((int)(Constants.sMyMaxScheduleTime & Integer.MAX_VALUE)) + Constants.sMyMinScheduleTime;
    }

    @Override
    public String getName() {
        return "Store Maintenance Monitor task for " + this.myManager.getName();
    }

    public void setPercentFree(int n) {
        this.myPercentFree = n;
    }

    @Override
    public void close() {
        this.myPercentFree = -1L;
    }

    @Override
    public long reSchedule() {
        if (super.reSchedule() < 0L) {
            return -1L;
        }
        if (this.myPercentFree <= 0L) {
            if (Constants.sDebug) {
                Constants.debug("Stopping Auto Maintenance for " + this.myManager.getName());
            }
            return -1L;
        }
        return this.myNextSchedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.isActive || !this.myManager.isActive() || this.myPercentFree <= 0L) {
            return;
        }
        this.myNextSchedule = Constants.sMyMaxScheduleTime;
        if (Constants.sEnableAutoMaintenance) {
            if (this.myPercentFree <= this.myManager.getPercentFree() && this.myManager.usedSpace() > (long)fPersistentConstants.getMaxMemSize()) {
                if (Constants.sDebug) {
                    Constants.debug("Calling Auto Maintenance for " + this.myManager.getName());
                }
                Object object = this.mySyncObject;
                synchronized (object) {
                    this.myManager.performMaintenance();
                }
                if (this.myChangeNotifiable != null) {
                    this.myChangeNotifiable.hasChanged();
                }
                if (Constants.sDebug) {
                    Constants.debug("Completed Auto Maintenance for " + this.myManager.getName());
                }
            } else {
                Constants.debug("Skipping auto maintenance for " + this.myManager.getName() + " file size is less than max threshold (" + this.myManager.usedSpace() + " < " + fPersistentConstants.getMaxMemSize());
            }
        } else if (!Constants.sEnableAutoMaintenance) {
            Constants.log("Auto Maintenance has been disabled on the server, unable to perform maintance for " + this.myManager.getName());
        }
    }
}

