/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.tasks;

import com.pcbsys.foundation.base.fChangeNotifiable;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.persist.fBufferedEventManager;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.fMultiFileStoreManager;
import com.pcbsys.foundation.persist.fStoreMonitor;
import com.pcbsys.foundation.persist.tasks.Constants;
import com.pcbsys.foundation.persist.tasks.fCacheMonitorTask;
import com.pcbsys.foundation.persist.tasks.fCapacityMonitorTask;
import com.pcbsys.foundation.persist.tasks.fEventManagerTask;
import com.pcbsys.foundation.persist.tasks.fMaintenanceMonitorTask;
import com.pcbsys.foundation.persist.tasks.fSyncWriteMonitorTask;
import com.pcbsys.foundation.persist.tasks.fTTLMonitorTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.util.ArrayList;
import java.util.Random;

public class fStoreTaskManager
implements fStoreMonitor {
    private final fEventManager myEventManager;
    private final ArrayList<fEventManagerTask> myTasks;
    private final fChangeNotifiable myChangeNotifiable;
    private final Object mySyncObject;
    private fMaintenanceMonitorTask myMaintenanceMonitor;

    public static boolean isEnableAutoMaintenance() {
        return Constants.sEnableAutoMaintenance;
    }

    public static void setEnableAutoMaintenance(boolean bl) {
        Constants.sEnableAutoMaintenance = bl;
    }

    public static long getCacheAge() {
        return Constants.sMyCacheAge;
    }

    public static void setCacheAge(long l) {
        Constants.sMyCacheAge = l;
    }

    public static int getThreadPoolSize() {
        return Constants.sThreadPoolSize;
    }

    public static void setThreadPoolSize(int n) {
        Constants.sMyThreadPool.setMinimumSize(n);
    }

    public static long getMinScheduleTime() {
        return Constants.sMyMinScheduleTime;
    }

    public static void setMinScheduleTime(long l) {
        Constants.sMyMinScheduleTime = l;
    }

    public static long getMaxScheduleTime() {
        return Constants.sMyMaxScheduleTime;
    }

    public static void setMaxScheduleTime(long l) {
        Constants.sMyMaxScheduleTime = l;
    }

    public fStoreTaskManager(fEventManager fEventManager2, long l, long l2, long l3) {
        this(fEventManager2, null, fEventManager2, l, l2, l3, false);
    }

    public fStoreTaskManager(Object object, fChangeNotifiable fChangeNotifiable2, fEventManager fEventManager2, long l, long l2, long l3, boolean bl) {
        this.myChangeNotifiable = fChangeNotifiable2;
        this.mySyncObject = object;
        this.myEventManager = fEventManager2;
        this.myTasks = new ArrayList();
        this.setupTasks(l, l2, l3, this.myEventManager.supportCaching(), this.myEventManager.getSyncManager().getSyncFlag(), bl);
    }

    private void setupTasks(long l, long l2, long l3, boolean bl, boolean bl2, boolean bl3) {
        Random random = new Random(System.nanoTime());
        this.myMaintenanceMonitor = null;
        if (l3 > 0L) {
            this.myMaintenanceMonitor = new fMaintenanceMonitorTask(this.mySyncObject, this.myEventManager, this.myChangeNotifiable, random, l3);
            this.myTasks.add(this.myMaintenanceMonitor);
        }
        if (l2 > 0L && !bl3) {
            this.myTasks.add(new fCapacityMonitorTask(this.mySyncObject, this.myEventManager, this.myChangeNotifiable, random, l2));
        }
        if (l > 0L || this.myEventManager.eventCanOverrideTTL()) {
            this.myTasks.add(new fTTLMonitorTask(this.mySyncObject, this.myEventManager, this.myChangeNotifiable, random, l));
        }
        if (bl) {
            this.myTasks.add(new fCacheMonitorTask(this.mySyncObject, this.myEventManager, this.myChangeNotifiable, random));
        }
        if ((this.myEventManager instanceof fBufferedEventManager || this.myEventManager instanceof fMultiFileStoreManager) && bl2 && this.myEventManager.getSyncManager().getSyncBatchSize() > 0) {
            this.myTasks.add(new fSyncWriteMonitorTask(this.mySyncObject, this.myEventManager, this.myChangeNotifiable));
        }
        if (this.myTasks.size() > 0) {
            for (fEventManagerTask fEventManagerTask2 : this.myTasks) {
                fThreadScheduler.getInstance().addTask(fEventManagerTask2, fEventManagerTask2.reSchedule());
            }
            this.myEventManager.addMonitor(this);
        }
    }

    public void setMaintThreshold(int n) {
        if (n <= 0) {
            if (this.myMaintenanceMonitor != null) {
                this.myMaintenanceMonitor.close();
                this.myTasks.remove(this.myMaintenanceMonitor);
                this.myMaintenanceMonitor = null;
            }
        } else if (this.myMaintenanceMonitor == null) {
            this.myMaintenanceMonitor = new fMaintenanceMonitorTask(this.mySyncObject, this.myEventManager, this.myChangeNotifiable, new Random(System.nanoTime()), n);
            this.myTasks.add(this.myMaintenanceMonitor);
            fThreadScheduler.getInstance().addTask(this.myMaintenanceMonitor, this.myMaintenanceMonitor.reSchedule());
        } else {
            this.myMaintenanceMonitor.setPercentFree(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        fStoreTaskManager fStoreTaskManager2 = this;
        synchronized (fStoreTaskManager2) {
            for (fEventManagerTask fEventManagerTask2 : this.myTasks) {
                fEventManagerTask2.pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        fStoreTaskManager fStoreTaskManager2 = this;
        synchronized (fStoreTaskManager2) {
            for (fEventManagerTask fEventManagerTask2 : this.myTasks) {
                fEventManagerTask2.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoPurge(boolean bl) {
        if (fConstants.logger.isTraceEnabled()) {
            fConstants.logger.trace("Setting Auto Purge to " + bl + " for store: " + this.myEventManager.getName());
        }
        fStoreTaskManager fStoreTaskManager2 = this;
        synchronized (fStoreTaskManager2) {
            this.myEventManager.setAutoPurge(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mySyncObject;
        synchronized (object) {
            this.myEventManager.addMonitor(null);
            for (fEventManagerTask fEventManagerTask2 : this.myTasks) {
                fEventManagerTask2.close();
                fThreadScheduler.getInstance().delTask(fEventManagerTask2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventAdded() {
        Object object = this.mySyncObject;
        synchronized (object) {
            for (fEventManagerTask fEventManagerTask2 : this.myTasks) {
                fEventManagerTask2.eventAdded();
            }
        }
    }

    @Override
    public void eventRemoved() {
    }
}

