/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.tasks;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fChangeNotifiable;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.persist.fBufferedEventManager;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.tasks.Constants;
import com.pcbsys.foundation.persist.tasks.fEventManagerTask;
import java.io.IOException;

public class fSyncWriteMonitorTask
extends fEventManagerTask {
    private static final long sDefaultRescheduleTime = 10L;

    public fSyncWriteMonitorTask(Object object, fEventManager fEventManager2, fChangeNotifiable fChangeNotifiable2) {
        super(object, fEventManager2, fChangeNotifiable2);
    }

    @Override
    public String getName() {
        return "Store file sync Monitor task for " + this.myManager.getName();
    }

    @Override
    public long reSchedule() {
        if (super.reSchedule() < 0L) {
            return -1L;
        }
        if (this.myManager.getSyncManager().getSyncBatchTime() <= 0) {
            if (Constants.sDebug) {
                Constants.debug("Stopping file sync Monitoring for " + this.myManager.getName());
            }
            return -1L;
        }
        return 10L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.isActive && this.myManager instanceof fBufferedEventManager && this.myManager.getNoEvents() != 0L) {
            try {
                if (Constants.sDebug) {
                    Constants.debug("Calling file sync for " + this.myManager.getName());
                }
                Object object = this.mySyncObject;
                synchronized (object) {
                    this.myManager.getSyncManager().syncStream(false);
                }
                if (Constants.sDebug) {
                    Constants.debug("Completed file sync for " + this.myManager.getName());
                }
            }
            catch (IOException iOException) {
                fConstants.logger.error(iOException);
                fBaseApplication.getApplication().fileOperationFailure("Failed to sync on store " + this.myManager.getName());
            }
        }
    }
}

