/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.persist.tasks;

import com.pcbsys.foundation.base.fChangeNotifiable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.tasks.Constants;
import com.pcbsys.foundation.persist.tasks.fEventManagerTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.util.Random;

public class fTTLMonitorTask
extends fEventManagerTask {
    private final long myTTL;
    private long myNextTTLScan;

    fTTLMonitorTask(Object object, fEventManager fEventManager2, fChangeNotifiable fChangeNotifiable2, Random random, long l) {
        super(object, fEventManager2, fChangeNotifiable2);
        this.myNextTTLScan = this.myTTL = l;
    }

    @Override
    public String getName() {
        return "Store TTL Monitor task for " + this.myManager.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reSchedule() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (super.reSchedule() < 0L) {
                this.isScheduled = false;
                return -1L;
            }
            if (this.myManager.getNoEvents() == 0L) {
                this.isScheduled = false;
                if (Constants.sDebug) {
                    Constants.debug("Stopping monitor for TTL on for " + this.myManager.getName());
                }
                return -1L;
            }
            this.isScheduled = this.myNextTTLScan != -1L;
            return this.myNextTTLScan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventAdded() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (this.myManager.getNoEvents() != 0L && !this.isScheduled) {
                this.isScheduled = true;
                if (Constants.sDebug) {
                    Constants.debug("Starting monitor for TTL on for " + this.myManager.getName());
                }
                fThreadScheduler.getInstance().addTask(this, 1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        long l = 0L;
        if (!this.isActive || !this.myManager.isActive()) {
            return;
        }
        this.myNextTTLScan = this.myTTL;
        if (Constants.sDebug) {
            Constants.debug("Calling monitor for TTL on for " + this.myManager.getName() + ", Paused: " + this.isPaused);
        }
        Object object = this.mySyncObject;
        synchronized (object) {
            if (this.isPaused) {
                return;
            }
            long l2 = this.myManager.getNoEvents();
            if (l2 != 0L) {
                this.myManager.checkTTL(this.myTTL);
                l = l2 - this.myManager.getNoEvents();
                if (l > 0L && this.myChangeNotifiable != null) {
                    this.myChangeNotifiable.hasChanged();
                }
            }
            if (Constants.sDebug) {
                Constants.debug("Completed monitor for TTL on for " + this.myManager.getName() + " cleared " + l + " events");
            }
            if (this.myManager.getNoEvents() > 0L) {
                long l3 = this.myManager.getTTL();
                if (l3 > 0L) {
                    try {
                        if (this.myTTL != l3) {
                            this.myNextTTLScan = l3;
                        } else {
                            long l4 = this.myManager.getEventTimeStored(this.myManager.getFirstStoredKey());
                            if (l4 != 0L) {
                                this.myNextTTLScan = this.myTTL - (fTimer.getTicks() - l4);
                            }
                        }
                        if (this.myNextTTLScan < Constants.sMyMinScheduleTime) {
                            this.myNextTTLScan = Constants.sMyMinScheduleTime;
                        } else if (this.myNextTTLScan > Constants.sMyMaxScheduleTime) {
                            this.myNextTTLScan = Constants.sMyMaxScheduleTime;
                        }
                    }
                    catch (Exception exception) {
                        fConstants.logger.info(exception);
                    }
                } else {
                    this.myNextTTLScan = Constants.sMyMaxScheduleTime;
                }
            } else {
                this.myNextTTLScan = Constants.sMyMaxScheduleTime;
            }
        }
    }
}

