/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.scheduler.parser.grammer;

import com.pcbsys.foundation.scheduler.parser.grammer.Token;
import com.pcbsys.foundation.utils.fSystemConfiguration;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = fSystemConfiguration.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n < this.expectedTokenSequences[i].length) {
                n = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                stringBuilder.append(this.tokenImage[this.expectedTokenSequences[i][j]]).append(" ");
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                stringBuilder.append("...");
            }
            stringBuilder.append(this.eol).append("    ");
        }
        StringBuilder stringBuilder2 = new StringBuilder().append("Encountered \"");
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder2.append(" ");
            }
            if (token.kind == 0) {
                stringBuilder2.append(this.tokenImage[0]);
                break;
            }
            stringBuilder2.append(this.add_escapes(token.image));
            token = token.next;
        }
        stringBuilder2.append("\" at line ").append(this.currentToken.next.beginLine).append(", column ").append(this.currentToken.next.beginColumn);
        stringBuilder2.append(".").append(this.eol);
        if (this.expectedTokenSequences.length == 1) {
            stringBuilder2.append("Was expecting:").append(this.eol).append("    ");
        } else {
            stringBuilder2.append("Was expecting one of:").append(this.eol).append("    ");
        }
        stringBuilder2.append(stringBuilder.toString());
        return stringBuilder2.toString();
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

