/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.auth;

import com.pcbsys.foundation.drivers.fSubjectHelper;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.logger.fLogger;
import com.pcbsys.foundation.security.auth.fAdapterDirectory;
import com.pcbsys.foundation.security.auth.fAuthConstants;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDefaultSecureObject;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.security.sasl.Defs;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.softwareag.security.jaas.login.SagCallbackHandler;
import com.softwareag.security.jaas.login.SagCredentials;
import com.softwareag.security.jaas.principals.SagUserPrincipal;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class fAuthentication {
    public static final boolean authenticationEnabled = "Y".equalsIgnoreCase(fSystemConfiguration.getProperty("Nirvana.auth.enabled", "N"));
    public static final boolean authenticationMandatory = "Y".equalsIgnoreCase(fSystemConfiguration.getProperty("Nirvana.auth.mandatory", "N")) && authenticationEnabled;
    public static final String SYSPROP_JAASKEY = "Nirvana.auth.server.jaaskey";
    public static final String SYSPROP_EXEMPTUSERS = "Nirvana.auth.exempt";
    public static String JAASKEY = fSystemConfiguration.getProperty("Nirvana.auth.server.jaaskey");
    private static final ArrayList<String> exemptUsers = fAuthentication.getExemptUsers();
    private static final String REALM_EXEMPTION_STRING = "realm-";

    public static boolean isEnabledDirectory() {
        return authenticationEnabled && JAASKEY == null;
    }

    public static boolean isJAASEnabled() {
        return authenticationEnabled && JAASKEY != null;
    }

    public static String authenticate(String string, String string2) throws fAuthenticationException, IOException {
        if (string == null || string.length() == 0) {
            throw new fAuthenticationException("Authentication failure - no username supplied.");
        }
        if (JAASKEY != null) {
            String string3 = fAuthentication.authenticateJAAS(string, string2);
            if (string3 != null) {
                return string3.toLowerCase();
            }
            throw new fAuthenticationException("Authentication failure - no authenticated user found.");
        }
        if (fAuthentication.isEnabledDirectory()) {
            try {
                boolean bl = fAdapterDirectory.getInstance().verifyPassword(string, string2);
                if (bl) {
                    return string.toLowerCase();
                }
                throw new fAuthenticationException("Authentication failed - directory adapter rejected the username/password.");
            }
            catch (NamingException namingException) {
                throw new fAuthenticationException(namingException);
            }
        }
        throw new fAuthenticationException("Authentication failure - no authentication backend configured.");
    }

    public static String authenticate(SagCredentials sagCredentials) throws fAuthenticationException, IOException {
        if (sagCredentials == null) {
            throw new fAuthenticationException("Authentication failure - no credentials supplied.");
        }
        if (JAASKEY != null) {
            String string = fAuthentication.authenticateJAAS(sagCredentials);
            if (string != null) {
                return string.toLowerCase();
            }
            throw new fAuthenticationException("Authentication failure - no authenticated user found.");
        }
        if (fAuthentication.isEnabledDirectory()) {
            try {
                String string = sagCredentials.getUserName();
                char[] cArray = sagCredentials.getPassword();
                String string2 = cArray == null ? null : new String(cArray);
                boolean bl = fAdapterDirectory.getInstance().verifyPassword(string, string2);
                if (bl) {
                    return string.toLowerCase();
                }
                throw new fAuthenticationException("Authentication failed - directory adapter rejected the username/password.");
            }
            catch (NamingException namingException) {
                throw new fAuthenticationException(namingException);
            }
        }
        throw new fAuthenticationException("Authentication failure - no authentication backend configured.");
    }

    private static String authenticateJAAS(String string, String string2) throws fAuthenticationException {
        SagCredentials sagCredentials = fAuthentication.constructCredentials(string, string2);
        return fAuthentication.authenticateJAAS(sagCredentials);
    }

    private static String authenticateJAAS(SagCredentials sagCredentials) throws fAuthenticationException {
        try {
            LoginContext loginContext = new LoginContext(JAASKEY, (CallbackHandler)new SagCallbackHandler(sagCredentials));
            loginContext.login();
            Subject subject = loginContext.getSubject();
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(Defs.JAASLoginContext2String(loginContext, sagCredentials.getUserName()));
            }
            String string = fAuthentication.extractUser(subject);
            loginContext.logout();
            return string;
        }
        catch (LoginException loginException) {
            throw new fAuthenticationException("JAAS-Authentication failed on username=" + sagCredentials.getUserName(), loginException);
        }
    }

    private static String extractUser(Subject subject) {
        String string;
        Object object;
        SagUserPrincipal sagUserPrincipal;
        Set<Principal> set;
        if (subject == null) {
            if (fAuthConstants.sDebug) {
                fConstants.logger.log("Subject is null - unable to extract user principal.");
            }
            return null;
        }
        if (fAuthConstants.sDebug) {
            set = subject.getPrincipals();
            if (set == null || set.size() == 0) {
                fConstants.logger.log("Found no principals in the JAAS subject.");
            } else {
                fConstants.logger.log("Found the following principals in the JAAS subject:");
                sagUserPrincipal = set.iterator();
                while (sagUserPrincipal.hasNext()) {
                    object = (Principal)sagUserPrincipal.next();
                    fConstants.logger.log(" - " + object.getName() + " : " + object.getClass().getName());
                }
            }
        }
        if ((set = subject.getPrincipals(SagUserPrincipal.class)).size() == 0) {
            fLogger.log.report(5, "No user principals found in authentication result.");
            return null;
        }
        if (set.size() > 1) {
            fLogger.log.report(3, "Multiple user principals [" + set.size() + "] found in authentication result. Using the first one for authorization.");
        }
        if (!(string = fSubjectHelper.extractCN((String)(object = (sagUserPrincipal = (SagUserPrincipal)set.iterator().next()).getName()))).isEmpty()) {
            return string;
        }
        return object;
    }

    public static SagCredentials constructCredentials(String string, String string2) {
        SagCredentials sagCredentials = new SagCredentials();
        sagCredentials.setUserName(string);
        sagCredentials.setPassword(string2.toCharArray());
        return sagCredentials;
    }

    public static boolean isExempt(fSubject fSubject2) {
        String string = fSubject2.getName();
        List<fSubject> list = fDefaultSecureObject.getSuperUsers();
        for (fSubject fSubject3 : list) {
            if (!fSubject3.getName().toLowerCase().contains(string.toLowerCase())) continue;
            return true;
        }
        if (string.startsWith(REALM_EXEMPTION_STRING)) {
            return true;
        }
        if (exemptUsers != null) {
            for (int i = 0; i != exemptUsers.size(); ++i) {
                if (!exemptUsers.get(i).equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getExemptUsers() {
        String string = fSystemConfiguration.getProperty(SYSPROP_EXEMPTUSERS);
        if (string == null) {
            string = fSystemConfiguration.getProperty("SECURITYFILE");
        }
        if (string == null || string.equals("-")) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = null;
            try {
                String string2;
                inputStreamReader = new InputStreamReader(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 4096);
                while ((string2 = bufferedReader.readLine()) != null) {
                    arrayList.add(string2.trim());
                }
            }
            finally {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                fileInputStream.close();
            }
        }
        catch (Throwable throwable) {
            fConstants.logger.error("Failed to load exempt users from " + string + " - " + throwable);
            arrayList = null;
        }
        return arrayList;
    }

    static {
        fConstants.logger.log("Server Authentication: Enabled=" + authenticationEnabled + ", Mandatory=" + authenticationMandatory + ", JAAS-key=" + JAASKEY + ", SuperUser=" + fDefaultSecureObject.getDefaultSuperUser().getName() + ", Exempt=" + (exemptUsers == null ? "n/a" : exemptUsers.size() + "/" + exemptUsers));
    }
}

