/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.auth;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.auth.fAttribute;
import com.pcbsys.foundation.security.auth.fLookupAdapter;
import com.pcbsys.foundation.security.auth.fMemoryDirectory;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;

public abstract class fFileDirectory
extends fLookupAdapter {
    public static final String SYSPROP_REPOPATH = "Nirvana.auth.filedirectory.path";
    public static final long MAXRELOADFREQ = fFileDirectory.getReloadFrequency("Nirvana.auth.minreloadtime", 2L) * 1000L;
    private final File dtoryPath;
    private volatile fMemoryDirectory directory;
    private volatile long lastModified;
    private volatile long lastChecked;

    protected abstract void loadUsers(fMemoryDirectory var1, InputStream var2) throws IOException;

    public File getPath() {
        return this.dtoryPath;
    }

    fFileDirectory(String string) {
        this.dtoryPath = new File(string);
    }

    @Override
    public List<fAttribute> lookup(String string, List<String> list) throws IOException {
        this.reloadUsers();
        fMemoryDirectory fMemoryDirectory2 = this.directory;
        if (fMemoryDirectory2 == null) {
            return null;
        }
        return fMemoryDirectory2.lookup(string, list);
    }

    public int size() throws IOException {
        this.reloadUsers();
        return this.directory.size();
    }

    public boolean exists(String string) throws IOException {
        this.reloadUsers();
        return this.directory.exists(string);
    }

    public Set<String> getUsernames() throws IOException {
        this.reloadUsers();
        return this.directory.getUsernames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadUsers() throws IOException {
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < MAXRELOADFREQ) {
            return;
        }
        long l2 = this.dtoryPath.lastModified();
        if (l2 == 0L) {
            this.directory = new fMemoryDirectory();
            return;
        }
        if (l2 <= this.lastModified) {
            return;
        }
        fMemoryDirectory fMemoryDirectory2 = new fMemoryDirectory();
        try (FileInputStream fileInputStream = new FileInputStream(this.dtoryPath);){
            this.loadUsers(fMemoryDirectory2, fileInputStream);
        }
        fMemoryDirectory2.ensureUsernameAttributes();
        this.directory = fMemoryDirectory2;
        this.lastModified = l2;
        this.lastChecked = l;
        fConstants.logger.log("Directory=" + this.getClass().getName() + " loaded userfile=" + this.dtoryPath.getAbsolutePath() + " - entries=" + this.size() + "/" + this.getUsernames());
    }

    private static long getReloadFrequency(String string, long l) {
        String string2 = fSystemConfiguration.getProperty(string, String.valueOf(l));
        try {
            return Long.parseLong(string2);
        }
        catch (Throwable throwable) {
            System.out.println("Failed to parse system-property as an Int, falling back to default=" + l + " - " + string + "=" + string2 + " - " + throwable);
            return l;
        }
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + "/size=" + this.size() + "/" + this.getUsernames();
        }
        catch (Exception exception) {
            return this.getClass().getSimpleName() + "/" + exception;
        }
    }
}

