/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.auth;

import com.pcbsys.foundation.security.auth.fAttribute;
import com.pcbsys.foundation.security.auth.fFileDirectory;
import com.pcbsys.foundation.security.auth.fMemoryDirectory;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import javax.naming.NamingException;
import javax.xml.bind.DatatypeConverter;

public class fSAGInternalUserRepositoryAdapter
extends fFileDirectory {
    private static final String DEFAULT_HASH = "SHA-512";
    private static final String REPOPATH_LEGACYCOMPAT = fSystemConfiguration.getProperty("Nirvana.auth.sagrepo.path", "./users.txt");
    private static final String DEFAULT_PATH = fSystemConfiguration.getProperty("Nirvana.auth.filedirectory.path", REPOPATH_LEGACYCOMPAT);
    private static final String HASHTYPE = fSystemConfiguration.getProperty("Nirvana.auth.sagrepo.hash", "SHA-512");
    private static final String MARK_COMMENT = fSystemConfiguration.getProperty("Nirvana.auth.sagrepo.comment", "*");
    private static final String RECTYPE_USER = fSystemConfiguration.getProperty("Nirvana.auth.sagrepo.rectype.user", "user");
    private static final String DLM_FIELDS = ":";
    static final String SALT = fSystemConfiguration.getProperty("Nirvana.auth.sagrepo.salt", "$6a$");

    public fSAGInternalUserRepositoryAdapter() {
        this(DEFAULT_PATH);
    }

    public fSAGInternalUserRepositoryAdapter(String string) {
        super(string);
    }

    @Override
    public boolean verifyPassword(String string, String string2) throws NamingException, IOException {
        fAttribute fAttribute2 = this.lookup(string, "PASSWORD");
        if (fAttribute2 == null) {
            return false;
        }
        Object object = fAttribute2.getValue();
        String string3 = fSAGInternalUserRepositoryAdapter.hashedPassword(string, string2);
        return string3.equals(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadUsers(fMemoryDirectory fMemoryDirectory2, InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 4096);){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string.length() == 0 || string.startsWith(MARK_COMMENT) || (stringArray = string.split(DLM_FIELDS)).length < 3 || !stringArray[0].equals(RECTYPE_USER)) continue;
                String string2 = stringArray[1];
                String string3 = stringArray[2].substring(SALT.length());
                fAttribute fAttribute2 = new fAttribute("PASSWORD", string3);
                fMemoryDirectory2.setAttribute(string2, fAttribute2);
            }
        }
    }

    public static String hashedPassword(String string, String string2) {
        return fSAGInternalUserRepositoryAdapter.hashedPassword(string, string2, null);
    }

    public static String hashedPassword(String string, String string2, String string3) {
        MessageDigest messageDigest;
        if (string3 == null) {
            string3 = HASHTYPE;
        }
        try {
            messageDigest = MessageDigest.getInstance(string3);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to obtain Digest algorithm=" + string3, exception);
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byte[] byArray4 = messageDigest.digest(byArray3);
        String string4 = DatatypeConverter.printBase64Binary((byte[])byArray4);
        return string4;
    }
}

