/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.fDeregisterGroupUpdate;
import com.pcbsys.foundation.security.fGroupTTLManager;
import com.pcbsys.foundation.security.fGroupTimeout;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class fAclGroup
extends fSubject
implements Observer {
    private final ConcurrentMap<String, fSubject> myMembers;
    private final SubjectIndexer myHosts;
    private final SubjectIndexer myNames;
    private final GroupIndexer myGroups;
    private final fACLGroupObservable membersObservable = new fACLGroupObservable();
    private fGroupTTLManager ttlManager;
    private fGroupTimeout manager;

    public fAclGroup() {
        this.myMembers = new ConcurrentHashMap<String, fSubject>();
        this.myHosts = new SubjectIndexer();
        this.myNames = new SubjectIndexer();
        this.myGroups = new GroupIndexer();
    }

    public fAclGroup(String string) {
        super(string);
        this.myMembers = new ConcurrentHashMap<String, fSubject>();
        this.myHosts = new SubjectIndexer();
        this.myNames = new SubjectIndexer();
        this.myGroups = new GroupIndexer();
    }

    public fAclGroup(String string, List<fSubject> list) {
        super(string);
        this.myMembers = new ConcurrentHashMap<String, fSubject>();
        this.myHosts = new SubjectIndexer();
        this.myNames = new SubjectIndexer();
        this.myGroups = new GroupIndexer();
        for (fSubject fSubject2 : list) {
            this.add(fSubject2);
        }
    }

    public void addAll(Collection<fSubject> collection) {
        for (fSubject fSubject2 : collection) {
            this.add(fSubject2);
        }
    }

    public void add(fSubject fSubject2) {
        if (fSubject2 instanceof fAclGroup) {
            ((fAclGroup)fSubject2).addObserver(this);
            this.myGroups.put(fSubject2.getName().toLowerCase(), (fAclGroup)fSubject2);
        } else if (fSubject2 != null) {
            if (fSubject2.getUser() != null) {
                this.myMembers.put(fSubject2.toString(), fSubject2);
                if (fSubject2.getUser().equals("*")) {
                    this.myHosts.put(fSubject2.getHost(), fSubject2);
                }
                if (fSubject2.getHost().equals("*")) {
                    this.myNames.put(fSubject2.getUser(), fSubject2);
                }
            } else {
                fConstants.logger.log("Found corrupted data during the add of " + fSubject2.toString() + " into group " + this.getName());
            }
        }
        this.membersObservable.setChanged();
        this.membersObservable.notifyObservers(this);
    }

    public void addObserver(Observer observer) {
        this.membersObservable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.membersObservable.deleteObserver(observer);
    }

    public List<fSubject> getMembers() {
        ArrayList<fSubject> arrayList = new ArrayList<fSubject>();
        arrayList.addAll(this.myMembers.values());
        arrayList.addAll(this.myGroups.myMapping.values());
        return arrayList;
    }

    public boolean contains(String string) {
        if (this.myMembers.containsKey(string = string.toLowerCase()) || this.myGroups.myMapping.containsKey(string)) {
            return true;
        }
        if (this.myGroups.myMapping.size() > 0) {
            for (Map.Entry entry : this.myGroups.myMapping.entrySet()) {
                if (!((fAclGroup)entry.getValue()).contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public fSubject get(String string) {
        return (fSubject)this.myMembers.get(string.toLowerCase());
    }

    public fSubject get(fSubject fSubject2) {
        return (fSubject)this.myMembers.get(fSubject2.toString());
    }

    public fSubject remove(fSubject fSubject2) {
        this.myHosts.remove(fSubject2.getHost());
        this.myNames.remove(fSubject2.getUser());
        this.myGroups.remove(fSubject2.getKey().toLowerCase());
        this.membersObservable.setChanged();
        this.membersObservable.notifyObservers(this);
        return (fSubject)this.myMembers.remove(fSubject2.toString());
    }

    public fSubject remove(String string) {
        fSubject fSubject2 = (fSubject)this.myMembers.remove(string = string.toLowerCase());
        if (fSubject2 != null) {
            this.myHosts.remove(fSubject2.getHost());
            this.myNames.remove(fSubject2.getUser());
        } else {
            this.myGroups.remove(string);
        }
        this.membersObservable.setChanged();
        this.membersObservable.notifyObservers(this);
        return fSubject2;
    }

    public fSubject lookup(fSubject fSubject2) {
        fSubject fSubject3 = (fSubject)this.myMembers.get(fSubject2.getKey().toLowerCase());
        if (fSubject3 == null) {
            fSubject3 = this.myNames.lookup(fSubject2.getUser());
        }
        if (fSubject3 == null) {
            fSubject3 = this.myHosts.lookup(fSubject2.getHost());
        }
        if (fSubject3 == null) {
            fSubject3 = this.myGroups.lookup(fSubject2.getName().toLowerCase());
        }
        if (fSubject3 == null && this.myGroups.myMapping.size() > 0) {
            for (Map.Entry entry : this.myGroups.myMapping.entrySet()) {
                fSubject3 = ((fAclGroup)entry.getValue()).lookup(fSubject2);
                if (fSubject3 == null) continue;
                return fSubject3;
            }
        }
        return fSubject3;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public String toString() {
        String string = "Group: " + this.getName();
        if (this.myMembers != null) {
            string = string + this.myMembers.toString();
        }
        if (this.myGroups != null) {
            string = string + this.myGroups.toString();
        }
        if (this.myHosts != null) {
            string = string + this.myHosts.toString();
        }
        if (this.myNames != null) {
            string = string + this.myNames.toString();
        }
        return string;
    }

    @Override
    public String getUser() {
        return this.m_key;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n = fEventInputStream2.readInt();
        if (n == 2) {
            this.mask = fEventInputStream2.readLong();
            this.readExternalfAclGroup(fEventInputStream2);
        } else if (n == 0) {
            this.readExternal(fEventInputStream2);
        } else {
            this.readExternalfSubject(fEventInputStream2, n);
        }
    }

    void readExternalfAclGroup(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        this.m_key = fEventInputStream2.readString();
        int n2 = fEventInputStream2.readInt();
        for (n = 0; n < n2; ++n) {
            fSubject fSubject2;
            int n3 = fEventInputStream2.readInt();
            if (n3 == 0) {
                fSubject2 = new fSubject();
                fSubject2.mask = fEventInputStream2.readLong();
                fSubject2.readExternalfSubject(fEventInputStream2, fEventInputStream2.readInt());
            } else {
                fSubject2 = new fAclGroup();
                fSubject2.mask = fEventInputStream2.readLong();
                ((fAclGroup)fSubject2).readExternalfAclGroup(fEventInputStream2);
            }
            this.add(fSubject2);
        }
        n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            String string = fEventInputStream2.readString();
            fAclGroup fAclGroup2 = new fAclGroup(string);
            fAclGroup2.addObserver(this);
            this.myGroups.put(string.toLowerCase(), fAclGroup2);
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeInt(2);
        fEventOutputStream2.writeLong(this.mask);
        fEventOutputStream2.writeString(this.m_key);
        Object[] objectArray = this.myMembers.values().toArray();
        fEventOutputStream2.writeInt(objectArray.length);
        for (Object object : objectArray) {
            ((fSubject)object).writeExternal(fEventOutputStream2);
        }
        Object[] objectArray2 = this.myGroups.myMapping.values().toArray();
        fEventOutputStream2.writeInt(objectArray2.length);
        for (Object object : objectArray2) {
            fEventOutputStream2.writeString(((fAclGroup)object).getName());
        }
    }

    public void addAll(Collection<fSubject> collection, long l) {
        if (this.ttlManager == null) {
            this.ttlManager = new fGroupTTLManager(this, 5000, this.manager);
            fThreadScheduler.getInstance().addTask(this.ttlManager, this.ttlManager.reSchedule());
        }
        for (fSubject fSubject2 : collection) {
            this.ttlManager.add(fSubject2, l);
            this.add(fSubject2);
        }
    }

    public void setManager(fGroupTimeout fGroupTimeout2) {
        this.manager = fGroupTimeout2;
    }

    public void deregister() {
        this.membersObservable.setChanged();
        this.membersObservable.notifyObservers(new fDeregisterGroupUpdate(this));
        this.membersObservable.dereg();
    }

    public Collection<fAclGroup> getGroups() {
        return this.myGroups.myMapping.values();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof fDeregisterGroupUpdate) {
            fDeregisterGroupUpdate fDeregisterGroupUpdate2 = (fDeregisterGroupUpdate)object;
            try {
                fDeregisterGroupUpdate2.getfAclGroup().deleteObserver(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myGroups.remove(fDeregisterGroupUpdate2.getfAclGroup().getName().toLowerCase());
            this.membersObservable.setChanged();
            this.membersObservable.notifyObservers(null);
        } else {
            this.membersObservable.setChanged();
            this.membersObservable.notifyObservers(object);
        }
    }

    @Override
    public String getName() {
        return this.m_key;
    }

    private static final class fACLGroupObservable
    extends Observable {
        private fACLGroupObservable() {
        }

        void dereg() {
            this.deleteObservers();
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }

    private static final class GroupIndexer {
        private final ConcurrentMap<String, fAclGroup> myMapping = new ConcurrentHashMap<String, fAclGroup>();

        GroupIndexer() {
        }

        public void put(String string, fAclGroup fAclGroup2) {
            string = string.toLowerCase();
            this.myMapping.put(string, fAclGroup2);
        }

        public fAclGroup lookup(String string) {
            string = string.toLowerCase();
            return (fAclGroup)this.myMapping.get(string);
        }

        public void remove(String string) {
            string = string.toLowerCase();
            this.myMapping.remove(string);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (fAclGroup fAclGroup2 : this.myMapping.values()) {
                stringBuilder.append(fAclGroup2.toString());
            }
            return stringBuilder.toString();
        }
    }

    private static final class SubjectIndexer {
        private final ConcurrentMap<String, fSubject> myMapping = new ConcurrentHashMap<String, fSubject>();

        SubjectIndexer() {
        }

        public void put(String string, fSubject fSubject2) {
            string = string.toLowerCase();
            this.myMapping.putIfAbsent(string, fSubject2);
        }

        public fSubject lookup(String string) {
            string = string.toLowerCase();
            return (fSubject)this.myMapping.get(string);
        }

        public void remove(String string) {
            string = string.toLowerCase();
            this.myMapping.remove(string);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (fSubject fSubject2 : this.myMapping.values()) {
                stringBuilder.append(fSubject2.toString());
            }
            return stringBuilder.toString();
        }
    }
}

