/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.collections.fast.String2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.fAclEntry;
import com.pcbsys.foundation.security.fAclEntryFactory;
import com.pcbsys.foundation.security.fAclGroup;
import com.pcbsys.foundation.security.fDeregisterGroupUpdate;
import com.pcbsys.foundation.security.fSecurityManager;
import com.pcbsys.foundation.security.fSubject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class fAclList
extends Observable
implements Observer {
    private static final fAclEntryFactory sMyFactory = fAclEntryFactory.getInstance();
    private final String2ObjectOpenAddressingHashMap<fAclEntry> myACL = new String2ObjectOpenAddressingHashMap();
    private final String2ObjectOpenAddressingHashMap<fAclEntry> myHostLookup = new String2ObjectOpenAddressingHashMap();
    private final String2ObjectOpenAddressingHashMap<fAclEntry> myNameLookup = new String2ObjectOpenAddressingHashMap();
    private final String2ObjectOpenAddressingHashMap<fAclGroup> myGroups = new String2ObjectOpenAddressingHashMap();
    private fAclEntry myWildcardEntry = null;

    public synchronized fAclList getClone() {
        fAclList fAclList2 = new fAclList();
        Iterator<fAclEntry> iterator = this.getIterator();
        while (iterator.hasNext()) {
            fAclEntry fAclEntry2 = iterator.next();
            fAclList2.myACL.put(fAclEntry2.getSubject().getName(), fAclEntry2);
        }
        return fAclList2;
    }

    public synchronized void clear() {
        for (fAclGroup fBaseTransportObject2 : this.myGroups.values()) {
            try {
                fBaseTransportObject2.deleteObserver(this);
            }
            catch (Exception exception) {}
        }
        this.myHostLookup.clear();
        this.myNameLookup.clear();
        for (fAclEntry fAclEntry2 : this.myACL.values()) {
            fAclEntryFactory.getInstance().delEntry(fAclEntry2.getSubject(), fAclEntry2.getPriv());
        }
        this.myACL.clear();
        this.myWildcardEntry = null;
    }

    public synchronized void add(fSubject fSubject2, long l) {
        fAclEntry fAclEntry2 = new fAclEntry(fSubject2, l);
        this.add(fAclEntry2);
    }

    public synchronized void add(fAclEntry fAclEntry2) {
        this.add(fAclEntry2, true);
    }

    public synchronized void add(fAclEntry fAclEntry2, boolean bl) {
        fAclEntry fAclEntry3 = this.myACL.get(fAclEntry2.getSubject().getName());
        if (fAclEntry3 != null) {
            fAclEntryFactory.getInstance().delEntry(fAclEntry2.getSubject(), fAclEntry3.getPriv());
            this.myACL.remove(fAclEntry2.getSubject().getName());
            if (fAclEntry3.getSubject().isGroup()) {
                this.myGroups.remove(fAclEntry3.getSubject().getName());
            }
        }
        if (!(fAclEntry2.getSubject() instanceof fAclGroup)) {
            this.myACL.put(fAclEntry2.getSubject().getName(), sMyFactory.createEntry(fAclEntry2.getSubject(), fAclEntry2.getPriv()));
            if (fAclEntry2.getSubject().getName().equals("*@*")) {
                this.myWildcardEntry = fAclEntry2;
            } else if (fAclEntry2.getSubject().getUser().equals("*")) {
                this.myHostLookup.put(fAclEntry2.getSubject().getHost(), fAclEntry2);
            } else if (fAclEntry2.getSubject().getHost().equals("*")) {
                this.myNameLookup.put(fAclEntry2.getSubject().getUser(), fAclEntry2);
            }
        } else {
            this.myACL.put(fAclEntry2.getSubject().getName(), new fAclEntry(fAclEntry2.getSubject(), fAclEntry2.getPriv()));
            if (fAclEntry2.getSubject().isGroup()) {
                fAclGroup fAclGroup2 = (fAclGroup)fAclEntry2.getSubject();
                if (bl && this.shouldRegisterForUpdate(fAclGroup2)) {
                    fAclGroup2.addObserver(this);
                }
                this.myGroups.put(fAclGroup2.getName(), fAclGroup2);
            }
        }
    }

    private boolean shouldRegisterForUpdate(fAclGroup fAclGroup2) {
        return !fAclGroup2.getName().equalsIgnoreCase(fSecurityManager.getInstance().getEveryoneGroup().getName());
    }

    public fAclEntry get(fSubject fSubject2) {
        return this.find(fSubject2);
    }

    public fAclEntry remove(fSubject fSubject2) {
        return this.remove(fSubject2.getName());
    }

    public fAclEntry remove(fAclEntry fAclEntry2) {
        return this.remove(fAclEntry2.getSubject());
    }

    public synchronized fAclEntry remove(String string) {
        fAclEntry fAclEntry2 = this.myACL.remove(string);
        if (fAclEntry2 != null) {
            sMyFactory.delEntry(fAclEntry2.getSubject(), fAclEntry2.getPriv());
            if (string.equals("*@*")) {
                this.myWildcardEntry = null;
            } else if (fAclEntry2.getSubject().getUser().equals("*")) {
                this.myHostLookup.remove(fAclEntry2.getSubject().getHost());
            } else if (fAclEntry2.getSubject().getHost().equals("*")) {
                this.myNameLookup.remove(fAclEntry2.getSubject().getUser());
            } else if (this.myGroups.containsKey(string)) {
                this.myGroups.remove(string);
            }
        }
        return fAclEntry2;
    }

    public fAclEntry find(fAclEntry fAclEntry2) {
        return this.find(fAclEntry2.getSubject());
    }

    public fAclEntry find(fSubject fSubject2) {
        return this.myACL.get(fSubject2.getName());
    }

    public synchronized fAclEntry lookup(fSubject fSubject2) {
        return this.lookup(fSubject2, false);
    }

    public synchronized fAclEntry lookup(fSubject fSubject2, boolean bl) {
        fAclEntry fAclEntry2 = this.myACL.get(fSubject2.getName());
        Iterator<fAclGroup> iterator = this.myGroups.values().iterator();
        while (iterator.hasNext() && fAclEntry2 == null) {
            fAclGroup fAclGroup2 = iterator.next();
            if (fAclGroup2.get(fSubject2) == null) continue;
            fAclEntry2 = this.myACL.get(fAclGroup2.getName());
        }
        if (fAclEntry2 == null) {
            fAclEntry2 = this.myNameLookup.get(fSubject2.getUser());
            if (fAclEntry2 == null) {
                fAclEntry2 = this.myHostLookup.get(fSubject2.getHost());
            }
            if (!bl && fAclEntry2 == null) {
                fAclEntry2 = this.myWildcardEntry;
            }
        }
        return fAclEntry2;
    }

    public fAclEntry find(String string) {
        return this.myACL.get(string);
    }

    public int size() {
        return this.myACL.size();
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<fAclEntry> iterator = this.myACL.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            fAclEntry fAclEntry2 = iterator.next();
            if (fAclEntry2.getSubject() instanceof fAclGroup) {
                fAclGroup fAclGroup2 = (fAclGroup)fAclEntry2.getSubject();
                stringBuilder.append("Group: ").append(fAclGroup2.toString()).append("\n");
            }
            stringBuilder.append(n).append(") ").append(fAclEntry2.getSubject().toString()).append(" - ").append(fAclEntry2.getPriv()).append(",\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    public synchronized void writeExternalCompatible(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeInt(this.myACL.size());
        for (fAclEntry fAclEntry2 : this.myACL.values()) {
            fAclEntry2.writeExternalCompatible(fEventOutputStream2);
        }
    }

    public synchronized void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeInt(this.myACL.size());
        for (fAclEntry fAclEntry2 : this.myACL.values()) {
            fAclEntry2.writeExternal(fEventOutputStream2);
        }
    }

    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            fAclEntry fAclEntry2 = new fAclEntry();
            fAclEntry2.readExternal(fEventInputStream2);
            this.add(fAclEntry2);
        }
    }

    public synchronized Iterator<fAclEntry> excludes(fAclList fAclList2) {
        ArrayList<fAclEntry> arrayList = new ArrayList<fAclEntry>();
        Iterator<fAclEntry> iterator = this.getIterator();
        while (iterator.hasNext()) {
            fAclEntry fAclEntry2 = iterator.next();
            if (fAclList2.myACL.containsKey(fAclEntry2.getSubject().getName())) continue;
            arrayList.add(fAclEntry2);
        }
        return arrayList.iterator();
    }

    public synchronized Iterator<fAclEntry> modified(fAclList fAclList2) {
        ArrayList<fAclEntry> arrayList = new ArrayList<fAclEntry>();
        Iterator<fAclEntry> iterator = this.getIterator();
        while (iterator.hasNext()) {
            fAclEntry fAclEntry2 = iterator.next();
            fAclEntry fAclEntry3 = fAclList2.get(fAclEntry2.getSubject());
            if (fAclEntry3 == null || fAclEntry3.getPriv() == fAclEntry2.getPriv()) continue;
            arrayList.add(fAclEntry2);
        }
        return arrayList.iterator();
    }

    public Iterator<fAclEntry> getIterator() {
        return this.myACL.values().iterator();
    }

    private boolean checkPermission(fAclEntry fAclEntry2, long l) {
        return fAclEntry2 != null && this.performSecurityCheck(fAclEntry2, l);
    }

    public boolean checkPerms(fSubject fSubject2, long l) {
        return this.checkPerms(fSubject2, l, false);
    }

    public boolean checkPerms(fSubject fSubject2, long l, boolean bl) {
        if (!bl) {
            boolean bl2 = this.doPermCheck(fSubject2, l, bl);
            if (!bl2) {
                return this.doPermCheck(new fSubject("*@*"), l, false);
            }
            return bl2;
        }
        if (this.lookup(fSubject2, true) != null) {
            return this.doPermCheck(fSubject2, l, bl);
        }
        return this.doPermCheck(new fSubject("*@*"), l, true);
    }

    private boolean doPermCheck(fSubject fSubject2, long l, boolean bl) {
        if (this.checkPermission(this.myACL.get(fSubject2.getName()), l)) {
            return true;
        }
        for (fAclGroup fAclGroup2 : this.myGroups.values()) {
            if (fAclGroup2.lookup(fSubject2) == null || this.myACL.get(fAclGroup2.getName()) == null || !this.performSecurityCheck(this.myACL.get(fAclGroup2.getName()), l)) continue;
            return true;
        }
        if (this.checkPermission(this.myNameLookup.get(fSubject2.getUser()), l)) {
            return true;
        }
        if (this.checkPermission(this.myHostLookup.get(fSubject2.getHost()), l)) {
            return true;
        }
        if (!bl) {
            return this.checkPermission(this.myWildcardEntry, l);
        }
        return false;
    }

    private boolean performSecurityCheck(fAclEntry fAclEntry2, long l) {
        long l2 = fAclEntry2.getPriv();
        if ((l2 & 8L) == 8L) {
            return true;
        }
        return (l2 & l) == l;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof fDeregisterGroupUpdate) {
            fDeregisterGroupUpdate fDeregisterGroupUpdate2 = (fDeregisterGroupUpdate)object;
            this.remove(fDeregisterGroupUpdate2.getfAclGroup());
            try {
                fDeregisterGroupUpdate2.getfAclGroup().deleteObserver(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setChanged();
            this.notifyObservers(null);
        } else {
            this.setChanged();
            this.notifyObservers(object);
        }
    }
}

