/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fAnonymousLoginContext;
import com.pcbsys.foundation.security.fCredential;
import com.pcbsys.foundation.security.fDefaultLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fSSLAnonymousLoginContext;
import com.pcbsys.foundation.security.fSSLLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.security.sasl.fSaslClientLoginContext;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;

public abstract class fClientLoginContext
extends fLoginContext {
    private static boolean useContext = true;
    private String myVirtualHostName;
    private String[] myPrincipals;
    private int IPUpdateCount = 0;
    protected String myUsername = null;
    protected String myIPAddress = null;

    public static fLoginContext getInstance(String string, String string2, String string3) {
        return new fSaslClientLoginContext(string, string2, string3);
    }

    public static void reset() {
        useContext = false;
    }

    public static fLoginContext getInstance(String string, String string2) {
        if (!useContext) {
            return new fAnonymousLoginContext();
        }
        fClientLoginContext fClientLoginContext2 = null;
        try {
            if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(0))) {
                fClientLoginContext2 = new fDefaultLoginContext(string2);
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(2))) {
                fClientLoginContext2 = new fSSLLoginContext(string2);
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(1))) {
                fClientLoginContext2 = new fDefaultLoginContext(string2);
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(3))) {
                fClientLoginContext2 = new fSSLLoginContext(string2);
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(4))) {
                fClientLoginContext2 = new fAnonymousLoginContext();
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(5))) {
                fClientLoginContext2 = new fSSLAnonymousLoginContext();
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(12))) {
                fClientLoginContext2 = new fDefaultLoginContext(string2);
            } else if (string.equalsIgnoreCase(fConnectionDetails.getProtocolString(13))) {
                fClientLoginContext2 = new fDefaultLoginContext(string2);
            }
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
        return fClientLoginContext2;
    }

    public static fLoginContext getInstance(String string) {
        return fClientLoginContext.getInstance(string, null);
    }

    fClientLoginContext() {
    }

    fClientLoginContext(fSubject fSubject2) {
        super(fSubject2);
    }

    public void setVirtualHostName(String string) {
        this.myVirtualHostName = string;
    }

    public void setPrincipals(String[] stringArray) {
        this.myPrincipals = stringArray;
    }

    void createSubject(String string, String string2) {
        fPrincipal fPrincipal2 = new fPrincipal(string2 + "@" + string);
        Vector<fPrincipal> vector = new Vector<fPrincipal>();
        vector.addElement(fPrincipal2);
        Vector<fCredential> vector2 = null;
        String string3 = fSystemConfiguration.getProperty("user.virtualRealm", this.myVirtualHostName);
        if (string3 != null) {
            vector2 = new Vector<fCredential>();
            vector2.add(new fCredential("virtualRealm", fStringByteConverter.convert(string3)));
        }
        this.setSubject(new fSubject(vector, vector2, null));
        for (int i = 0; this.myPrincipals != null && i < this.myPrincipals.length; ++i) {
            this.m_Subject.addPrincipal(this.myPrincipals[i] + "@" + string);
        }
    }

    public void setResource(String string, Object[] objectArray) throws fException {
        if (string.equalsIgnoreCase("SERVERIP")) {
            if (this.IPUpdateCount > 0) {
                throw new fException("IP address already changed!");
            }
            Vector<fPrincipal> vector = this.getSubject().getPrincipals();
            Vector<fPrincipal> vector2 = new Vector<fPrincipal>();
            for (int i = 0; i < vector.size(); ++i) {
                String string2 = (String)objectArray[0];
                String string3 = (String)objectArray[1];
                this.myIPAddress = string2;
                fPrincipal fPrincipal2 = new fPrincipal(string3 + "@" + string2);
                vector2.add(fPrincipal2);
            }
            fSubject fSubject2 = new fSubject(vector2, this.getSubject().getPublicCredentials(), this.getSubject().getPrivateCredentials());
            this.setSubject(fSubject2);
            ++this.IPUpdateCount;
        }
    }
}

