/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fHTTPDSession;
import com.pcbsys.foundation.drivers.nio.fSSLChannelDriver;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.security.auth.fAuthentication;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDefaultServerLoginContext;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fSSLServerLoginContext;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.security.sasl.fExtAuthServerLoginContext;
import com.pcbsys.foundation.security.sasl.fSaslServerLoginContext;
import java.io.IOException;

public class fCompositeServerLoginContext
extends fServerLoginContext {
    private final int anonType;
    private fServerLoginContext myContextDelegate;

    public boolean isSSL() {
        return this.anonType == 2 || this.anonType == 3;
    }

    public fCompositeServerLoginContext() {
        this(0);
    }

    public fCompositeServerLoginContext(int n) {
        this.anonType = n;
    }

    @Override
    public fServerLoginContext newInstance() {
        return new fCompositeServerLoginContext(this.anonType);
    }

    @Override
    public fLoginResponse login(fDriver fDriver2) throws fException {
        try {
            fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
            fLoginResponse fLoginResponse2 = this.login(fDriver2, fEventInputStream2, fEventOutputStream2);
            fDriver2.setTimeout(300000);
            return fLoginResponse2;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof fException) {
                throw (fException)exception;
            }
            throw new fException(exception);
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException, fException {
        fSubject fSubject2;
        fSubject fSubject3 = fDriver2 instanceof fSSLChannelDriver || fDriver2 instanceof fHTTPDSession ? fDriver2.getSubject() : null;
        byte by = fEventInputStream2.readByte();
        switch (by) {
            case -2: {
                this.myContextDelegate = new fSaslServerLoginContext();
                break;
            }
            case -3: {
                this.myContextDelegate = new fExtAuthServerLoginContext();
                break;
            }
            default: {
                fEventInputStream2.rollback(by);
                this.myContextDelegate = this.isSSL() ? new fSSLServerLoginContext() : new fDefaultServerLoginContext();
            }
        }
        if (this.drvconfig != null) {
            this.myContextDelegate.setConfig(this.drvconfig);
        }
        fLoginResponse fLoginResponse2 = this.myContextDelegate.login(fDriver2, fEventInputStream2, fEventOutputStream2);
        if (fSubject3 != null && fAuthentication.isEnabledDirectory() && fLoginResponse2.authenticated() && (fSubject2 = this.myContextDelegate.getSubject()) != null && !fSubject3.getUser().equalsIgnoreCase(fSubject2.getUser())) {
            throw new fAuthenticationException("Login subject=" + fSubject2 + " conflicts with certified subject=" + fSubject3);
        }
        return fLoginResponse2;
    }

    @Override
    public void logout(fDriver fDriver2) throws fException {
        if (this.myContextDelegate != null) {
            this.myContextDelegate.logout(fDriver2);
        }
    }

    @Override
    protected void init() {
        if (this.myContextDelegate != null) {
            this.myContextDelegate.init();
        }
    }

    @Override
    public fSubject getSubject() {
        return this.myContextDelegate == null ? null : this.myContextDelegate.getSubject();
    }

    @Override
    protected void setSubject(fSubject fSubject2) {
        if (this.myContextDelegate != null) {
            this.myContextDelegate.setSubject(fSubject2);
        }
    }
}

