/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.fAclEntry;
import com.pcbsys.foundation.security.fAclGroup;
import com.pcbsys.foundation.security.fAclList;
import com.pcbsys.foundation.security.fSecureObject;
import com.pcbsys.foundation.security.fSecurityGroupManager;
import com.pcbsys.foundation.security.fSecurityManager;
import com.pcbsys.foundation.security.fSubject;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class fDefaultSecureObject
extends fBaseTransportObject
implements fSecureObject,
Observer {
    public static final long ACL_ALL_PERMISSIONS = -1L;
    public static final long ACL_DEFAULT_ENTRY = 0L;
    public static final int ACL_ADD = 1;
    public static final int ACL_REMOVE = 2;
    public static final int ACL_LIST = 4;
    public static final int ACL_ADMIN = 8;
    public static final long MAX_LEVEL = 8L;
    protected static final String[] ACL_NAMES = new String[]{"Add Permission", "Remove Permission", "List Permissions", "Full Privileges"};
    protected static final String[] ACL_DESCRIPTIONS = new String[]{"Add permissions to subjects", "Remove permissions from subjects", "List a subject permissions", "Set all privileges"};
    protected static fSecurityGroupManager securityManager;
    private fSubject myDefaultCaller = null;
    private fAclList myACL = new fAclList();
    protected transient boolean ignoreEveryonePermission = false;

    public static void setSecurityManager(fSecurityGroupManager fSecurityGroupManager2) {
        securityManager = fSecurityGroupManager2;
    }

    public static fSubject getDefaultSuperUser() {
        return fSecurityManager.getInstance().getDefaultSuperUser();
    }

    public static List<fSubject> getSuperUsers() {
        return fSecurityManager.getInstance().getSuperUsers();
    }

    public static fSubject getEveryoneUser() {
        return fSecurityManager.getInstance().getEveryoneUser();
    }

    public static fSubject getEveryoneGroup() {
        return fSecurityManager.getInstance().getEveryoneGroup();
    }

    public static Vector<fSubject> getAdmins() {
        return fSecurityManager.getInstance().getAdmins();
    }

    public fDefaultSecureObject() {
        this(false, true);
    }

    public fDefaultSecureObject(boolean bl) {
        this(bl, true);
    }

    public fDefaultSecureObject(boolean bl, boolean bl2) {
        try {
            List<fSubject> list;
            if (bl) {
                list = fDefaultSecureObject.getSuperUsers();
                for (fSubject fSubject2 : list) {
                    this.myACL.add(fSubject2, 9L);
                }
            }
            if (bl2 && this.myACL.get(fDefaultSecureObject.getEveryoneGroup()) == null) {
                this.myACL.add(fDefaultSecureObject.getEveryoneGroup(), 0L);
            }
            if (bl) {
                list = fDefaultSecureObject.getAdmins();
                Enumeration enumeration = ((java.util.Vector)list).elements();
                while (enumeration.hasMoreElements()) {
                    fSubject fSubject2;
                    fSubject2 = (fSubject)enumeration.nextElement();
                    if (this.myACL.find(fSubject2) != null) {
                        this.myACL.remove(fSubject2);
                    }
                    this.myACL.add(fSubject2, 8L);
                }
            }
            this.myACL.addObserver(this);
            this.myACL = this.updateGroupReferences();
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
        this.init();
    }

    public fDefaultSecureObject(fSubject fSubject2) {
        this();
        this.myDefaultCaller = fSubject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setACL(fAclList fAclList2, boolean bl) {
        fAclList fAclList3 = this.myACL;
        synchronized (fAclList3) {
            fAclList fAclList4 = fAclList2;
            synchronized (fAclList4) {
                this.myACL.clear();
                Iterator<fAclEntry> iterator = fAclList2.getIterator();
                while (iterator.hasNext()) {
                    this.myACL.add(iterator.next(), bl);
                }
            }
        }
    }

    public void setACL(fAclList fAclList2) {
        this.setACL(fAclList2, true);
    }

    public fAclList updateGroupReferences() {
        if (securityManager != null) {
            fAclList fAclList2 = new fAclList();
            Iterator<fAclEntry> iterator = this.myACL.getIterator();
            while (iterator.hasNext()) {
                fAclEntry fAclEntry2 = iterator.next();
                if (fAclEntry2.getSubject().isGroup()) {
                    fAclGroup fAclGroup2 = securityManager.getGroup(fAclEntry2.getSubject().getName());
                    if (fAclGroup2 == null) continue;
                    fAclEntry2 = new fAclEntry(fAclGroup2, fAclEntry2.getPriv());
                    fAclList2.add(fAclEntry2);
                    continue;
                }
                fAclList2.add(fAclEntry2);
            }
            this.myACL.clear();
            this.myACL = fAclList2;
            this.myACL.addObserver(this);
        }
        return this.myACL;
    }

    public void destroy() {
        this.myACL.clear();
        this.myACL.deleteObserver(this);
    }

    public Iterator<fAclEntry> getIterator() {
        return this.myACL.getIterator();
    }

    public void init() {
    }

    public fAclList getACL() {
        return this.myACL;
    }

    public synchronized void setACLReference(fAclList fAclList2) {
        this.myACL = fAclList2;
    }

    public void clear() {
        this.myACL.clear();
    }

    public void add(fAclEntry fAclEntry2) throws fException {
        this.myACL.add(fAclEntry2);
    }

    public boolean add(fSubject fSubject2, long l) throws fException {
        return this.myDefaultCaller != null && this.add(this.myDefaultCaller, fSubject2, l);
    }

    @Override
    public boolean add(fSubject fSubject2, fSubject fSubject3, long l) throws fException {
        return this.add(fSubject2, fSubject3, l, false);
    }

    public boolean add(fSubject fSubject2, fSubject fSubject3, long l, boolean bl) throws fException {
        if (bl) {
            return this.createEntry(fSubject2, fSubject3, l);
        }
        if (this.check(fSubject2, 1L, true)) {
            return this.createEntry(fSubject2, fSubject3, l);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createEntry(fSubject fSubject2, fSubject fSubject3, long l) {
        fAclEntry fAclEntry2 = this.myACL.find(fSubject3);
        if (fAclEntry2 != null) {
            long l2 = fAclEntry2.getPriv();
            if ((l2 & l) == l) {
                return true;
            }
            fAclList fAclList2 = this.myACL;
            synchronized (fAclList2) {
                this.myACL.remove(fAclEntry2);
                try {
                    this.myACL.add(fSubject3, l);
                }
                catch (Exception exception) {
                    fConstants.logger.error(exception);
                }
            }
            return true;
        }
        try {
            fAclList fAclList3 = this.myACL;
            synchronized (fAclList3) {
                this.myACL.add(fSubject3, 0L | l);
            }
        }
        catch (Exception exception) {
            fConstants.logger.error(exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(fSubject fSubject2) {
        fAclList fAclList2 = this.myACL;
        synchronized (fAclList2) {
            return this.myACL.find(fSubject2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fAclEntry get(fSubject fSubject2) {
        fAclList fAclList2 = this.myACL;
        synchronized (fAclList2) {
            return this.myACL.find(fSubject2);
        }
    }

    public void remove(String string) {
        this.myACL.remove(string);
    }

    public void remove(fSubject fSubject2) {
        this.myACL.remove(fSubject2.toString());
    }

    public boolean remove(fAclEntry fAclEntry2) {
        return this.myACL.remove(fAclEntry2) != null;
    }

    public boolean remove(fSubject fSubject2, long l) throws fException {
        return this.myDefaultCaller != null && this.remove(this.myDefaultCaller, fSubject2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(fSubject fSubject2, fSubject fSubject3, long l) throws fException {
        if (this.check(fSubject2, 2L, true)) {
            fAclList fAclList2 = this.myACL;
            synchronized (fAclList2) {
                fAclEntry fAclEntry2 = this.myACL.find(fSubject3);
                if (fAclEntry2 != null) {
                    if (l == -1L) {
                        this.myACL.remove(fSubject3);
                        return true;
                    }
                    long l2 = fAclEntry2.getPriv();
                    if ((l2 & l) != l) {
                        return true;
                    }
                    fAclEntry2.setPriv(l2 & (l ^ 0xFFFFFFFFFFFFFFFFL));
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean check(fSubject fSubject2, long l, boolean bl) {
        return this.check(fSubject2, l, true, bl);
    }

    public boolean check(fSubject fSubject2, long l, boolean bl, boolean bl2) {
        boolean bl3 = this.doCheck(fSubject2, l);
        if (!bl3 && !this.ignoreEveryonePermission) {
            bl3 = this.doCheck(this.getEveryone(), l);
        }
        if (!bl3 && bl2) {
            bl3 = this.doCheckOld(fDefaultSecureObject.getAdmins(), fSubject2);
        }
        if (bl && !bl3 && fConstants.logger.isDebugEnabled()) {
            fConstants.logger.debug("Subject : " + fSubject2.toString() + " failed " + this.getACLName(l) + " Perm : " + l);
            String string = "Beginning dump for ACL \n\n" + this.myACL.toString();
            fConstants.logger.debug(string);
        }
        return bl3;
    }

    @Override
    public String getACLName(long l) {
        int n = 0;
        long l2 = l;
        while ((l2 & 1L) == 0L && n < 64) {
            ++n;
            l2 >>= 1;
        }
        if (n < this.getACLNames().length) {
            return this.getACLNames()[n];
        }
        return "Unknown Permission : Value = " + l;
    }

    @Override
    public String getACLDescription(long l) {
        int n = 0;
        long l2 = l;
        while ((l2 & 1L) == 0L && n < 64) {
            ++n;
            l2 >>= 1;
        }
        if (n < this.getACLDescriptions().length) {
            return this.getACLDescriptions()[n];
        }
        return "Unknown Permission Description : Value = " + l;
    }

    @Override
    public String[] getACLNames() {
        return ACL_NAMES;
    }

    @Override
    public String[] getACLDescriptions() {
        return ACL_DESCRIPTIONS;
    }

    @Override
    public long getMaxLevel() {
        return 8L;
    }

    @Override
    public fSubject getEveryone() {
        return fDefaultSecureObject.getEveryoneGroup();
    }

    private boolean doCheck(fSubject fSubject2, long l) {
        return this.myACL.checkPerms(fSubject2, l);
    }

    private boolean doCheckOld(Vector<fSubject> vector, fSubject fSubject2) {
        String string = fSubject2.getUser();
        String string2 = fSubject2.getHost();
        for (int i = 0; i < vector.size(); ++i) {
            fSubject fSubject3 = (fSubject)vector.elementAt(i);
            String string3 = fSubject3.getUser();
            String string4 = fSubject3.getHost();
            if (string.equalsIgnoreCase(string3) && string2.equalsIgnoreCase(string4)) {
                return true;
            }
            if (!(string4.compareTo("*") == 0 ? string3.compareTo(string) == 0 : string3.compareTo("*") == 0 && string4.equalsIgnoreCase(string2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        if (fEventInputStream2.readBoolean()) {
            this.myDefaultCaller = new fSubject();
            this.myDefaultCaller.readExternal(fEventInputStream2);
        } else {
            this.myDefaultCaller = null;
        }
        this.myACL = new fAclList();
        this.myACL.readExternal(fEventInputStream2);
        this.myACL.addObserver(this);
        this.myACL = this.updateGroupReferences();
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        if (this.myDefaultCaller != null) {
            fEventOutputStream2.writeBoolean(true);
            this.myDefaultCaller.writeExternal(fEventOutputStream2);
        } else {
            fEventOutputStream2.writeBoolean(false);
        }
        this.myACL.writeExternal(fEventOutputStream2);
    }

    @Override
    public void update(Observable observable, Object object) {
    }
}

