/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fMultiplexDriver;
import com.pcbsys.foundation.drivers.fSSLDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.security.auth.fAuthConstants;
import com.pcbsys.foundation.security.auth.fAuthentication;
import com.pcbsys.foundation.security.fDefaultResponse;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import com.softwareag.security.jaas.login.SagCredentials;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;

public class fDefaultServerLoginContext
extends fServerLoginContext {
    @Override
    public fServerLoginContext newInstance() {
        return new fDefaultServerLoginContext();
    }

    @Override
    public fLoginResponse login(fDriver fDriver2) throws fException {
        try {
            fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
            fLoginResponse fLoginResponse2 = this.login(fDriver2, fEventInputStream2, fEventOutputStream2);
            fDriver2.setTimeout(0);
            return fLoginResponse2;
        }
        catch (Exception exception) {
            if (exception instanceof fException) {
                throw (fException)exception;
            }
            throw new fException("Authentication failed with driver=" + fDriver2.getClass().getName(), exception);
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException, fException {
        fBaseTransportObject fBaseTransportObject2;
        fSubject fSubject2 = this.loadSubject(fDriver2, fEventInputStream2, fEventOutputStream2);
        if (fSubject2 == null) {
            fDefaultResponse fDefaultResponse2 = new fDefaultResponse(false);
            fDefaultResponse2.enablePolicyRequest();
            return fDefaultResponse2;
        }
        String string = this.getRemoteAddress(fDriver2);
        Vector<fPrincipal> vector = fSubject2.getPrincipals();
        Vector<fPrincipal> vector2 = new Vector<fPrincipal>();
        for (int i = 0; i < vector.size(); ++i) {
            fBaseTransportObject2 = (fPrincipal)vector.elementAt(i);
            String string2 = ((fPrincipal)fBaseTransportObject2).getName();
            int n = string2.indexOf("@");
            String string3 = fReverseDNSUtility.resolveAddress(string);
            if (((fPrincipal)fBaseTransportObject2).isForwarded()) {
                vector2.add((fPrincipal)fBaseTransportObject2);
                continue;
            }
            vector2.add(new fPrincipal(string2.substring(0, n) + "@" + string3));
        }
        fSubject fSubject3 = new fSubject(vector2, fSubject2.getPublicCredentials(), null);
        fBaseTransportObject2 = this.checkSubject(fDriver2, fSubject3, fEventInputStream2, fEventOutputStream2);
        this.setSubject(fDriver2.getSubject());
        return fBaseTransportObject2;
    }

    fDefaultResponse checkSubject(fDriver fDriver2, fSubject fSubject2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException {
        boolean bl = true;
        if (fAuthentication.authenticationMandatory && !fSubject2.isAuthenticated() && !(fDriver2 instanceof fMultiplexDriver)) {
            bl = fAuthentication.isExempt(fSubject2);
        }
        fDefaultResponse fDefaultResponse2 = new fDefaultResponse(bl);
        fEventOutputStream2.writeExternalable(fDefaultResponse2);
        fEventOutputStream2.flush();
        fDriver2.setSubject(fSubject2);
        this.setSubject(fSubject2);
        return fDefaultResponse2;
    }

    @Override
    public void logout(fDriver fDriver2) {
    }

    @Override
    protected void init() {
    }

    protected void extractTransportCredentials(SagCredentials sagCredentials, fDriver fDriver2) {
        block4: {
            if (fDriver2 instanceof fSSLDriver) {
                fSSLDriver fSSLDriver2 = (fSSLDriver)((Object)fDriver2);
                try {
                    Certificate[] certificateArray = fSSLDriver2.getSSLSession().getPeerCertificates();
                    if (certificateArray instanceof X509Certificate[]) {
                        sagCredentials.setX509CertChain((X509Certificate[])certificateArray);
                    }
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    if (!fAuthConstants.sDebug) break block4;
                    fConstants.logger.log("Cannot retrieve client certificate chain - we are potentially using one-way SSL - " + sSLPeerUnverifiedException.getMessage());
                }
            }
        }
    }
}

