/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.collections.fast.String2ObjectOpenAddressingHashMap;
import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fDriverMonitorEntry;
import com.pcbsys.foundation.threads.fScheduledTask;
import com.pcbsys.foundation.threads.fThreadScheduler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class fDriverConnectionMonitor
extends fScheduledTask {
    private static final boolean sCheckDos = Boolean.parseBoolean(System.getProperty("CheckForDOS", "true"));
    private static final Vector<fDriverConnectionMonitor> sMyMonitors = new Vector();
    private final String2ObjectOpenAddressingHashMap<HostConnections> myTimeOutList = new String2ObjectOpenAddressingHashMap();
    private final String myName;
    private long myTimeout;
    private int myMaxCount;
    private int myLevel;
    private boolean close;

    public static Vector<fDriverConnectionMonitor> getMonitors() {
        return sMyMonitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fDriverConnectionMonitor(String string, int n, long l, int n2) {
        this.myMaxCount = n;
        this.myTimeout = l;
        this.myLevel = n2;
        this.myName = string;
        this.close = false;
        fThreadScheduler.getInstance().addTask(this, 2000L);
        Vector<fDriverConnectionMonitor> vector = sMyMonitors;
        synchronized (vector) {
            sMyMonitors.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = sMyMonitors;
        synchronized (object) {
            sMyMonitors.remove(this);
        }
        this.close = true;
        object = this.myTimeOutList;
        synchronized (object) {
            for (HostConnections hostConnections : this.myTimeOutList.values()) {
                hostConnections.closeAll();
            }
        }
    }

    public int getMaxCount() {
        return this.myMaxCount;
    }

    public void setMaxCount(int n) {
        this.myMaxCount = n;
    }

    public void setTimeOut(long l) {
        this.myTimeout = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(fDriverMonitorEntry fDriverMonitorEntry2) throws IOException {
        if (this.close) {
            return;
        }
        if (fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log(this.myName + "> Adding " + fDriverMonitorEntry2.toString() + " into monitor pool");
        }
        String2ObjectOpenAddressingHashMap<HostConnections> string2ObjectOpenAddressingHashMap = this.myTimeOutList;
        synchronized (string2ObjectOpenAddressingHashMap) {
            HostConnections hostConnections = this.myTimeOutList.get(fDriverMonitorEntry2.getHostName());
            if (hostConnections == null) {
                hostConnections = new HostConnections(this);
                this.myTimeOutList.put(fDriverMonitorEntry2.getHostName(), hostConnections);
            }
            if (hostConnections.size() > this.myMaxCount) {
                hostConnections.incrementExceedCount();
                if (sCheckDos) {
                    throw new IOException(this.myName + "> Exceeded unauthorised connection count for " + fDriverMonitorEntry2.getHostName() + ", possible denial of service attack at level " + this.myLevel);
                }
            }
            hostConnections.add(fDriverMonitorEntry2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(fDriverMonitorEntry fDriverMonitorEntry2) {
        if (fConnectionDetails.sEnableConnectionDebug) {
            fDriver.log(this.myName + "> Removing " + fDriverMonitorEntry2 + " from monitor pool");
        }
        String2ObjectOpenAddressingHashMap<HostConnections> string2ObjectOpenAddressingHashMap = this.myTimeOutList;
        synchronized (string2ObjectOpenAddressingHashMap) {
            HostConnections hostConnections = this.myTimeOutList.get(fDriverMonitorEntry2.getHostName());
            if (hostConnections != null) {
                hostConnections.remove(fDriverMonitorEntry2);
                if (hostConnections.size() == 0) {
                    this.myTimeOutList.remove(fDriverMonitorEntry2.getHostName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.myName).append(" level: ").append(this.myLevel).append(" Max Count: ").append(this.myMaxCount).append(" Timeout: ").append(this.myTimeout).append("\n");
        String2ObjectOpenAddressingHashMap<HostConnections> string2ObjectOpenAddressingHashMap = this.myTimeOutList;
        synchronized (string2ObjectOpenAddressingHashMap) {
            for (String string : this.myTimeOutList.keySet()) {
                HostConnections hostConnections = this.myTimeOutList.get(string);
                if (hostConnections == null) continue;
                stringBuilder.append("\tHost : ").append(string).append(" has ").append(hostConnections.size()).append(" connections\n");
                stringBuilder.append(hostConnections.toString());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "Connection Security Monitor";
    }

    @Override
    public long reSchedule() {
        if (this.close) {
            return -1L;
        }
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this.close) {
            return;
        }
        String2ObjectOpenAddressingHashMap<HostConnections> string2ObjectOpenAddressingHashMap = this.myTimeOutList;
        synchronized (string2ObjectOpenAddressingHashMap) {
            if (this.myTimeOutList.size() == 0) {
                return;
            }
            Iterator<HostConnections> iterator = this.myTimeOutList.values().iterator();
            while (iterator.hasNext()) {
                HostConnections hostConnections = iterator.next();
                if (hostConnections.size() != 0) {
                    hostConnections.validate();
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public static final class HostConnections {
        private final fDriverConnectionMonitor myMonitor;
        private final ArrayList<fDriverMonitorEntry> myList;
        private long myExceedCount;

        public HostConnections(fDriverConnectionMonitor fDriverConnectionMonitor2) {
            this.myMonitor = fDriverConnectionMonitor2;
            this.myList = new ArrayList();
            this.myExceedCount = 0L;
        }

        public boolean remove(fDriverMonitorEntry fDriverMonitorEntry2) {
            return this.myList.remove(fDriverMonitorEntry2);
        }

        public void add(fDriverMonitorEntry fDriverMonitorEntry2) {
            this.myList.add(fDriverMonitorEntry2);
        }

        public int size() {
            return this.myList.size();
        }

        public void incrementExceedCount() {
            ++this.myExceedCount;
        }

        public long getExceedCount() {
            return this.myExceedCount;
        }

        public void closeAll() {
            while (this.myList.size() != 0) {
                fDriver fDriver2 = this.myList.remove(0).getDriver();
                try {
                    fDriver2.abortAllIO();
                    fDriver2.close();
                }
                catch (Exception exception) {}
            }
        }

        public void validate() {
            long l = fTimer.getTicks();
            int n = 0;
            while (n < this.myList.size()) {
                fDriverMonitorEntry fDriverMonitorEntry2 = this.myList.get(n);
                if (fDriverMonitorEntry2.getTime() + this.myMonitor.myTimeout < l) {
                    if (fDriverMonitorEntry2.getDriver().isClosed()) {
                        fConstants.logger.error(this.myMonitor.myName + " : Authentication: Failed to authenticate, within timeout period " + fDriverMonitorEntry2.getDriver().toString() + "[" + fDriverMonitorEntry2.getDriver().getId() + "] Driver Connection Open State : " + fDriverMonitorEntry2.getDriver().isClosed());
                    }
                    this.myList.remove(n);
                    fDriverMonitorEntry2.getDriver().abortAllIO();
                    try {
                        fDriverMonitorEntry2.getDriver().close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                ++n;
            }
            if (this.myExceedCount > 0L) {
                this.myExceedCount = this.myExceedCount * 5L / 6L;
            }
        }

        public String toString() {
            long l = fTimer.getTicks();
            StringBuilder stringBuilder = new StringBuilder();
            for (fDriverMonitorEntry fDriverMonitorEntry2 : this.myList) {
                String string = "";
                try {
                    string = fDriverMonitorEntry2.getDriver().getSubject().toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (string != null) {
                    stringBuilder.append("\t\t\t").append(fDriverMonitorEntry2.getDriver().getId()).append(" Subject:").append(string).append(" expires in ").append(fDriverMonitorEntry2.getTime() + this.myMonitor.myTimeout - l).append(" ms\n");
                    continue;
                }
                stringBuilder.append("\t\t\t").append(fDriverMonitorEntry2.getDriver().getId()).append(" expires in ").append(fDriverMonitorEntry2.getTime() + this.myMonitor.myTimeout - l).append(" ms\n");
            }
            return stringBuilder.toString();
        }
    }
}

