/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.utils.Base64;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import com.pcbsys.foundation.utils.fStringByteConverter;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;

public class fPrincipal
extends fBaseTransportObject {
    private static final boolean sAllowForwarding = fSystemConfiguration.getProperty("ALLOWFORWARDING") != null;
    private String m_Name = null;
    private byte[] m_NameBytes = null;
    private int hashCode;
    private boolean forwarded = false;

    public fPrincipal(String string) {
        try {
            this.m_Name = !string.contains("forwarded:") ? fReverseDNSUtility.sanitiseV6(string.toLowerCase()) : string;
            this.hashCode = this.m_Name.hashCode();
            this.m_NameBytes = fStringByteConverter.convert(this.m_Name);
        }
        catch (Throwable throwable) {
            fConstants.logger.error(throwable);
        }
    }

    public fPrincipal() {
        this.m_Name = "anonymous";
        this.hashCode = this.m_Name.hashCode();
    }

    public String getName() {
        return this.m_Name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setHashCode(int n) {
        this.hashCode = n;
    }

    public String toString() {
        return this.m_Name;
    }

    public boolean equals(Object object) {
        if (object instanceof fPrincipal) {
            fPrincipal fPrincipal2 = (fPrincipal)object;
            return this.m_Name.equals(fPrincipal2.m_Name);
        }
        return false;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        this.m_NameBytes = fEventInputStream2.readByteArray();
        this.m_Name = fReverseDNSUtility.sanitiseV6(fStringByteConverter.convert(this.m_NameBytes));
        if (this.m_Name.contains("forwarded:")) {
            if (sAllowForwarding) {
                this.forwarded = true;
            }
            String string = this.m_Name.substring("forwarded:".length());
            string = string.substring(0, string.indexOf("@"));
            this.m_Name = fStringByteConverter.convert(Base64.decode(string));
        }
        this.hashCode = fEventInputStream2.readInt();
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeByteArray(this.m_NameBytes);
        fEventOutputStream2.writeInt(this.hashCode);
    }

    public int getSize() {
        return 4 + this.m_NameBytes.length;
    }

    boolean isForwarded() {
        return this.forwarded;
    }
}

