/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.configuration.fBaseSSLConfig;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.security.fDefaultResponse;
import com.pcbsys.foundation.security.fDefaultServerLoginContext;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import java.io.IOException;

public class fSSLServerLoginContext
extends fDefaultServerLoginContext {
    private boolean requireClientAuth = false;

    @Override
    public fServerLoginContext newInstance() {
        return new fSSLServerLoginContext();
    }

    @Override
    public void setConfig(fDriverConfig fDriverConfig2) {
        if (fDriverConfig2 != null && fDriverConfig2 instanceof fBaseSSLConfig) {
            this.requireClientAuth = ((fBaseSSLConfig)((Object)fDriverConfig2)).getCertRequired();
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2) throws fException {
        try {
            fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
            fLoginResponse fLoginResponse2 = this.login(fDriver2, fEventInputStream2, fEventOutputStream2);
            fDriver2.setTimeout(0);
            return fLoginResponse2;
        }
        catch (Exception exception) {
            fConstants.logger.log("Authentication: Failed to authenticate " + exception.toString());
            fConstants.logger.log(exception);
            throw new fException(exception.toString());
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException, fException {
        if (this.requireClientAuth) {
            fDefaultResponse fDefaultResponse2;
            try {
                fSubject fSubject2 = this.loadSubject(fDriver2, fEventInputStream2, fEventOutputStream2);
                if (fSubject2 == null) {
                    fDefaultResponse fDefaultResponse3 = new fDefaultResponse(false);
                    fDefaultResponse3.enablePolicyRequest();
                    return fDefaultResponse3;
                }
                fSubject fSubject3 = fDriver2.getSubject();
                Object[] objectArray = fSubject3.getPrincipals().toArray();
                fPrincipal fPrincipal2 = (fPrincipal)fSubject2.getPrincipals().toArray()[0];
                if (!fPrincipal2.isForwarded()) {
                    String string = fPrincipal2.getName();
                    int n = fPrincipal2.getName().indexOf(64);
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    String string2 = fReverseDNSUtility.resolveAddress(this.getRemoteAddress(fDriver2));
                    fPrincipal2 = new fPrincipal(string + '@' + string2);
                }
                fPrincipal2.setHashCode(objectArray[objectArray.length - 1].hashCode() - 1);
                fSubject3.getPrincipals().add(fPrincipal2);
                fSubject2 = fSubject3;
                fDriver2.setTimeout(300000);
                fDefaultResponse2 = this.checkSubject(fDriver2, fSubject2, fEventInputStream2, fEventOutputStream2);
            }
            catch (Exception exception) {
                fConstants.logger.fatal(exception);
                fConstants.logger.fatal(exception.getMessage());
                fDefaultResponse2 = new fDefaultResponse(false);
                try {
                    fEventOutputStream2.writeExternalable(fDefaultResponse2);
                    fEventOutputStream2.flush();
                    fDriver2.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return fDefaultResponse2;
        }
        return super.login(fDriver2, fEventInputStream2, fEventOutputStream2);
    }
}

