/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fFile;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.security.fAclGroup;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class fSecurityManager {
    private static final String sDefaultUsername = "anonymous";
    private static final fSecurityManager myInstance = new fSecurityManager();
    private final Vector<fSubject> msAdmins;
    private fSubject msEveryoneUser;
    private volatile List<fSubject> msDefaultSuperUser;
    private fAclGroup everyoneGroup;
    private final Object suLock = new Object();

    public static fSecurityManager getInstance() {
        return myInstance;
    }

    private fSecurityManager() {
        this.msAdmins = fSecurityManager.loadAdmins();
    }

    public void init() {
        this.getSuperUsers();
    }

    public fSubject getDefaultSuperUser() {
        return this.getSuperUsers().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<fSubject> getSuperUsers() {
        List<fSubject> list = this.msDefaultSuperUser;
        if (list == null) {
            Object object = this.suLock;
            synchronized (object) {
                list = this.msDefaultSuperUser;
                if (list == null) {
                    LinkedList<fSubject> linkedList = new LinkedList<fSubject>();
                    String string = fSystemConfiguration.getProperty("user.name", sDefaultUsername);
                    if (!string.equals(sDefaultUsername) && string.trim().length() == 0) {
                        string = sDefaultUsername;
                    }
                    Collection<String> collection = fReverseDNSUtility.getLocalHosts();
                    for (String string2 : collection) {
                        Vector<fPrincipal> vector = new Vector<fPrincipal>();
                        vector.add(new fPrincipal(string + "@" + string2));
                        linkedList.add(new fSubject(vector, null, null));
                    }
                    this.msDefaultSuperUser = linkedList;
                }
            }
        }
        return this.msDefaultSuperUser;
    }

    public fSubject getEveryoneUser() {
        if (this.msEveryoneUser == null) {
            Vector<fPrincipal> vector = new Vector<fPrincipal>();
            vector.add(new fPrincipal("*@*"));
            this.msEveryoneUser = new fSubject(vector, null, null);
        }
        return this.msEveryoneUser;
    }

    public Vector<fSubject> getAdmins() {
        return this.msAdmins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<fSubject> loadAdmins() {
        File file;
        Vector<fSubject> vector = new Vector<fSubject>();
        String string = fSystemConfiguration.getProperty("SECURITYFILE", fEnvironment.getSecurityFileLocation());
        if (string != null && fFile.exists(file = new File(string))) {
            BufferedReader bufferedReader = null;
            try {
                String string2;
                FileReader fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0 || string2.charAt(0) == '#') continue;
                    Vector<fPrincipal> vector2 = new Vector<fPrincipal>();
                    vector2.add(new fPrincipal(string2));
                    fSubject fSubject2 = new fSubject(vector2, null, null);
                    vector.add(fSubject2);
                }
            }
            catch (Exception exception) {
                fConstants.logger.error(exception);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    fConstants.logger.info("close failed on " + string + " - " + exception);
                }
            }
        }
        return vector;
    }

    public fAclGroup getEveryoneGroup() {
        if (this.everyoneGroup == null) {
            ArrayList<fSubject> arrayList = new ArrayList<fSubject>();
            arrayList.add(new fSubject("*", "*"));
            this.everyoneGroup = new fAclGroup("Everyone", arrayList);
        }
        return this.everyoneGroup;
    }
}

