/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.drivers.configuration.fDriverConfig;
import com.pcbsys.foundation.drivers.configuration.fSocketConfig;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fHTTPDSession;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fConnectionInterception;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.fConnectionValidator;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fPolicyServerHandler;
import com.pcbsys.foundation.security.fServerLoginContextFactory;
import com.pcbsys.foundation.security.fSubject;
import java.io.IOException;

public abstract class fServerLoginContext
extends fLoginContext {
    private static final byte[] sPolicyRequest = "<policy-file-request/>".getBytes();
    private static fPolicyServerHandler myPolicyHandler;
    private static final Vector<fConnectionInterception> myInterceptors;
    private static int myInterceptorDetectionSize;
    private boolean enablePolicyServer;
    protected fDriverConfig drvconfig;
    private fConnectionValidator myValidator;

    public static void setPolicyServer(fPolicyServerHandler fPolicyServerHandler2) {
        myPolicyHandler = fPolicyServerHandler2;
    }

    public static void setInterceptor(fConnectionInterception fConnectionInterception2) {
        fConstants.logger.log("Adding " + fConnectionInterception2.getName() + " to interception list");
        boolean bl = false;
        if (myInterceptorDetectionSize < fConnectionInterception2.getStreamOffset() + fConnectionInterception2.getUniqueHeader().length) {
            myInterceptorDetectionSize = fConnectionInterception2.getStreamOffset() + fConnectionInterception2.getUniqueHeader().length;
        }
        for (int i = 0; i < myInterceptors.size(); ++i) {
            if (((fConnectionInterception)myInterceptors.elementAt(i)).getStreamOffset() >= fConnectionInterception2.getStreamOffset()) continue;
            myInterceptors.add(i, fConnectionInterception2);
            bl = true;
            break;
        }
        if (!bl) {
            myInterceptors.add(fConnectionInterception2);
        }
    }

    public static fServerLoginContext getInstance(String string) {
        return fServerLoginContextFactory.getInstance().getContext(string);
    }

    public fServerLoginContext() {
    }

    public fServerLoginContext(fSubject fSubject2) {
        super(fSubject2);
    }

    public void setConfig(fDriverConfig fDriverConfig2) {
        this.enablePolicyServer = fDriverConfig2 instanceof fSocketConfig && ((fSocketConfig)fDriverConfig2).isEnablePolicyServer();
        this.drvconfig = fDriverConfig2;
    }

    public void setConnectionValidator(fConnectionValidator fConnectionValidator2) {
        this.myValidator = fConnectionValidator2;
    }

    public fConnectionValidator getConnectionValidator() {
        return this.myValidator;
    }

    protected String getRemoteAddress(fDriver fDriver2) throws fException {
        String string = "unknown";
        if (fDriver2.getType().toLowerCase().startsWith("nhp")) {
            fHTTPDSession fHTTPDSession2 = (fHTTPDSession)fDriver2;
            string = fHTTPDSession2.getClientHost();
            if (string == null || string.equalsIgnoreCase("unknown")) {
                String string2 = fDriver2.getId();
                int n = string2.lastIndexOf(":");
                if (n == -1) {
                    throw new fException("Authentication failed on remote address, connection ID was: " + string2);
                }
                string = string2.substring(0, n);
            }
        } else if (fDriver2.getType().equalsIgnoreCase("shm")) {
            string = "localhost";
        } else {
            String string3 = fDriver2.getId();
            int n = string3.lastIndexOf(":");
            if (n == -1) {
                throw new fException("Authentication failed on remote address, connection ID was: " + string3);
            }
            string = string3.substring(0, n);
        }
        return string;
    }

    fSubject loadSubject(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException, fException {
        byte[] byArray = new byte[]{fEventInputStream2.readByte()};
        fEventInputStream2.rollback(byArray);
        if (byArray[0] == sPolicyRequest[0] && this.enablePolicyServer) {
            if (myPolicyHandler != null) {
                fConstants.logger.info("Web policy request received for " + fDriver2.getId());
                myPolicyHandler.handlePolicyRequest(fDriver2, fEventInputStream2, fEventOutputStream2);
            } else {
                fConstants.logger.info("Web policy request received for " + fDriver2.getId() + " but no policy server configured");
                try {
                    fEventInputStream2.close();
                    fEventOutputStream2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fDriver2.close();
                }
                catch (fException fException2) {
                    // empty catch block
                }
            }
            return null;
        }
        if (myInterceptors.size() != 0) {
            int n = Math.min(fEventInputStream2.available(), myInterceptorDetectionSize);
            byte[] byArray2 = new byte[n];
            int n2 = fEventInputStream2.read(byArray2, 0, n);
            for (int i = 0; i < myInterceptors.size(); ++i) {
                fConnectionInterception fConnectionInterception2 = (fConnectionInterception)myInterceptors.elementAt(i);
                if (fConnectionInterception2.getStreamOffset() + fConnectionInterception2.getUniqueHeader().length > n2) continue;
                byte[] byArray3 = fConnectionInterception2.getUniqueHeader();
                byte by = fConnectionInterception2.getStreamOffset();
                boolean bl = true;
                for (int j = 0; j < byArray3.length; ++j) {
                    if (byArray2[by + j] == byArray3[j]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                fConstants.logger.info("Found connection for interceptor " + fConnectionInterception2.getName());
                fEventInputStream2.rollback(byArray2, 0, n2);
                if (fConnectionInterception2.isRestricted()) {
                    fConstants.logger.error("License does not permit creating an AMQP, MQTT or STOMP connection");
                    throw new fException("License does not permit creating an AMQP, MQTT or STOMP connection");
                }
                try {
                    if (!fConnectionInterception2.acceptDriver(fDriver2, fEventInputStream2, fEventOutputStream2, byArray2)) continue;
                    return null;
                }
                catch (Throwable throwable) {
                    fConstants.logger.info("Failed to intercept connection correctly, see following stack trace for details");
                    fConstants.logger.warn(throwable);
                    throw new IOException(throwable.getMessage());
                }
            }
            fEventInputStream2.rollback(byArray2, 0, n2);
        }
        fSubject fSubject2 = new fSubject();
        fSubject2.readExternal(fEventInputStream2);
        return fSubject2;
    }

    public abstract fServerLoginContext newInstance();

    static {
        myInterceptors = new Vector();
        myInterceptorDetectionSize = 0;
    }
}

