/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.drivers.fConnectionDetails;
import com.pcbsys.foundation.security.fCompositeServerLoginContext;
import com.pcbsys.foundation.security.fDefaultServerLoginContext;
import com.pcbsys.foundation.security.fProxyLoginContextFactory;
import com.pcbsys.foundation.security.fRawLoginContext;
import com.pcbsys.foundation.security.fSSLAnonymousServerLoginContext;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;

public class fServerLoginContextFactory {
    private fServerLoginContext[] myLoginContexts = new fServerLoginContext[17];
    protected static fServerLoginContextFactory myInstance;

    public static fServerLoginContextFactory getInstance() {
        if (myInstance == null) {
            String string = fSystemConfiguration.getProperty("CloudServer", null);
            myInstance = string != null ? new fProxyLoginContextFactory() : new fServerLoginContextFactory();
        }
        return myInstance;
    }

    public void reset() {
        for (int i = 0; i < this.myLoginContexts.length; ++i) {
            this.myLoginContexts[i] = new fRawLoginContext();
        }
    }

    fServerLoginContextFactory() {
        this.myLoginContexts[0] = new fCompositeServerLoginContext(0);
        this.myLoginContexts[1] = new fCompositeServerLoginContext(1);
        this.myLoginContexts[2] = new fCompositeServerLoginContext(2);
        this.myLoginContexts[3] = new fCompositeServerLoginContext(3);
        this.myLoginContexts[4] = new fSSLAnonymousServerLoginContext();
        this.myLoginContexts[5] = new fSSLAnonymousServerLoginContext();
        this.myLoginContexts[8] = new fRawLoginContext();
        this.myLoginContexts[12] = new fDefaultServerLoginContext();
        this.myLoginContexts[13] = new fDefaultServerLoginContext();
    }

    public fServerLoginContext getContext(String string) {
        int n = 0;
        try {
            n = fConnectionDetails.getProtocolType(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.myLoginContexts[n].newInstance();
    }
}

