/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security;

import com.pcbsys.foundation.base.fBaseTransportObject;
import com.pcbsys.foundation.collections.ByteArrayWrapper;
import com.pcbsys.foundation.collections.Vector;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.fAclGroup;
import com.pcbsys.foundation.security.fCredential;
import com.pcbsys.foundation.security.fPrincipal;
import com.pcbsys.foundation.utils.fReverseDNSUtility;
import com.pcbsys.foundation.utils.fStringByteConverter;
import java.io.IOException;

public class fSubject
extends fBaseTransportObject {
    public static final int Subject = 0;
    public static final int Group = 2;
    private final boolean isAuthenticated;
    String m_key = null;
    private String myHost = null;
    private String myUser = null;
    private byte[] myHostByte;
    private byte[] myUserByte;
    private byte[][] myPrincipalByte;
    private ByteArrayWrapper myUserWrapper;
    private ByteArrayWrapper[] myPrincipalWrapper;
    protected long mask = 0L;
    private Vector<fPrincipal> m_Principals = null;
    private Vector<fCredential> m_PubCredentials = null;
    private transient Vector<fCredential> m_PriCredentials = null;
    private transient boolean _isGroup = false;

    public fSubject() {
        this(false);
    }

    private fSubject(boolean bl) {
        this.m_Principals = new Vector();
        this.m_PubCredentials = new Vector();
        this.m_PriCredentials = new Vector();
        this.isAuthenticated = bl;
    }

    public fSubject(Vector<fPrincipal> vector, Vector<fCredential> vector2, Vector<fCredential> vector3, boolean bl) {
        this.m_Principals = vector;
        this.m_PubCredentials = vector2;
        this.m_PriCredentials = vector3;
        this.m_key = ((fPrincipal)this.m_Principals.elementAt(0)).toString();
        this.isAuthenticated = bl;
    }

    public fSubject(String string, boolean bl) {
        this(bl);
        this.m_key = fReverseDNSUtility.sanitiseV6(string);
        fPrincipal fPrincipal2 = new fPrincipal(this.m_key);
        this.m_Principals.add(fPrincipal2);
    }

    public fSubject(String string) {
        this(string, false);
    }

    public fSubject(String string, String string2, boolean bl) {
        this(string + "@" + string2, bl);
    }

    public fSubject(String string, String string2) {
        this(string, string2, false);
    }

    public fSubject(Vector<fPrincipal> vector, Vector<fCredential> vector2, Vector<fCredential> vector3) {
        this(vector, vector2, vector3, false);
    }

    public fSubject(fSubject fSubject2) {
        this(fSubject2.isAuthenticated);
        this.myHost = fSubject2.myHost;
        this.myUser = fSubject2.myUser;
        this._isGroup = fSubject2._isGroup;
        if (fSubject2.m_Principals != null) {
            this.m_Principals.addAll(fSubject2.m_Principals);
            this.m_key = ((fPrincipal)this.m_Principals.elementAt(0)).toString();
        }
        if (fSubject2.m_PubCredentials != null) {
            this.m_PubCredentials.addAll(fSubject2.m_PubCredentials);
        }
        if (fSubject2.m_PriCredentials != null) {
            this.m_PriCredentials.addAll(fSubject2.m_PriCredentials);
        }
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    public Vector<fPrincipal> getPrincipals() {
        return this.m_Principals;
    }

    Vector<fCredential> getPrivateCredentials() {
        return this.m_PriCredentials;
    }

    public Vector<fCredential> getPublicCredentials() {
        return this.m_PubCredentials;
    }

    public String getKey() {
        return this.toString();
    }

    public synchronized String getHost() {
        if (this.myHost == null) {
            String string = this.getKey();
            int n = string.indexOf("@");
            this.myHost = string.substring(n + 1, string.length());
        }
        return this.myHost;
    }

    public byte[] getHostByte() {
        if (this.myHostByte == null) {
            this.myHostByte = fStringByteConverter.convert(this.getHost());
        }
        return this.myHostByte;
    }

    public ByteArrayWrapper getUserByteWrapper() {
        if (this.myUserWrapper == null) {
            this.myUserWrapper = new ByteArrayWrapper(this.getUserByte());
        }
        return this.myUserWrapper;
    }

    public byte[] getUserByte() {
        if (this.myUserByte == null) {
            this.myUserByte = fStringByteConverter.convert(this.getUser());
        }
        return this.myUserByte;
    }

    public byte[] getPrincipalByte(int n) {
        if (this.myPrincipalByte == null) {
            this.myPrincipalByte = new byte[this.m_Principals.size()][];
        }
        if (this.myPrincipalByte[n] == null) {
            this.myPrincipalByte[n] = fStringByteConverter.convert(this.getUser(this.getPrincipal(n)));
        }
        return this.myPrincipalByte[n];
    }

    public ByteArrayWrapper getPrincipalByteWrapper(int n) {
        if (this.myPrincipalWrapper == null) {
            this.myPrincipalWrapper = new ByteArrayWrapper[this.m_Principals.size()];
        }
        if (this.myPrincipalWrapper[n] == null) {
            this.myPrincipalWrapper[n] = new ByteArrayWrapper(this.getPrincipalByte(n));
        }
        return this.myPrincipalWrapper[n];
    }

    void addPrincipal(String string) {
        fPrincipal fPrincipal2 = new fPrincipal(string.toLowerCase());
        this.m_Principals.add(fPrincipal2);
    }

    private fPrincipal getPrincipal(int n) {
        if (n > this.m_Principals.size()) {
            return null;
        }
        return (fPrincipal)this.m_Principals.elementAt(n);
    }

    public fPrincipal getPrincipalUser(int n) {
        if (n > this.m_Principals.size()) {
            return null;
        }
        return (fPrincipal)this.m_Principals.elementAt(n);
    }

    public int getNumberOfPrincipals() {
        return this.m_Principals.size();
    }

    public String getUser() {
        String string;
        int n;
        if (this.myUser == null && (n = (string = this.getKey()).indexOf("@")) > 0) {
            this.myUser = string.substring(0, n);
        }
        return this.myUser;
    }

    public String getUser(fPrincipal fPrincipal2) {
        int n = fPrincipal2.toString().indexOf("@");
        if (n > 0) {
            return fPrincipal2.toString().substring(0, n);
        }
        return fPrincipal2.toString();
    }

    public String toString() {
        if (this.isGroup()) {
            return this.getName();
        }
        if (this.m_key == null) {
            this.m_key = ((fPrincipal)this.m_Principals.elementAt(0)).toString();
        }
        return this.m_key;
    }

    public int hashCode() {
        return this.m_key.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof fSubject)) {
            return false;
        }
        fSubject fSubject2 = (fSubject)object;
        if (!fSubject2.canEqual(this)) {
            return false;
        }
        if (this.m_Principals.size() != fSubject2.m_Principals.size()) {
            return false;
        }
        for (int i = 0; i < this.m_Principals.size(); ++i) {
            if (((fPrincipal)this.m_Principals.get(i)).equals(fSubject2.m_Principals.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean canEqual(Object object) {
        return object instanceof fSubject;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n = fEventInputStream2.readInt();
        if (n > 3) {
            throw new IOException("Unexpected value");
        }
        if (n == 1) {
            this.readExternalfSubject(fEventInputStream2, n);
        } else {
            this.mask = fEventInputStream2.readLong();
            boolean bl = this._isGroup = n == 2;
            if (!this.isGroup()) {
                this.readExternalfSubject(fEventInputStream2, fEventInputStream2.readInt());
            }
        }
    }

    public void readExternalfSubject(fEventInputStream fEventInputStream2, int n) throws IOException {
        int n2;
        this.m_Principals = new Vector();
        for (n2 = 0; n2 < n; ++n2) {
            fPrincipal fPrincipal2 = new fPrincipal();
            fPrincipal2.readExternal(fEventInputStream2);
            this.m_Principals.add(fPrincipal2);
        }
        if (fEventInputStream2.readBoolean()) {
            n2 = fEventInputStream2.readInt();
            this.m_PubCredentials = new Vector();
            for (int i = 0; i < n2; ++i) {
                fCredential fCredential2 = new fCredential();
                fCredential2.readExternal(fEventInputStream2);
                this.m_PubCredentials.add(fCredential2);
            }
        }
        this.m_key = ((fPrincipal)this.m_Principals.elementAt(0)).toString();
    }

    void writeExternalCompatible(fEventOutputStream fEventOutputStream2) throws IOException {
        this.writeExternalfSubjectOld(fEventOutputStream2);
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        this.writeExternalfSubject(fEventOutputStream2);
    }

    private void writeExternalfSubjectOld(fEventOutputStream fEventOutputStream2) throws IOException {
        int n;
        fEventOutputStream2.writeInt(this.m_Principals.size());
        if (this.m_Principals.size() != 0) {
            for (n = 0; n < this.m_Principals.size(); ++n) {
                fPrincipal fPrincipal2 = (fPrincipal)this.m_Principals.elementAt(n);
                fPrincipal2.writeExternal(fEventOutputStream2);
            }
        }
        if (this.m_PubCredentials != null) {
            fEventOutputStream2.writeBoolean(true);
            n = this.m_PubCredentials.size();
            fEventOutputStream2.writeInt(n);
            if (n != 0) {
                for (int i = 0; i < this.m_PubCredentials.size(); ++i) {
                    fCredential fCredential2 = (fCredential)this.m_PubCredentials.elementAt(i);
                    fCredential2.writeExternal(fEventOutputStream2);
                }
            }
        } else {
            fEventOutputStream2.writeBoolean(false);
        }
    }

    private void writeExternalfSubject(fEventOutputStream fEventOutputStream2) throws IOException {
        int n;
        fEventOutputStream2.writeInt(0);
        fEventOutputStream2.writeLong(this.mask);
        fEventOutputStream2.writeInt(this.m_Principals.size());
        if (this.m_Principals.size() != 0) {
            for (n = 0; n < this.m_Principals.size(); ++n) {
                fPrincipal fPrincipal2 = (fPrincipal)this.m_Principals.elementAt(n);
                fPrincipal2.writeExternal(fEventOutputStream2);
            }
        }
        if (this.m_PubCredentials != null) {
            fEventOutputStream2.writeBoolean(true);
            n = this.m_PubCredentials.size();
            fEventOutputStream2.writeInt(n);
            if (n != 0) {
                for (int i = 0; i < this.m_PubCredentials.size(); ++i) {
                    fCredential fCredential2 = (fCredential)this.m_PubCredentials.elementAt(i);
                    fCredential2.writeExternal(fEventOutputStream2);
                }
            }
        } else {
            fEventOutputStream2.writeBoolean(false);
        }
    }

    public int getSize() {
        int n = 4;
        if (this.m_PubCredentials != null) {
            ++n;
            n += 4;
        } else {
            ++n;
        }
        return n;
    }

    public String getName() {
        return this.m_key;
    }

    public static fSubject parseFromExternal(fEventInputStream fEventInputStream2) throws IOException {
        fSubject fSubject2;
        int n = fEventInputStream2.readInt();
        if (n == 2) {
            fSubject2 = new fAclGroup();
            fSubject2.mask = fEventInputStream2.readLong();
            ((fAclGroup)fSubject2).readExternalfAclGroup(fEventInputStream2);
        } else {
            fSubject2 = new fSubject();
            if (n == 1) {
                fSubject2.readExternalfSubject(fEventInputStream2, n);
            } else {
                fSubject2.mask = fEventInputStream2.readLong();
                fSubject2.readExternalfSubject(fEventInputStream2, fEventInputStream2.readInt());
            }
        }
        return fSubject2;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }
}

