/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.sasl;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;

public class Defs {
    public static final byte AuthType_SASL = -2;
    public static final byte AuthType_JAAS = -3;
    public static final String MECHNAME_PLAIN = "PLAIN";
    public static final String MECHNAME_EXTERNAL = "EXTERNAL";
    public static final String MECHNAME_ANON = "ANONYMOUS";
    public static final String MECHNAME_CRAMMD5 = "CRAM-MD5";
    public static final String MECHNAME_DIGESTMD5 = "DIGEST-MD5";
    private static final String local_hostname = "localhost";
    private static final List<String> localHostSynonyms = Arrays.asList("localhost", "localhost.local", "localhost.localdomain", "localhost6", "localhost6.localdomain6", "loopback", "127.0.0.1", "::1", "0:0:0:0:0:0:0:1");
    public static final String DIGESTMD5_REALM = fSystemConfiguration.getProperty("Nirvana.sasl.digestmd5.realm", "UMREALM_DMD5");

    public static String JAASLoginContext2String(LoginContext loginContext, String string) {
        Subject subject = loginContext.getSubject();
        if (subject == null) {
            return "JAAS Subject is null for username=" + string;
        }
        Set<Principal> set = subject.getPrincipals();
        return "JAAS Subject for username=" + string + " has principals=" + set.size() + "/" + set + "; public creds=" + subject.getPublicCredentials().size() + "/" + subject.getPublicCredentials() + "; private=" + subject.getPrivateCredentials().size() + "/" + subject.getPrivateCredentials();
    }

    static String checkAgainstLocalHostNames(String string, String string2) {
        if (string.contains("%")) {
            string = string.split("%")[0];
        }
        for (String object : localHostSynonyms) {
            if (!string.equalsIgnoreCase(object)) continue;
            return local_hostname;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
            if (networkInterface != null) {
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress2 = enumeration.nextElement();
                    if (!string.equalsIgnoreCase(inetAddress2.getCanonicalHostName().split("%")[0]) && !string.equalsIgnoreCase(inetAddress2.getHostName().split("%")[0]) && !string.equalsIgnoreCase(inetAddress2.getHostAddress().split("%")[0])) continue;
                    return local_hostname;
                }
            }
            if (string.equalsIgnoreCase(inetAddress.getCanonicalHostName().split("%")[0]) || string.equalsIgnoreCase(inetAddress.getHostName().split("%")[0]) || string.equalsIgnoreCase(inetAddress.getHostAddress().split("%")[0])) {
                return local_hostname;
            }
        }
        catch (UnknownHostException unknownHostException) {
            fConstants.logger.warn("Unable to find localhost", unknownHostException);
        }
        catch (SocketException socketException) {
            fConstants.logger.warn("Unable to find network interface for localhost", socketException);
        }
        return string2;
    }
}

