/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.sasl;

import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.security.auth.fAuthConstants;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDefaultResponse;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.sasl.Defs;
import com.pcbsys.foundation.security.sasl.fSaslClientLoginContext;
import com.pcbsys.foundation.security.sasl.fSaslClientLoginModule;
import com.softwareag.security.jaas.login.SagCallbackHandler;
import com.softwareag.security.jaas.login.SagCredentials;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

class JaasHelper {
    private static final byte[] CTXTYPE_JAAS = new byte[]{-3};

    JaasHelper() {
    }

    static fLoginResponse doLogin(String string, fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2, fSaslClientLoginContext fSaslClientLoginContext2, String string2, char[] cArray) throws fAuthenticationException, IOException, LoginException {
        JaasClientMessage jaasClientMessage = new JaasClientMessage(fEventInputStream2, fEventOutputStream2);
        fSaslClientLoginModule.SaslCredentials saslCredentials = new fSaslClientLoginModule.SaslCredentials(fSaslClientLoginContext2, fDriver2, jaasClientMessage);
        saslCredentials.setUserName(string2);
        saslCredentials.setPassword(cArray);
        LoginContext loginContext = new LoginContext(string, (CallbackHandler)new SagCallbackHandler((SagCredentials)saslCredentials));
        loginContext.login();
        if (fAuthConstants.sDebug) {
            fConstants.logger.log(Defs.JAASLoginContext2String(loginContext, saslCredentials.getUserName()));
        }
        loginContext.logout();
        fLoginResponse fLoginResponse2 = fSaslClientLoginContext2.getLoginResponse();
        if (fLoginResponse2 == null) {
            Set<SagCredentials> set = loginContext.getSubject().getPrivateCredentials(SagCredentials.class);
            if (set.size() != 1) {
                throw new fAuthenticationException("JAAS authentication did not set expected SAG credentials for user=" + string2 + " - count=" + set.size() + "/" + loginContext.getSubject());
            }
            saslCredentials = set.iterator().next();
            jaasClientMessage.sendContextSelector(CTXTYPE_JAAS);
            jaasClientMessage.sendCredentials(saslCredentials);
            if (!jaasClientMessage.isAuthenticated()) {
                throw new fAuthenticationException("JAAS authentication failed for user=" + string2);
            }
            fLoginResponse2 = new fDefaultResponse(true);
        }
        return fLoginResponse2;
    }

    private static class JaasClientMessage
    extends fSaslClientLoginContext.ClientMessage {
        public JaasClientMessage(fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) {
            super(fEventInputStream2, fEventOutputStream2);
        }

        public void sendCredentials(SagCredentials sagCredentials) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(sagCredentials);
            this.os.writeByteArray(byteArrayOutputStream.toByteArray());
            this.os.flush();
        }

        public boolean isAuthenticated() throws IOException {
            return this.is.readBoolean();
        }
    }
}

