/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.sasl;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.security.auth.fAuthConstants;
import com.pcbsys.foundation.security.auth.fAuthentication;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDefaultResponse;
import com.pcbsys.foundation.security.fDefaultServerLoginContext;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.softwareag.security.jaas.login.SagCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

public class fExtAuthServerLoginContext
extends fDefaultServerLoginContext {
    private static final char COMPATMODE = fSystemConfiguration.getProperty("Nirvana.auth.server.jaascompat", "Y").toUpperCase().charAt(0);
    private static final int COMPAT_JAASTYPE_SERVER = 0;
    private static final int COMPAT_JAASTYPE_MUTUAL = 1;
    private static final byte STREAM_MAGIC1 = -84;
    private static final byte STREAM_MAGIC2 = -19;
    private static int session_id_counter;
    private int session_id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDebugSessionID() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.session_id = ++session_id_counter;
        }
    }

    private String debugPrefix() {
        return "JAAS-ServerLoginContext/" + this.session_id + ": [debug] ";
    }

    @Override
    public fServerLoginContext newInstance() {
        return new fExtAuthServerLoginContext();
    }

    @Override
    public fLoginResponse login(fDriver fDriver2) throws fException {
        try {
            fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
            return this.login(fDriver2, fEventInputStream2, fEventOutputStream2);
        }
        catch (Exception exception) {
            if (exception instanceof fException) {
                throw (fException)exception;
            }
            throw new fException("JAAS-Authentication failed with driver=" + (fDriver2 == null ? null : fDriver2.getClass().getName()), exception);
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException, fException {
        Object object;
        if (fAuthConstants.sDebug) {
            this.setDebugSessionID();
        }
        boolean bl = false;
        SagCredentials sagCredentials = null;
        String string = null;
        try {
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "New session with driver=" + (fDriver2 == null ? null : fDriver2.getClass().getName()) + ", compat=" + COMPATMODE);
            }
            object = this.receiveCredentials(fEventInputStream2);
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "Authenticating SAG-JAAS credentials=" + (object == null ? null : object.getClass().getName() + "/" + object));
            }
            sagCredentials = (SagCredentials)object;
            this.extractTransportCredentials(sagCredentials, fDriver2);
            if (!fAuthentication.authenticationEnabled) {
                bl = true;
            } else {
                string = fAuthentication.authenticate(sagCredentials);
                bl = true;
            }
        }
        catch (IOException iOException) {
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "Authentication failed - " + iOException);
            }
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "Authentication failed - " + classNotFoundException);
            }
            throw new fException(classNotFoundException);
        }
        finally {
            fEventOutputStream2.writeBoolean(bl);
            fEventOutputStream2.flush();
        }
        if (!bl) {
            Object object2 = object = sagCredentials == null ? null : sagCredentials.getUserName() + "/" + sagCredentials;
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "Failed to authenticate username=" + (String)object);
            }
            throw new fAuthenticationException("Failed to authenticate JAAS-based credentials for username=" + (String)object);
        }
        object = string == null ? sagCredentials.getUserName().toLowerCase() : string;
        String string2 = fDriver2 == null ? "localhost" : this.getRemoteAddress(fDriver2);
        fSubject fSubject2 = new fSubject((String)object, string2, fAuthentication.authenticationEnabled);
        if (fAuthConstants.sDebug) {
            fConstants.logger.log(this.debugPrefix() + "Authenticated user=" + (String)object + " as " + fSubject2);
        }
        this.setSubject(fSubject2);
        if (fDriver2 != null) {
            fDriver2.setSubject(fSubject2);
        }
        return new fDefaultResponse(true);
    }

    private Object receiveCredentials(fEventInputStream fEventInputStream2) throws IOException, ClassNotFoundException {
        if (COMPATMODE == 'F') {
            return this.receiveCredentialsCompat(fEventInputStream2);
        }
        if (COMPATMODE == 'N') {
            return this.receiveCredentialsSAG(fEventInputStream2);
        }
        byte[] byArray = new byte[6];
        int n = fEventInputStream2.read(byArray);
        if (n != byArray.length) {
            throw new IllegalArgumentException("Insufficient credentials data for any compat mode - read=" + n);
        }
        fEventInputStream2.rollback(byArray);
        if (byArray[0] != 0) {
            return this.receiveCredentialsCompat(fEventInputStream2);
        }
        if (byArray[4] == -84 && byArray[5] == -19) {
            return this.receiveCredentialsSAG(fEventInputStream2);
        }
        return this.receiveCredentialsCompat(fEventInputStream2);
    }

    private Object receiveCredentialsSAG(fEventInputStream fEventInputStream2) throws IOException, ClassNotFoundException {
        byte[] byArray = fEventInputStream2.readByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        return objectInputStream.readObject();
    }

    private Object receiveCredentialsCompat(fEventInputStream fEventInputStream2) throws IOException, ClassNotFoundException {
        byte by = fEventInputStream2.readByte();
        if (fAuthConstants.sDebug) {
            fConstants.logger.log(this.debugPrefix() + "Receiving credentials in compat-mode=" + by);
        }
        if (by == 1) {
            return this.receiveCredentialsSAG(fEventInputStream2);
        }
        if (by != 0) {
            throw new IllegalArgumentException("Invalid JAAS-type compat-mode=" + by);
        }
        String string = fEventInputStream2.readString();
        String string2 = fEventInputStream2.readString();
        return fAuthentication.constructCredentials(string, string2);
    }
}

