/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.sasl;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.security.auth.fAuthConstants;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.auth.fSAGInternalUserRepositoryAdapter;
import com.pcbsys.foundation.security.fClientLoginContext;
import com.pcbsys.foundation.security.fDefaultLoginContext;
import com.pcbsys.foundation.security.fDefaultResponse;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fLoginContextSSLAttributes;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.security.sasl.Defs;
import com.pcbsys.foundation.security.sasl.JaasHelper;
import com.pcbsys.foundation.security.sasl.Message;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class fSaslClientLoginContext
extends fDefaultLoginContext
implements fLoginContextSSLAttributes {
    public static final String SYSPROP_JAASKEY = "Nirvana.auth.client.jaaskey";
    private static final String JAASKEY_COMPAT_NOAUTH = "noauth";
    private static final String[] MECHPREFS = new String[]{"PLAIN", "CRAM-MD5", "DIGEST-MD5", "EXTERNAL"};
    private static String MECH_OVERRIDE = fSystemConfiguration.getProperty("Nirvana.sasl.client.mechanism");
    private static boolean SASL_LOCALHOST_REVERSE_RESOLVE = Boolean.parseBoolean(System.getProperty("Nirvana.sasl.client.localhostResolve", "True"));
    private static boolean PASSWORD_PREHASH = Boolean.parseBoolean(fSystemConfiguration.getProperty("Nirvana.sasl.client.enablePrehash"));
    private static final String HASH_TYPE = fSystemConfiguration.getProperty("Nirvana.sasl.client.prehashtype");
    private static final byte[] CTXTYPE_SASL = new byte[]{-2};
    private final String driver_protocol;
    private final CredentialsHolder creds;
    private fLoginResponse loginrsp;
    private String keyStorePath;
    private String keyStorePass;
    private String keyStoreCert;
    private String trustStorePath;
    private String trustStorePass;
    private String sslProtocol;
    private String[] enabledCiphers;
    private String pkcs11NSSConfigFile;
    private String pkcs11NSSName;
    private boolean isCramOrDigest = false;
    private static int session_id_counter;
    private int session_id;

    static void setMechOverride(String string) {
        MECH_OVERRIDE = string;
    }

    public static void setPasswordPrehash(boolean bl) {
        PASSWORD_PREHASH = bl;
    }

    String getUsername() {
        return this.creds.username;
    }

    fLoginResponse getLoginResponse() {
        return this.loginrsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDebugSessionID() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.session_id = ++session_id_counter;
        }
    }

    private static String debugPrefix(int n) {
        return "SASL-ClientLoginContext/" + n + ": [debug] ";
    }

    private String debugPrefix() {
        return fSaslClientLoginContext.debugPrefix(this.session_id);
    }

    public fSaslClientLoginContext(String string, String string2, String string3) {
        super(string2);
        this.creds = new CredentialsHolder(string2, string3);
        this.driver_protocol = string.toLowerCase();
    }

    @Override
    public fLoginResponse login(fDriver fDriver2) throws fException {
        try {
            fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
            return this.login(fDriver2, fEventInputStream2, fEventOutputStream2);
        }
        catch (Exception exception) {
            if (exception instanceof fException) {
                throw (fException)exception;
            }
            throw new fException("SASL-Authentication failed with driver=" + (fDriver2 == null ? null : fDriver2.getClass().getName()), exception);
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws fAuthenticationException, IOException {
        Object object;
        fLoginContext fLoginContext2;
        String string = fSystemConfiguration.getProperty(SYSPROP_JAASKEY);
        if (fAuthConstants.sDebug) {
            this.setDebugSessionID();
            fConstants.logger.log(this.debugPrefix() + "Authenticating user=" + this.creds.username + " with JAAS=" + string + " - driver=" + (fDriver2 == null ? null : fDriver2.getClass().getName()));
        }
        if (string != null && !string.equals(JAASKEY_COMPAT_NOAUTH)) {
            try {
                this.loginrsp = JaasHelper.doLogin(string, fDriver2, fEventInputStream2, fEventOutputStream2, this, this.creds.username, this.creds.password.toCharArray());
            }
            catch (Exception exception) {
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "JAAS authentication failed for user=" + this.creds.username + " - " + exception);
                }
                if (exception instanceof fAuthenticationException) {
                    throw (fAuthenticationException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new fAuthenticationException(exception);
            }
            fLoginContext2 = this;
        } else {
            object = new ClientMessage(fEventInputStream2, fEventOutputStream2);
            try {
                fLoginContext2 = this.doLogin(fDriver2, (ClientMessage)object);
            }
            catch (Exception exception) {
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "SASL negotiation failed - " + exception);
                }
                if (exception instanceof fAuthenticationException) {
                    throw (fAuthenticationException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new fAuthenticationException(exception);
            }
        }
        if (fLoginContext2 == this) {
            String string2 = InetAddress.getLocalHost().getHostName();
            object = new fSubject(this.creds.username.toLowerCase(), string2);
        } else {
            object = fLoginContext2.getSubject();
        }
        this.setSubject((fSubject)object);
        if (fDriver2 != null) {
            fDriver2.setSubject((fSubject)object);
        }
        return this.loginrsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    fLoginContext doLogin(fDriver fDriver2, ClientMessage clientMessage) throws fException, IOException, ClassNotFoundException {
        fLoginContext fLoginContext2;
        String string;
        void var6_8;
        String[] stringArray;
        if (MECH_OVERRIDE == null) {
            stringArray = MECHPREFS;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = MECH_OVERRIDE;
        }
        String[] stringArray3 = stringArray;
        String string2 = fDriver2.getConnectionDetails().getHost();
        if (SASL_LOCALHOST_REVERSE_RESOLVE) {
            string2 = Defs.checkAgainstLocalHostNames(string2, string2);
        }
        fConstants.logger.debug(this.debugPrefix() + "client using Digest URI for server: " + string2);
        SaslClient saslClient = null;
        for (String string3 : stringArray3) {
            this.isCramOrDigest = string3.equalsIgnoreCase("DIGEST-MD5") || string3.equalsIgnoreCase("CRAM-MD5");
            saslClient = Sasl.createSaslClient(new String[]{string3}, null, "NirvanaSASL", string2, null, this.creds);
            if (saslClient != null) break;
        }
        if (saslClient == null) {
            throw new SaslException("Failed to create SASL client for mechs=" + Arrays.asList(stringArray3) + ", proto=" + "NirvanaSASL");
        }
        String string4 = saslClient.getMechanismName();
        try {
            byte[] byArray = (byte[])(saslClient.hasInitialResponse() ? Message.NULLMSG : null);
            clientMessage.sendContextSelector(CTXTYPE_SASL);
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "Mechanism=" + string4 + ", srvname=" + string2 + ", initial challenge=" + (byArray == null ? null : byArray.length + "/" + new String(byArray)) + " - state=" + clientMessage.status);
            }
            while (!saslClient.isComplete()) {
                byte[] byArray2;
                byte[] byArray3 = byArray2 = byArray == null ? null : saslClient.evaluateChallenge(byArray);
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "Constructed response=" + (byArray2 == null ? null : byArray2.length + "/" + new String(byArray2)) + " - state=" + clientMessage.status + ", complete=" + saslClient.isComplete());
                }
                if (clientMessage.status == 2 && byArray2 != null) {
                    throw new SaslException("Protocol out of sync during SASL-" + saslClient.getMechanismName() + " for user=" + this.creds.username + " - " + new String(byArray2));
                }
                if (!saslClient.isComplete() || byArray2 != null) {
                    clientMessage.sendResponse((String)var6_8, byArray2);
                }
                string = null;
                if (clientMessage.status == 1) {
                    byArray = clientMessage.readChallenge(saslClient.getMechanismName(), this.creds.username);
                    if (fAuthConstants.sDebug) {
                        fConstants.logger.log(this.debugPrefix() + "Received challenge=" + (byArray == null ? null : byArray.length + "/" + new String(byArray)) + " - state=" + clientMessage.status);
                    }
                }
                if (clientMessage.status != 4) break block22;
                if (this.driver_protocol.equals("nhp") || this.driver_protocol.equals("nhps")) {
                    throw new fAuthenticationException(1);
                }
                fLoginContext fLoginContext3 = fClientLoginContext.getInstance(this.driver_protocol, this.creds.username.toLowerCase());
                this.loginrsp = fLoginContext3.login(fDriver2);
                fLoginContext2 = fLoginContext3;
            }
        }
        catch (Throwable throwable) {
            try {
                saslClient.dispose();
            }
            catch (Throwable throwable2) {
                fConstants.logger.log(this.debugPrefix() + "Failed to dispose of " + saslClient.getClass().getName() + " for mech=" + (String)var6_8 + " - " + throwable2);
            }
            throw throwable;
        }
        {
            block22: {
                try {
                    saslClient.dispose();
                }
                catch (Throwable throwable) {
                    fConstants.logger.log(this.debugPrefix() + "Failed to dispose of " + saslClient.getClass().getName() + " for mech=" + string + " - " + throwable);
                }
                return fLoginContext2;
            }
            continue;
        }
        try {
            saslClient.dispose();
        }
        catch (Throwable throwable) {
            fConstants.logger.log(this.debugPrefix() + "Failed to dispose of " + saslClient.getClass().getName() + " for mech=" + (String)var6_8 + " - " + throwable);
        }
        this.loginrsp = new fDefaultResponse(true);
        return this;
    }

    @Override
    public void setKeyStore(String string, String string2, String string3) {
        this.keyStorePath = string;
        this.keyStorePass = string2;
        this.keyStoreCert = string3;
    }

    @Override
    public void setTrustStore(String string, String string2) {
        this.trustStorePath = string;
        this.trustStorePass = string2;
    }

    @Override
    public void setSSLProtocol(String string) {
        this.sslProtocol = string;
    }

    @Override
    public void setEnabledCiphers(String[] stringArray) {
        this.enabledCiphers = stringArray;
    }

    @Override
    public void setPKCS11NSSConfigFile(String string) {
        this.pkcs11NSSConfigFile = string;
    }

    @Override
    public void setPKCS11NSSName(String string) {
        this.pkcs11NSSName = string;
    }

    @Override
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Override
    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    @Override
    public String getKeyStoreCert() {
        return this.keyStoreCert;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Override
    public String getTrustStorePass() {
        return this.trustStorePass;
    }

    @Override
    public String getProtocol() {
        return this.sslProtocol;
    }

    @Override
    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    @Override
    public String getPKCS11NSSConfigFile() {
        return this.pkcs11NSSConfigFile;
    }

    @Override
    public String getPKCS11NSSName() {
        return this.pkcs11NSSName;
    }

    public class CredentialsHolder
    implements CallbackHandler {
        public final String username;
        private final String password;

        public CredentialsHolder(String string, String string2) {
            if (string2 == null) {
                string2 = "";
            }
            this.username = string;
            this.password = string2;
        }

        @Override
        public void handle(Callback[] callbackArray) {
            for (Callback callback : callbackArray) {
                Callback callback2;
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(fSaslClientLoginContext.debugPrefix(0) + "Callback=" + callback + "/" + callbackArray.length);
                }
                if (callback instanceof NameCallback) {
                    callback2 = (NameCallback)callback;
                    if (fAuthConstants.sDebug) {
                        fConstants.logger.log(fSaslClientLoginContext.debugPrefix(0) + "NameCallback: Default=" + ((NameCallback)callback2).getDefaultName() + ", Current=" + ((NameCallback)callback2).getName());
                    }
                    ((NameCallback)callback2).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    callback2 = (PasswordCallback)callback;
                    if (fSaslClientLoginContext.this.isCramOrDigest && PASSWORD_PREHASH) {
                        ((PasswordCallback)callback2).setPassword(fSAGInternalUserRepositoryAdapter.hashedPassword(this.username, this.password, HASH_TYPE).toCharArray());
                        continue;
                    }
                    ((PasswordCallback)callback2).setPassword(this.password.toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    callback2 = (RealmCallback)callback;
                    if (fAuthConstants.sDebug) {
                        fConstants.logger.log(fSaslClientLoginContext.debugPrefix(0) + "RealmCallback: " + ((TextInputCallback)callback2).getPrompt() + " Default=" + ((TextInputCallback)callback2).getDefaultText() + ", Current=" + ((TextInputCallback)callback2).getText());
                    }
                    ((TextInputCallback)callback2).setText(((TextInputCallback)callback2).getDefaultText());
                    continue;
                }
                if (!(callback instanceof RealmChoiceCallback)) continue;
                callback2 = (RealmChoiceCallback)callback;
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(fSaslClientLoginContext.debugPrefix(0) + "RealmChoiceCallback: " + ((ChoiceCallback)callback2).getPrompt() + " Choices=" + Arrays.asList(((ChoiceCallback)callback2).getChoices()) + "/Default=" + ((ChoiceCallback)callback2).getDefaultChoice() + ", Selected=" + Arrays.asList(new int[][]{((ChoiceCallback)callback2).getSelectedIndexes()}) + "/allowmult=" + ((ChoiceCallback)callback2).allowMultipleSelections());
                }
                ((ChoiceCallback)callback2).setSelectedIndex(((ChoiceCallback)callback2).getDefaultChoice());
            }
        }
    }

    static class ClientMessage
    extends Message {
        public byte status = 1;

        public ClientMessage(fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) {
            super(fEventInputStream2, fEventOutputStream2);
        }

        public byte[] readChallenge(String string, String string2) throws fAuthenticationException, IOException, ClassNotFoundException {
            this.status = this.is.readByte();
            if (this.status == 3) {
                throw new fAuthenticationException("Authentication failed during SASL-" + string + " for user=" + string2);
            }
            return this.readMessage();
        }

        public void sendContextSelector(byte[] byArray) throws IOException {
            this.os.write(byArray);
        }

        public void sendResponse(String string, byte[] byArray) throws IOException {
            if (string != null) {
                this.os.writeString(string);
            }
            this.write(byArray);
            this.os.flush();
        }
    }
}

