/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.security.sasl;

import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.drivers.fDriver;
import com.pcbsys.foundation.drivers.fHTTPDSession;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.io.fStreamFactory;
import com.pcbsys.foundation.security.auth.fAdapterDirectory;
import com.pcbsys.foundation.security.auth.fAttribute;
import com.pcbsys.foundation.security.auth.fAuthConstants;
import com.pcbsys.foundation.security.auth.fAuthentication;
import com.pcbsys.foundation.security.auth.fAuthenticationException;
import com.pcbsys.foundation.security.fDefaultResponse;
import com.pcbsys.foundation.security.fDefaultServerLoginContext;
import com.pcbsys.foundation.security.fLoginContext;
import com.pcbsys.foundation.security.fLoginResponse;
import com.pcbsys.foundation.security.fSSLServerLoginContext;
import com.pcbsys.foundation.security.fServerLoginContext;
import com.pcbsys.foundation.security.fSubject;
import com.pcbsys.foundation.security.sasl.Defs;
import com.pcbsys.foundation.security.sasl.Message;
import com.pcbsys.foundation.utils.fSystemConfiguration;
import com.softwareag.security.jaas.login.SagCredentials;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class fSaslServerLoginContext
extends fDefaultServerLoginContext {
    public static final boolean ALT_AUTHID_PERMITTED;
    private static final String[] ENABLED_MECHANISMS;
    private static boolean SASL_LOCALHOST_REVERSE_RESOLVE;
    private static final String PASSWD_CHARSET;
    private static final String URI_hostname;
    private static int session_id_counter;
    private int session_id;
    @Deprecated
    public static final boolean authenticationMandatory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDebugSessionID() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.session_id = ++session_id_counter;
        }
    }

    private static String debugPrefix(int n) {
        return "SASL-ServerLoginContext/" + n + ": [debug] ";
    }

    private String debugPrefix() {
        return fSaslServerLoginContext.debugPrefix(this.session_id);
    }

    @Deprecated
    public static boolean isExempt(fSubject fSubject2) {
        return fAuthentication.isExempt(fSubject2);
    }

    @Override
    public fServerLoginContext newInstance() {
        return new fSaslServerLoginContext();
    }

    @Override
    public fLoginResponse login(fDriver fDriver2) throws fException {
        try {
            fEventInputStream fEventInputStream2 = fStreamFactory.createInputStream(fDriver2.getInputStream());
            fEventOutputStream fEventOutputStream2 = new fEventOutputStream(fDriver2.getOutputStream());
            return this.login(fDriver2, fEventInputStream2, fEventOutputStream2);
        }
        catch (Exception exception) {
            if (exception instanceof fException) {
                throw (fException)exception;
            }
            throw new fException("SASL-Authentication failed with driver=" + (fDriver2 == null ? null : fDriver2.getClass().getName()), exception);
        }
    }

    @Override
    public fLoginResponse login(fDriver fDriver2, fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) throws IOException, fException {
        fSubject fSubject2;
        fLoginResponse fLoginResponse2;
        if (fAuthConstants.sDebug) {
            this.setDebugSessionID();
        }
        String string = fDriver2 == null ? "localhost" : fDriver2.getConnectionDetails().getHost();
        String string2 = URI_hostname;
        if (SASL_LOCALHOST_REVERSE_RESOLVE) {
            string2 = Defs.checkAgainstLocalHostNames(string, URI_hostname);
        }
        ServerMessage serverMessage = new ServerMessage(fEventInputStream2, fEventOutputStream2);
        String string3 = serverMessage.readMechanism();
        if (fAuthConstants.sDebug) {
            fConstants.logger.log(this.debugPrefix() + "New session with mechanism=" + string3 + "/enabled=" + fAuthentication.authenticationEnabled + "/" + fSaslServerLoginContext.isMechanismEnabled(string3) + ", remote=" + string + ", srvname=" + string2 + " - driver=" + (fDriver2 == null ? null : fDriver2.getClass().getName()));
        }
        if (!fAuthentication.authenticationEnabled) {
            serverMessage.readMessage();
            serverMessage.sendChallenge((byte)4, null);
            if (fDriver2 instanceof fHTTPDSession) {
                fDriver2.close();
                throw new fAuthenticationException(2);
            }
            fDefaultServerLoginContext fDefaultServerLoginContext2 = fDriver2.isRequireClientAuth() ? new fSSLServerLoginContext() : new fDefaultServerLoginContext();
            if (this.drvconfig != null) {
                fDefaultServerLoginContext2.setConfig(this.drvconfig);
            }
            fLoginResponse2 = ((fLoginContext)fDefaultServerLoginContext2).login(fDriver2, fEventInputStream2, fEventOutputStream2);
            fSubject2 = fDefaultServerLoginContext2.getSubject();
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(this.debugPrefix() + "Accepted user without authentication - Subject=" + fSubject2);
            }
        } else {
            try {
                String string4;
                Object object;
                if (!fSaslServerLoginContext.isMechanismEnabled(string3)) {
                    serverMessage.sendChallenge((byte)3, null);
                    throw new SaslException("SASL-" + string3 + " not enabled");
                }
                if (string3.equals("PLAIN")) {
                    object = new SagCredentials();
                    this.extractTransportCredentials((SagCredentials)object, fDriver2);
                    string4 = this.loginSaslPlain(serverMessage, (SagCredentials)object);
                    serverMessage.sendChallenge((byte)2, null);
                } else {
                    string4 = this.loginJavaAPI(string3, string2, serverMessage);
                }
                object = string4.toLowerCase();
                String string5 = fDriver2 == null ? "localhost" : this.getRemoteAddress(fDriver2);
                fSubject2 = new fSubject((String)object, string5, true);
                fLoginResponse2 = new fDefaultResponse(true);
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "Authenticated user=" + string4 + " as " + fSubject2);
                }
            }
            catch (Exception exception) {
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "SASL negotiation failed - " + exception);
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (exception instanceof fException) {
                    throw (fException)exception;
                }
                throw new fException(exception);
            }
        }
        this.setSubject(fSubject2);
        if (fDriver2 != null) {
            fDriver2.setSubject(fSubject2);
        }
        return fLoginResponse2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loginJavaAPI(String string, String string2, ServerMessage serverMessage) throws IOException, ClassNotFoundException {
        SaslServer saslServer;
        if (!fAuthentication.isEnabledDirectory()) {
            throw new SaslException("SASL-" + string + " requires Directory support");
        }
        CredentialsHandler credentialsHandler = new CredentialsHandler();
        HashMap<String, String> hashMap = null;
        if (string.equalsIgnoreCase("DIGEST-MD5")) {
            hashMap = new HashMap<String, String>();
            hashMap.put("com.sun.security.sasl.digest.realm", Defs.DIGESTMD5_REALM);
        }
        if ((saslServer = Sasl.createSaslServer(string, "NirvanaSASL", string2, hashMap, credentialsHandler)) == null) {
            serverMessage.sendChallenge((byte)3, null);
            throw new SaslException("SASL-" + string + " not supported");
        }
        try {
            Object object;
            while (!saslServer.isComplete()) {
                byte[] byArray;
                object = serverMessage.readMessage();
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "Received response=" + (object == null ? null : ((byte[])object).length + "/" + new String((byte[])object)));
                }
                try {
                    byArray = saslServer.evaluateResponse(object == null ? Message.NULLMSG : object);
                }
                catch (SaslException saslException) {
                    serverMessage.sendChallenge((byte)3, null);
                    throw saslException;
                }
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(this.debugPrefix() + "Sending challenge=" + (byArray == null ? null : byArray.length + "/" + new String(byArray)) + " - complete=" + saslServer.isComplete());
                }
                serverMessage.sendChallenge(saslServer.isComplete() ? (byte)2 : 1, byArray);
            }
            object = saslServer.getAuthorizationID();
            return object;
        }
        finally {
            try {
                saslServer.dispose();
            }
            catch (Throwable throwable) {
                fConstants.logger.log(this.debugPrefix() + "Failed to dispose of " + saslServer.getClass().getName() + " for mech=" + string + " - " + throwable);
            }
        }
    }

    private String loginSaslPlain(ServerMessage serverMessage, SagCredentials sagCredentials) throws fAuthenticationException, IOException, ClassNotFoundException, NamingException {
        byte[] byArray = serverMessage.readMessage();
        if (fAuthConstants.sDebug) {
            fConstants.logger.log(this.debugPrefix() + "Received PLAIN response=" + (byArray == null ? null : Integer.valueOf(byArray.length)));
        }
        String string = null;
        fAuthenticationException fAuthenticationException2 = null;
        try {
            string = fSaslServerLoginContext.processSaslPlainResponse(byArray, this.session_id, sagCredentials);
        }
        catch (fAuthenticationException fAuthenticationException3) {
            fAuthenticationException2 = fAuthenticationException3;
        }
        if (fAuthenticationException2 != null) {
            serverMessage.sendChallenge((byte)3, null);
            throw fAuthenticationException2;
        }
        return string;
    }

    public static String processSaslPlainResponse(byte[] byArray, int n, int n2, boolean bl, SagCredentials sagCredentials) throws fAuthenticationException, IOException, NamingException {
        return fSaslServerLoginContext.processSaslPlainResponse(byArray, n, n2, bl, 0, sagCredentials);
    }

    private static String processSaslPlainResponse(byte[] byArray, int n, int n2, boolean bl, int n3, SagCredentials sagCredentials) throws fAuthenticationException, IOException, NamingException {
        ArrayList<String> arrayList = fSaslServerLoginContext.parseSaslPlainResponse(byArray, n, n2);
        String string = arrayList.get(0);
        String string2 = arrayList.get(1);
        String string3 = arrayList.get(2);
        if (fAuthConstants.sDebug) {
            fConstants.logger.log(fSaslServerLoginContext.debugPrefix(n3) + "Authenticating PLAIN username=" + string2 + " - authorisation-ID=" + string + "/allowed=" + bl);
        }
        sagCredentials.setUserName(string2);
        sagCredentials.setPassword(string3 == null ? null : string3.toCharArray());
        if (string != null) {
            sagCredentials.setExtendedProperty("SASL_AUTHORIZATION_ID", (Object)string);
        }
        if ((string2 = fAuthentication.authenticate(sagCredentials)) == null) {
            throw new fAuthenticationException("SASL-PLAIN authentication failed on username=" + string2);
        }
        if (string != null && !string.equals(string2)) {
            if (!bl) {
                throw new fAuthenticationException("SASL-PLAIN authentication failed - rejecting alternative authorisation-ID=" + string + " for user=" + string2);
            }
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(fSaslServerLoginContext.debugPrefix(n3) + "authorisation-ID=" + string + " is acting identity for authentication-ID=" + string2);
            }
            string2 = string;
        }
        return string2;
    }

    public static ArrayList<String> parseSaslPlainResponse(byte[] byArray, int n, int n2) throws fAuthenticationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n + n2;
        int n4 = n;
        for (int i = n; i != n3; ++i) {
            if (byArray[i] != 0) continue;
            String string = fSaslServerLoginContext.parseResponseElement(byArray, n4, i);
            arrayList.add(string);
            n4 = i + 1;
        }
        String string = fSaslServerLoginContext.parseResponseElement(byArray, n4, n3);
        arrayList.add(string);
        if (arrayList.size() != 3) {
            throw new fAuthenticationException("Invalid SASL-Plain response - NULs=" + (arrayList.size() - 1));
        }
        return arrayList;
    }

    public static String processSaslPlainResponse(byte[] byArray, SagCredentials sagCredentials) throws fAuthenticationException, IOException, NamingException {
        return fSaslServerLoginContext.processSaslPlainResponse(byArray, 0, byArray.length, ALT_AUTHID_PERMITTED, 0, sagCredentials);
    }

    private static String processSaslPlainResponse(byte[] byArray, int n, SagCredentials sagCredentials) throws fAuthenticationException, IOException, NamingException {
        return fSaslServerLoginContext.processSaslPlainResponse(byArray, 0, byArray.length, ALT_AUTHID_PERMITTED, n, sagCredentials);
    }

    public static ArrayList<String> parseSaslPlainResponse(byte[] byArray) throws fAuthenticationException {
        return fSaslServerLoginContext.parseSaslPlainResponse(byArray, 0, byArray.length);
    }

    private static String parseResponseElement(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 == 0) {
            return null;
        }
        return new String(byArray, n, n3);
    }

    public static boolean isMechanismEnabled(String string) {
        if (ENABLED_MECHANISMS == null) {
            return true;
        }
        for (int i = 0; i != ENABLED_MECHANISMS.length; ++i) {
            if (!string.equalsIgnoreCase(ENABLED_MECHANISMS[i])) continue;
            return true;
        }
        return false;
    }

    public static String getEnabledMechanism(String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            String string = stringArray[i];
            if (!fSaslServerLoginContext.isMechanismEnabled(string)) continue;
            return string;
        }
        return null;
    }

    private static String[] getEnabledMechanisms(String string) {
        String string2 = fSystemConfiguration.getProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(",");
        for (int i = 0; i != stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        if (stringArray.length == 1 && stringArray[0].length() == 0) {
            return null;
        }
        return stringArray;
    }

    static {
        String string;
        ALT_AUTHID_PERMITTED = "Y".equalsIgnoreCase(fSystemConfiguration.getProperty("Nirvana.auth.permit_altuser", "N"));
        ENABLED_MECHANISMS = fSaslServerLoginContext.getEnabledMechanisms("Nirvana.sasl.server.mechanisms");
        SASL_LOCALHOST_REVERSE_RESOLVE = Boolean.parseBoolean(System.getProperty("Nirvana.sasl.server.localhostResolve", "True"));
        PASSWD_CHARSET = fSystemConfiguration.getProperty("Nirvana.password.charset", "UTF-8");
        try {
            string = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception exception) {
            fConstants.logger.info("SaslServerLoginContext failed to determine local hostname - " + exception);
            string = "localhost";
        }
        URI_hostname = string;
        authenticationMandatory = fAuthentication.authenticationMandatory;
    }

    public static class CredentialsHandler
    implements CallbackHandler {
        private final fAdapterDirectory dtory = fAdapterDirectory.getInstance();
        private String username;
        private char[] password;

        @Override
        public void handle(Callback[] callbackArray) throws IOException {
            for (Callback callback : callbackArray) {
                Callback callback2;
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(fSaslServerLoginContext.debugPrefix(0) + "Callback=" + callback + "/" + callbackArray.length);
                }
                if (callback instanceof AuthorizeCallback) {
                    callback2 = (AuthorizeCallback)callback;
                    if (fAuthConstants.sDebug) {
                        fConstants.logger.log(fSaslServerLoginContext.debugPrefix(0) + "AuthorizeCallback: AuthenticationID=" + ((AuthorizeCallback)callback2).getAuthenticationID() + ", AuthorisationID=" + ((AuthorizeCallback)callback2).getAuthorizationID() + "/" + ((AuthorizeCallback)callback2).getAuthorizedID() + "/" + ((AuthorizeCallback)callback2).isAuthorized());
                    }
                    ((AuthorizeCallback)callback2).setAuthorized(this.username != null);
                    continue;
                }
                if (callback instanceof NameCallback) {
                    callback2 = (NameCallback)callback;
                    if (fAuthConstants.sDebug) {
                        fConstants.logger.log(fSaslServerLoginContext.debugPrefix(0) + "NameCallback: Default=" + ((NameCallback)callback2).getDefaultName() + ", Current=" + ((NameCallback)callback2).getName());
                    }
                    this.username = ((NameCallback)callback2).getDefaultName();
                    try {
                        this.password = (char[])this.getDirectoryPassword(this.username, char[].class);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new IOException("SASL-Server failed on Directory=" + this.dtory + " lookup for username=" + this.username + " - " + exception);
                    }
                }
                if (callback instanceof PasswordCallback) {
                    callback2 = (PasswordCallback)callback;
                    ((PasswordCallback)callback2).setPassword(this.password);
                    this.password = null;
                    continue;
                }
                if (!(callback instanceof RealmCallback)) continue;
                callback2 = (RealmCallback)callback;
                if (fAuthConstants.sDebug) {
                    fConstants.logger.log(fSaslServerLoginContext.debugPrefix(0) + "RealmCallback: " + ((TextInputCallback)callback2).getPrompt() + " Default=" + ((TextInputCallback)callback2).getDefaultText() + ", Current=" + ((TextInputCallback)callback2).getText());
                }
                ((TextInputCallback)callback2).setText(((TextInputCallback)callback2).getDefaultText());
            }
        }

        private Object getDirectoryPassword(String string, Class<?> clazz) throws fAuthenticationException, IOException, UnsupportedEncodingException, NamingException {
            fAttribute fAttribute2 = this.dtory.lookup(string, "PASSWORD");
            if (fAttribute2 == null) {
                return null;
            }
            Object object = fAttribute2.getValue();
            if (object == null) {
                object = "";
            }
            if (object instanceof String) {
                if (clazz == char[].class) {
                    return ((String)String.class.cast(object)).toCharArray();
                }
                return ((String)String.class.cast(object)).getBytes(PASSWD_CHARSET);
            }
            if (object instanceof char[]) {
                if (clazz == char[].class) {
                    return object;
                }
                CharBuffer charBuffer = CharBuffer.wrap((char[])char[].class.cast(object));
                ByteBuffer byteBuffer = Charset.forName(PASSWD_CHARSET).encode(charBuffer);
                if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0 && byteBuffer.position() == 0 && byteBuffer.limit() == byteBuffer.array().length) {
                    return byteBuffer.array();
                }
                byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
                byteBuffer.get(byArray);
                return byArray;
            }
            if (object instanceof byte[]) {
                if (clazz == byte[].class) {
                    return object;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])byte[].class.cast(object));
                CharBuffer charBuffer = Charset.forName(PASSWD_CHARSET).decode(byteBuffer);
                if (charBuffer.hasArray() && charBuffer.arrayOffset() == 0 && charBuffer.position() == 0 && charBuffer.limit() == charBuffer.array().length) {
                    return charBuffer.array();
                }
                char[] cArray = new char[charBuffer.length()];
                charBuffer.get(cArray);
                return cArray;
            }
            if (fAuthConstants.sDebug) {
                fConstants.logger.log(fSaslServerLoginContext.debugPrefix(0) + "Directory password has unexpected type=" + object.getClass().getName() + "/" + object + " - " + clazz.getName() + " for username=" + string);
            }
            throw new fAuthenticationException("Sasl-ServerLoginContext failed to resolve password type=" + object.getClass().getName() + " as " + clazz.getName() + " for username=" + string);
        }
    }

    private static class ServerMessage
    extends Message {
        public ServerMessage(fEventInputStream fEventInputStream2, fEventOutputStream fEventOutputStream2) {
            super(fEventInputStream2, fEventOutputStream2);
        }

        public String readMechanism() throws IOException {
            return this.is.readString();
        }

        public void sendChallenge(byte by, byte[] byArray) throws IOException {
            this.os.writeByte(by);
            this.write(byArray);
            this.os.flush();
        }
    }
}

