/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store;

import com.pcbsys.foundation.base.fChangeNotifiable;
import com.pcbsys.foundation.base.fException;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import com.pcbsys.foundation.persist.fBufferedEventManager;
import com.pcbsys.foundation.persist.fEventIterator;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.persist.fMaintenanceListener;
import com.pcbsys.foundation.persist.tasks.fStoreTaskManager;
import com.pcbsys.foundation.store.fEventIndexManager;
import com.pcbsys.foundation.store.fStore;
import com.pcbsys.foundation.store.fStoreAttributes;
import com.pcbsys.foundation.store.index.fEventExclusiveIndexManager;
import com.pcbsys.foundation.store.index.fFilteredExclusiveIndexManager;
import com.pcbsys.foundation.store.index.fPersistentExclusiveIndexManager;
import com.pcbsys.foundation.store.index.fStoreIndexStatus;
import com.pcbsys.foundation.store.index.fVolatileExclusiveIndexManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class fStoreImpl
implements fStore {
    private final fEventManager myEventStore;
    private final LinkedHashMap<String, fEventIndexManager> myIndexes;
    private final fStoreAttributes myAttributes;
    private fStoreTaskManager myEventManagement;

    @Override
    public void close() throws IOException {
        if (this.myEventManagement != null) {
            this.myEventManagement.close();
        }
        ArrayList<fEventIndexManager> arrayList = new ArrayList<fEventIndexManager>(this.myIndexes.values());
        for (fEventIndexManager fEventIndexManager2 : arrayList) {
            fEventIndexManager2.close();
        }
        this.myEventStore.close();
    }

    @Override
    public void destroy() throws IOException {
        if (this.myEventManagement != null) {
            this.myEventManagement.close();
        }
        ArrayList<fEventIndexManager> arrayList = new ArrayList<fEventIndexManager>(this.myIndexes.values());
        for (fEventIndexManager fEventIndexManager2 : arrayList) {
            fEventIndexManager2.destroy();
        }
        this.myEventStore.destroy(true);
    }

    @Override
    public fEventIndexManager createIndex(String string, long l, fFilter fFilter2, fStoreIndexStatus fStoreIndexStatus2, boolean bl, boolean bl2, StoreLogger storeLogger) throws IOException {
        fEventExclusiveIndexManager fEventExclusiveIndexManager2 = bl ? new fPersistentExclusiveIndexManager(this, string, l, fFilter2, 4096, fStoreIndexStatus2, bl2, storeLogger) : new fVolatileExclusiveIndexManager(this, string, l, fFilter2, 4096, fStoreIndexStatus2, bl2, storeLogger);
        this.add(fEventExclusiveIndexManager2);
        return fEventExclusiveIndexManager2;
    }

    @Override
    public fFilteredExclusiveIndexManager createFilteredIndex(String string, fFilter fFilter2, fEventIndexManager fEventIndexManager2, StoreLogger storeLogger) throws IOException {
        return new fFilteredExclusiveIndexManager(this, string, fFilter2, fEventIndexManager2, storeLogger);
    }

    @Override
    public boolean tasksRunning() {
        return this.myEventManagement != null;
    }

    @Override
    public void setupEventTasks(Object object, fChangeNotifiable fChangeNotifiable2, long l, boolean bl) {
        this.myEventManagement = new fStoreTaskManager(object, fChangeNotifiable2, this.myEventStore, this.myEventStore.getTTL(), this.myEventStore.getCapacity(), l, this.myAttributes.isHonorCapacity());
        this.myEventManagement.setAutoPurge(bl);
    }

    @Override
    public fStoreTaskManager getEventTasks() {
        return this.myEventManagement;
    }

    protected fStoreImpl(fEventManager fEventManager2, fStoreAttributes fStoreAttributes2) {
        this.myEventStore = fEventManager2;
        this.myIndexes = new LinkedHashMap();
        this.myAttributes = fStoreAttributes2;
    }

    @Override
    public fEventManager getEventStore() {
        return this.myEventStore;
    }

    @Override
    public void add(fEventIndexManager fEventIndexManager2) {
        this.myIndexes.put(fEventIndexManager2.getName(), fEventIndexManager2);
    }

    @Override
    public void remove(fEventIndexManager fEventIndexManager2) {
        this.myIndexes.remove(fEventIndexManager2.getName());
    }

    @Override
    public fBaseEvent getEvent(long l) {
        return this.myEventStore.getEvent(l);
    }

    @Override
    public int getEvents(long l, fBaseEvent[] fBaseEventArray) {
        return this.myEventStore.getEvents(l, fBaseEventArray);
    }

    @Override
    public fBaseEvent[] getEvents(fFilter fFilter2) {
        return this.myEventStore.getEvents(fFilter2);
    }

    @Override
    public long getFirstEventKey() {
        return this.myEventStore.getFirstStoredKey();
    }

    @Override
    public void setLastEventKey(long l) throws IOException {
        this.myEventStore.setLastEID(l);
    }

    @Override
    public boolean containsEvent(long l) {
        return this.myEventStore.containsEvent(l);
    }

    @Override
    public long getLastEventKey() {
        return this.myEventStore.getLastKey();
    }

    @Override
    public long getLastEventAvailableKey() {
        return this.myEventStore.getLastStoredKey();
    }

    @Override
    public long allocateEventKey() {
        return this.myEventStore.getNextKey();
    }

    @Override
    public long getNumberOfEvents() {
        return this.myEventStore.getNoEvents();
    }

    @Override
    public float getPercentageFree() {
        return this.myEventStore.getPercentFree();
    }

    @Override
    public int removeEvent(long l) {
        return this.myEventStore.purgeEvents(l);
    }

    @Override
    public int removeEvents(long l, long l2) {
        return this.myEventStore.purgeEvents(l, l2);
    }

    @Override
    public int removeEvents(long l, long l2, fFilter fFilter2) {
        return this.myEventStore.purgeEvents(l, l2, fFilter2);
    }

    @Override
    public void addEvent(fBaseEvent fBaseEvent2) {
        this.myEventStore.putEvent(fBaseEvent2);
    }

    @Override
    public void replaceEvent(fBaseEvent fBaseEvent2) {
        this.myEventStore.atomicSwapEvent(fBaseEvent2, fBaseEvent2.getKey());
    }

    @Override
    public void performMaintenance(fMaintenanceListener fMaintenanceListener2) {
        this.myEventStore.performMaintenance(fMaintenanceListener2);
    }

    @Override
    public void renameStore(String string) {
        this.myEventStore.performMaintenance(string);
    }

    @Override
    public boolean isCorrupt() {
        return this.myEventStore instanceof fBufferedEventManager && ((fBufferedEventManager)this.myEventStore).isCorrupted();
    }

    @Override
    public void setSync(boolean bl) {
        this.myEventStore.getSyncManager().setSyncFlag(bl);
    }

    @Override
    public void setSyncBatchSize(int n) {
        this.myEventStore.getSyncManager().setSyncBatchSize(n);
    }

    @Override
    public void setSyncBatchTime(int n) {
        this.myEventStore.getSyncManager().setSyncBatchTime(n);
    }

    @Override
    public void forceEventKeyPersist() throws IOException {
        this.myEventStore.updateEventId();
    }

    @Override
    public void removeAll() {
        this.myEventStore.purgeAll();
    }

    public void setAutoPurge(boolean bl) {
        if (fConstants.logger.isInfoEnabled()) {
            fConstants.logger.info("Setting enable auto purge to " + bl + " for store: " + this.myAttributes.getFileName());
        }
        this.myEventStore.setAutoPurge(bl);
    }

    @Override
    public fEventIterator getEventIterator() {
        return new fEventIterator(this.myEventStore);
    }

    @Override
    public long usedSpace() {
        return this.myEventStore.usedSpace();
    }

    @Override
    public long getEventTimeStored(long l) throws fException {
        return this.myEventStore.getEventTimeStored(l);
    }

    @Override
    public float getCacheHitRatio() {
        return this.myEventStore.getCacheHitRatio();
    }

    @Override
    public long getUsedMemory() {
        return 0L;
    }
}

