/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store.index;

import com.pcbsys.foundation.Analyzable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.bitset.fVolatileLongOrderedQueue;
import com.pcbsys.foundation.store.index.RollbackData;
import com.pcbsys.foundation.store.index.fStoreIndexConnectionStatus;
import java.util.Collection;
import java.util.Collections;

public final class ConsumerDetails
implements Analyzable {
    private final fLongOrderedQueue<RollbackData> myQueue;
    private final fStoreIndexConnectionStatus myStatus;
    private final int myWindowSize;
    private final boolean isAutoAck;
    private final boolean isMasterRealmConsumer;
    final long unackedRangeWarningThreshold = 10000L;
    final long lastReadAckWarningThreshold = 300000L;

    public ConsumerDetails(fStoreIndexConnectionStatus fStoreIndexConnectionStatus2, fVolatileLongOrderedQueue<RollbackData> fVolatileLongOrderedQueue2, int n, boolean bl) {
        this.myQueue = fVolatileLongOrderedQueue2;
        this.myStatus = fStoreIndexConnectionStatus2;
        this.myWindowSize = n;
        this.isAutoAck = bl;
        this.isMasterRealmConsumer = false;
    }

    public ConsumerDetails(fStoreIndexConnectionStatus fStoreIndexConnectionStatus2, fVolatileLongOrderedQueue<RollbackData> fVolatileLongOrderedQueue2, int n, boolean bl, boolean bl2) {
        this.myQueue = fVolatileLongOrderedQueue2;
        this.myStatus = fStoreIndexConnectionStatus2;
        this.myWindowSize = n;
        this.isAutoAck = bl;
        this.isMasterRealmConsumer = bl2;
    }

    private void setLastRead() {
        this.myStatus.setLastRead(fTimer.currentTimeMillis());
    }

    public boolean rollback(long l) {
        if (this.myQueue.clear(l)) {
            this.myStatus.incrementEventsRolled();
            this.myStatus.setLastAck(fTimer.currentTimeMillis());
            return true;
        }
        return false;
    }

    public boolean ack(long l) {
        if (this.myQueue.clear(l)) {
            this.myStatus.incrementEventsAcked();
            this.myStatus.setLastAck(fTimer.currentTimeMillis());
            return true;
        }
        return false;
    }

    public int getWindowSize() {
        return this.myWindowSize;
    }

    public boolean allocate(Long l) {
        this.setLastRead();
        return this.myQueue.offer(l);
    }

    public int getPendingEventsSize() {
        return this.myQueue.size();
    }

    public Collection<Long> pendingEvents() {
        return Collections.unmodifiableCollection(this.myQueue);
    }

    public void clearPendingEvents() {
        this.myQueue.clear();
    }

    public boolean isAutoAck() {
        return this.isAutoAck;
    }

    public boolean isMasterRealmConsumer() {
        return this.isMasterRealmConsumer;
    }

    public fLongOrderedQueue<RollbackData> getQueue() {
        return this.myQueue;
    }

    public fStoreIndexConnectionStatus getStatus() {
        return this.myStatus;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Status:").append(this.myStatus.toString()).append("WindowSize:").append(this.myWindowSize).append("\n");
        stringBuilder.append(this.myQueue.toString());
        return stringBuilder.toString();
    }

    @Override
    public String analyze() {
        if (this.myQueue == null || this.myQueue.size() <= 0) {
            return null;
        }
        long l = fTimer.currentTimeMillis() - this.myStatus.getLastRead();
        if (l > 300000L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The consumer didn't read for ").append(300L).append(" sec.").append(" Last Read before: ").append(l / 1000L).append(" sec.").append(", Unacked events:").append(this.myQueue.size()).append(", Window: " + this.myWindowSize).append(", Sync: " + !this.myStatus.isAsync());
            return stringBuilder.toString();
        }
        l = fTimer.currentTimeMillis() - this.myStatus.getLastAck();
        if (l > 300000L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The consumer didn't ack for ").append(300L).append(" sec.").append("Last Ack before: ").append(l / 1000L).append(" sec.").append(", Unacked events:").append(this.myQueue.size()).append(", Window: " + this.myWindowSize).append(", Sync: " + !this.myStatus.isAsync());
            return stringBuilder.toString();
        }
        long l2 = this.myQueue.peek();
        long l3 = this.myQueue.last();
        if (l3 - l2 > 10000L) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The gap between first and last pending events is above the threshold ").append(10000L).append(". First unacked EID: ").append(l2).append(", last unacked EID: ").append(l3).append(", Unacked events:").append(this.myQueue.size()).append(", Window: " + this.myWindowSize).append(", Sync: " + !this.myStatus.isAsync());
            return stringBuilder.toString();
        }
        return null;
    }
}

