/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store.index;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.io.fBaseEvent;
import com.pcbsys.foundation.logger.fLogLevel;
import com.pcbsys.foundation.logger.storelogger.EventTraceLoggerContext;
import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueDeserialize;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueSerialize;
import com.pcbsys.foundation.persist.bitset.fVolatileLongOrderedQueue;
import com.pcbsys.foundation.persist.fEventIterator;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.store.fEventIndexManager;
import com.pcbsys.foundation.store.fStore;
import com.pcbsys.foundation.store.index.ClearConsumerOperation;
import com.pcbsys.foundation.store.index.ClearConsumerResult;
import com.pcbsys.foundation.store.index.ConsumerDetails;
import com.pcbsys.foundation.store.index.IndexChangeMonitor;
import com.pcbsys.foundation.store.index.IndexType;
import com.pcbsys.foundation.store.index.RollbackData;
import com.pcbsys.foundation.store.index.fStoreIndexConnectionStatus;
import com.pcbsys.foundation.store.index.fStoreIndexStatus;
import com.pcbsys.foundation.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class fEventExclusiveIndexManager
extends fEventIndexManager {
    private static final String CLASS_NAME = fEventExclusiveIndexManager.class.getSimpleName();
    private static final String LOG_PREFIX = "StoreIndex> ";
    private final String myName;
    private final IndexChangeMonitor myMonitor;
    protected final LinkedHashMap<String, ConsumerDetails> myTransientLists;
    private final fStoreIndexStatus myStatus;
    protected final fLongOrderedQueue<RollbackData> myPendingQueue;
    protected final fLongOrderedQueue<RollbackData> myOutstandingQueue;
    final int myBitSetSize;
    private final long startEID;
    private final StoreLogger storeTraceLogger;
    protected final fLongOrderedQueue purgeReadyList;
    private boolean maintainPurgeReadyList;

    fEventExclusiveIndexManager(fStore fStore2, String string, long l, fFilter fFilter2, int n, fStoreIndexStatus fStoreIndexStatus2, boolean bl, StoreLogger storeLogger) {
        super(fStore2);
        this.myName = string;
        this.storeTraceLogger = storeLogger;
        this.myTransientLists = new LinkedHashMap();
        this.myBitSetSize = n;
        this.myStatus = fStoreIndexStatus2;
        this.startEID = l;
        this.myOutstandingQueue = this.openOrCreate(string + ".idx", fStore2.getEventStore(), l, fFilter2);
        this.myPendingQueue = this.openOrCreate(string + ".txn", null, -1L, null);
        this.myMonitor = new IndexChangeMonitor(this, fStore2.getEventStore(), fFilter2);
        this.purgeReadyList = new fVolatileLongOrderedQueue(this.myBitSetSize);
        this.maintainPurgeReadyList = bl;
        this.startUpReset();
    }

    @Override
    public void close() {
        super.close();
        this.myMonitor.close();
        try {
            this.myOutstandingQueue.close();
            this.myPendingQueue.close();
            this.purgeReadyList.clear();
        }
        catch (IOException iOException) {
            fBaseApplication.getApplication().fileOperationFailure(this.myName + " failed during close " + iOException.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.close();
        this.myOutstandingQueue.delete();
        this.myPendingQueue.delete();
    }

    @Override
    public long getLastAck() {
        long l = Long.MAX_VALUE;
        if (this.myOutstandingQueue.size() != 0) {
            l = this.myOutstandingQueue.peek() - 1L;
        }
        if (this.myPendingQueue.size() != 0) {
            l = Math.min(l, this.myPendingQueue.peek() - 1L);
        }
        return l;
    }

    @Override
    public long getEventDepth() {
        return this.myOutstandingQueue.size();
    }

    @Override
    public long getUnAcknowledgeDepth() {
        return this.myPendingQueue.size();
    }

    @Override
    public long getUnAcknowledgeDepth(String string) {
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails != null) {
            return consumerDetails.getPendingEventsSize();
        }
        return 0L;
    }

    @Override
    public String analyze() {
        StringBuilder stringBuilder = null;
        for (Map.Entry<String, ConsumerDetails> entry : this.myTransientLists.entrySet()) {
            String string = entry.getValue().analyze();
            if (string == null) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            String string2 = entry.getKey();
            if (!entry.getValue().getStatus().isAsync()) {
                string2 = Long.toHexString(StringUtils.toLong(string2));
            }
            stringBuilder.append("Consumer ID:").append(string2).append(", Num of consumers:").append(this.myTransientLists.size()).append(". " + string).append("\n");
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    @Override
    public long get(String string, long l) {
        long l2 = -1L;
        if (this.myOutstandingQueue.contains(l)) {
            RollbackData rollbackData = this.myOutstandingQueue.getMetaData(l);
            if (rollbackData == null) {
                rollbackData = new RollbackData();
            }
            l2 = rollbackData.getRedeliveryCount();
            this.myPendingQueue.offer(l);
            this.myOutstandingQueue.clear(l);
            ConsumerDetails consumerDetails = this.myTransientLists.get(string);
            if (consumerDetails == null) {
                consumerDetails = new ConsumerDetails(this.myStatus.addConnection(string, true, -1), new fVolatileLongOrderedQueue<RollbackData>(this.myBitSetSize), Integer.MAX_VALUE, false);
                this.myTransientLists.put(string, consumerDetails);
                if (fConstants.logger.isInfoEnabled()) {
                    fConstants.logger.info(LOG_PREFIX + this.myName + " Registered consumer " + string + ", async: true, windowSize: " + consumerDetails.getWindowSize() + ", autoAck: " + consumerDetails.isAutoAck() + ", total consumers: " + this.myTransientLists.size());
                }
            }
            consumerDetails.allocate(l);
            this.myStatus.setLastRead(fTimer.currentTimeMillis());
        }
        return l2;
    }

    @Override
    public fFilter getFilter() {
        return this.myMonitor.getFilter();
    }

    @Override
    public void setFilter(fFilter fFilter2) {
        this.myMonitor.setFilter(fFilter2);
        if (fFilter2 != null) {
            Iterator<Long> iterator = this.myOutstandingQueue.iterator();
            fEventManager fEventManager2 = this.myStore.getEventStore();
            while (iterator.hasNext()) {
                long l = iterator.next();
                fBaseEvent fBaseEvent2 = fEventManager2.getEvent(l);
                if (fBaseEvent2 != null && fFilter2.isMatch(fBaseEvent2)) continue;
                iterator.remove();
                if (!this.maintainPurgeReadyList) continue;
                this.purgeReadyList.add(l);
            }
            this.myOutstandingQueue.calcSize();
        }
    }

    @Override
    public long getNextAfter(long l) {
        return this.myOutstandingQueue.nextFrom(l);
    }

    @Override
    public long getNextAvailable() {
        long l = -1L;
        if (!this.myOutstandingQueue.isEmpty()) {
            l = this.myOutstandingQueue.peek();
        }
        return l;
    }

    @Override
    public long getRedeliveryCount(long l) {
        RollbackData rollbackData = this.myPendingQueue.getMetaData(l);
        if (rollbackData != null) {
            return rollbackData.getRedeliveryCount();
        }
        return 0L;
    }

    @Override
    public long getLength() {
        return this.myOutstandingQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myOutstandingQueue.isEmpty();
    }

    @Override
    public boolean hasOutstandingEvent(long l) {
        return this.myOutstandingQueue.contains(l);
    }

    @Override
    public long getFirstKey() {
        return this.myOutstandingQueue.peek();
    }

    @Override
    public long getLastKey() {
        return this.myOutstandingQueue.last();
    }

    @Override
    public void clearAll() {
        this.myOutstandingQueue.clear();
        this.myPendingQueue.clear();
        this.purgeReadyList.clear();
        this.myStatus.setLastWrite(fTimer.currentTimeMillis());
    }

    @Override
    public void clear(long l, long l2) {
        this.myOutstandingQueue.clear(l);
        this.myPendingQueue.clear(l);
        long l3 = this.myOutstandingQueue.nextFrom(l);
        while (l3 != -1L && l3 <= l2) {
            this.myOutstandingQueue.clear(l3);
            this.myPendingQueue.clear(l3);
            if (this.maintainPurgeReadyList) {
                this.purgeReadyList.add(l3);
            }
            l3 = this.myOutstandingQueue.nextFrom(l3);
        }
        this.myStatus.setLastWrite(fTimer.currentTimeMillis());
    }

    @Override
    public boolean remove(long l) {
        if (this.maintainPurgeReadyList) {
            this.purgeReadyList.clear(l);
        }
        return this.myOutstandingQueue.clear(l);
    }

    @Override
    public void register(String string, boolean bl, int n, boolean bl2) {
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fVolatileLongOrderedQueue<RollbackData> fVolatileLongOrderedQueue2 = new fVolatileLongOrderedQueue<RollbackData>(this.myBitSetSize);
            consumerDetails = new ConsumerDetails(this.myStatus.addConnection(string, bl, n), fVolatileLongOrderedQueue2, n, bl2);
            this.myTransientLists.put(string, consumerDetails);
            if (fConstants.logger.isInfoEnabled()) {
                fConstants.logger.info(LOG_PREFIX + this.myName + " Registered consumer " + string + ", async: " + bl + ", windowSize: " + consumerDetails.getWindowSize() + ", autoAck: " + consumerDetails.isAutoAck() + ", total consumers: " + this.myTransientLists.size());
            }
        }
    }

    @Override
    public void eventAdded(long l, boolean bl) {
        if (l > this.startEID) {
            if (bl) {
                if (this.storeTraceLogger.isTraceEnabled()) {
                    this.storeTraceLogger.trace("StoreIndex> Adding event on " + this.myName + ". " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
                }
                this.myOutstandingQueue.add(l);
                this.myStatus.setLastWrite(fTimer.currentTimeMillis());
            } else if (this.maintainPurgeReadyList) {
                this.purgeReadyList.add(l);
            }
        }
    }

    @Override
    public void eventDeleted(long l) {
        if (this.storeTraceLogger.isTraceEnabled()) {
            this.storeTraceLogger.trace("StoreIndex> Deleting event from " + this.myName + ". " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
        }
        if (this.maintainPurgeReadyList) {
            this.purgeReadyList.clear(l);
        }
        this.myOutstandingQueue.clear(l);
        this.myPendingQueue.clear(l);
        this.myStatus.setLastWrite(fTimer.currentTimeMillis());
    }

    @Override
    public int getFreeEventSize(String string) {
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            return -1;
        }
        return consumerDetails.getWindowSize() - consumerDetails.getPendingEventsSize();
    }

    @Override
    public ClearConsumerResult clearConsumer(String string, boolean bl) {
        ClearConsumerResult clearConsumerResult = null;
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails != null) {
            long[] lArray = new long[consumerDetails.getPendingEventsSize()];
            int n = 0;
            for (Long l : consumerDetails.pendingEvents()) {
                lArray[n] = l;
                ++n;
            }
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Clearing consumer and " + (bl ? "rolling " : "acking") + " events. consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
            if (bl) {
                clearConsumerResult = new ClearConsumerResult(string, lArray, ClearConsumerOperation.ROLLBACK);
                for (Object object : (Object)lArray) {
                    consumerDetails.rollback((long)object);
                    this.rollbackEvent((long)object);
                }
            } else {
                clearConsumerResult = new ClearConsumerResult(string, lArray, ClearConsumerOperation.ACK);
                for (Object object : (Object)lArray) {
                    consumerDetails.ack((long)object);
                    this.acknowledgeEvent((long)object);
                }
            }
            this.myTransientLists.remove(string);
            if (fConstants.logger.isInfoEnabled()) {
                fConstants.logger.info(LOG_PREFIX + this.myName + " Cleared consumer " + string + ", total consumers: " + this.myTransientLists.size());
            }
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("StoreIndex> Destroying Volatile TX Queue. uniqueID=" + string + ", currentSize=" + this.myTransientLists.size(), CLASS_NAME);
            }
        }
        this.myStatus.removeConnection(string);
        if (clearConsumerResult == null) {
            return new ClearConsumerResult(string, new long[0], ClearConsumerOperation.ROLLBACK);
        }
        return clearConsumerResult;
    }

    @Override
    public ClearConsumerResult clearMasterRealmConsumer() {
        String string = null;
        for (String string2 : this.myTransientLists.keySet()) {
            ConsumerDetails consumerDetails = this.myTransientLists.get(string2);
            if (!consumerDetails.isMasterRealmConsumer()) continue;
            string = string2;
            break;
        }
        if (string != null) {
            return this.clearConsumer(string, true);
        }
        return null;
    }

    @Override
    public ClearConsumerResult clearConsumer(String string) {
        ConsumerDetails consumerDetails = this.getConsumerDetails(string);
        boolean bl = true;
        if (consumerDetails != null) {
            bl = !consumerDetails.isAutoAck();
        }
        return this.clearConsumer(string, bl);
    }

    @Override
    public int rollbackEvent(String string, long l) {
        int n = 0;
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Rolling back an event we have no record of, consumer " + string + ", eid = " + l);
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to rollback event, consumer not found. , consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
            }
        } else if (l >= 0L && consumerDetails.rollback(l)) {
            this.rollbackEvent(l);
            this.traceRollback(l, string);
            ++n;
        }
        return n;
    }

    @Override
    public String getConsumerIdByEID(long l, List<String> list) {
        for (String string : list) {
            ConsumerDetails consumerDetails = this.myTransientLists.get(string);
            if (consumerDetails == null || !consumerDetails.getQueue().contains(l)) continue;
            return string;
        }
        return null;
    }

    @Override
    public int rollbackEvents(String string, long[] lArray) {
        int n = 0;
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Rolling back event(s) we have no record of, consumer " + string + ", eids = " + Arrays.toString(lArray));
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to rollback events, consumer not found. , consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
        } else {
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Rolling back events for consumer. consumerId=" + string + ", toRollCount=" + lArray.length + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
            for (long l : lArray) {
                if (l < 0L || !consumerDetails.rollback(l)) continue;
                this.rollbackEvent(l);
                ++n;
            }
        }
        if (this.storeTraceLogger.isTraceEnabled()) {
            this.storeTraceLogger.trace("Rolled back events. consumerId=" + string + ", rolledCount=" + n, CLASS_NAME);
        }
        return n;
    }

    @Override
    public void rollbackAllEvents() {
        long l = this.myPendingQueue.size();
        while (this.myPendingQueue.size() != 0) {
            long l2 = this.myPendingQueue.peek();
            RollbackData rollbackData = this.myPendingQueue.getMetaData(l2);
            long l3 = this.myPendingQueue.poll();
            if (l2 != l3) {
                fConstants.logger.info(LOG_PREFIX + this.myName + " Peeked and polled eids do not match while rolling back all events");
            }
            this.myOutstandingQueue.add(l2);
            if (rollbackData == null) continue;
            rollbackData.incrementRedeliveryCount();
            this.myOutstandingQueue.putMetaData(l2, rollbackData);
        }
        this.myTransientLists.clear();
        int n = this.myOutstandingQueue.size();
        this.myStatus.clearConnections();
        this.myStatus.setStoreSize(n);
        this.myStatus.setLastRead(fTimer.currentTimeMillis());
        if (fConstants.logger.isInfoEnabled()) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Reset for all outstanding events, Rolled back " + l + " events, now have " + n + " events pending delivery");
        }
    }

    @Override
    public int acknowledgeEvent(String string, long l) {
        int n = 0;
        this.myStatus.setLastRead(fTimer.currentTimeMillis());
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Acknowledging an event we have no record of, consumer " + string + ", eid = " + l);
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to acknowledge event, consumer not found. , consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
            }
        } else if (l >= 0L && consumerDetails.ack(l)) {
            this.myPendingQueue.clear(l);
            if (this.maintainPurgeReadyList) {
                this.purgeReadyList.add(l);
            }
            this.traceAck(l, string);
            ++n;
        }
        return n;
    }

    @Override
    public int acknowledgeEvents(String string, long[] lArray) {
        int n = 0;
        this.myStatus.setLastRead(fTimer.currentTimeMillis());
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Acknowledging event(s) we have no record of, consumer " + string + ", eids = " + Arrays.toString(lArray));
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to acknowledge events, consumer not found.  consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
        } else {
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Acknowledging events for consumer. consumerId=" + string + ", toAckCount=" + lArray.length + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
            for (long l : lArray) {
                if (l < 0L || !consumerDetails.ack(l)) continue;
                this.myPendingQueue.clear(l);
                if (this.maintainPurgeReadyList) {
                    this.purgeReadyList.add(l);
                }
                ++n;
            }
        }
        if (this.storeTraceLogger.isTraceEnabled()) {
            this.storeTraceLogger.trace("Acknowledged events. consumerId=" + string + ", ackCount=" + n, CLASS_NAME);
        }
        return n;
    }

    @Override
    public int rollbackEventsStartingFrom(String string, long l) {
        int n = 0;
        this.myStatus.setLastRead(fTimer.currentTimeMillis());
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Rolling back event(s) we have no record of, consumer " + string + ", eid >= " + l);
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to rollback events, consumer not found.  consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
            }
        } else {
            fLongOrderedQueue<RollbackData> fLongOrderedQueue2 = consumerDetails.getQueue();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            this.getEidsStartingFrom(arrayList, fLongOrderedQueue2, l);
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Rollback events. startEID=" + l + ", consumerId=" + string + ", eventsToRoll=" + arrayList.size(), CLASS_NAME);
            }
            for (long l2 : arrayList) {
                if (l2 < 0L || !consumerDetails.rollback(l2)) continue;
                this.rollbackEvent(l2);
                ++n;
            }
        }
        return n;
    }

    @Override
    public int acknowledgeUpToEvent(String string, long l) {
        int n = 0;
        this.myStatus.setLastRead(fTimer.currentTimeMillis());
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Acknowledging event(s) we have no record of, consumer " + string + ", eid <= " + l);
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to acknowledge events up to and including given EID, consumer not found.  consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
            }
        } else {
            fLongOrderedQueue<RollbackData> fLongOrderedQueue2 = consumerDetails.getQueue();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            this.getEidsUpToEvent(arrayList, fLongOrderedQueue2, l);
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Acknowledging events. upToAndIncluding=" + l + ", consumerId=" + string + ", eventsToAck=" + arrayList.size(), CLASS_NAME);
            }
            for (long l2 : arrayList) {
                if (l2 < 0L || !consumerDetails.ack(l2)) continue;
                this.myPendingQueue.clear(l2);
                if (this.maintainPurgeReadyList) {
                    this.purgeReadyList.add(l2);
                }
                ++n;
            }
        }
        return n;
    }

    @Override
    public boolean atMaxPending(String string) {
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            return false;
        }
        return consumerDetails.getPendingEventsSize() >= consumerDetails.getWindowSize();
    }

    @Override
    public long allocateEvent(String string, long l, boolean bl) {
        if (!this.myOutstandingQueue.contains(l)) {
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Can't find event to allocate. " + EventTraceLoggerContext.eidFormat(l) + ", consumerId=" + string, CLASS_NAME);
            }
            return -1L;
        }
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails == null) {
            fConstants.logger.warn("Unable to allocate event : " + string + " EID:" + l);
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Can't find consumer. consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
            }
            return -1L;
        }
        if (consumerDetails.getPendingEventsSize() >= consumerDetails.getWindowSize()) {
            if (fConstants.logger.isWarningEnabled()) {
                fConstants.logger.warn("Exceeded window for : " + string + " EID:" + l + " Window:" + consumerDetails.getWindowSize() + " Current:" + consumerDetails.getPendingEventsSize());
            }
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Exceeded window for consumer. " + EventTraceLoggerContext.eidFormat(l) + ", consumerId=" + string + ", queueSize=" + consumerDetails.getQueue().size() + ", window=" + consumerDetails.getWindowSize(), CLASS_NAME);
            }
            return -1L;
        }
        long l2 = 0L;
        RollbackData rollbackData = null;
        if (bl && (rollbackData = this.myOutstandingQueue.getMetaData(l)) != null) {
            l2 = rollbackData.getRedeliveryCount();
        }
        this.myPendingQueue.add(l);
        consumerDetails.allocate(l);
        if (rollbackData != null) {
            this.myPendingQueue.putMetaData(l, rollbackData);
        }
        this.myOutstandingQueue.clear(l);
        if (this.storeTraceLogger.isTraceEnabled()) {
            this.storeTraceLogger.trace("Allocated event. consumerId=" + string + ", redeliveryCount=" + l2 + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
        }
        return l2;
    }

    @Override
    public fStoreIndexStatus getStatus() {
        Iterator<fStoreIndexConnectionStatus> iterator = this.myStatus.getConnectionIterator();
        while (iterator.hasNext()) {
            fStoreIndexConnectionStatus fStoreIndexConnectionStatus2 = iterator.next();
            ConsumerDetails consumerDetails = this.myTransientLists.get(fStoreIndexConnectionStatus2.getUniqueID());
            if (consumerDetails == null) continue;
            ConsumerDetails consumerDetails2 = this.myTransientLists.get(fStoreIndexConnectionStatus2.getUniqueID());
            fStoreIndexConnectionStatus2.setTransactionDepth(consumerDetails2.getPendingEventsSize());
        }
        return this.myStatus;
    }

    @Override
    public Collection<Long> getPendingIndex(String string) {
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails != null) {
            return consumerDetails.pendingEvents();
        }
        return null;
    }

    @Override
    public ConsumerDetails getConsumerDetails(String string) {
        return this.myTransientLists.get(string);
    }

    @Override
    public void acknowledgeEvent(long l) {
        this.myPendingQueue.clear(l);
        if (this.maintainPurgeReadyList) {
            this.purgeReadyList.add(l);
        }
    }

    @Override
    public void rollbackEvent(long l) {
        if (this.myPendingQueue.contains(l)) {
            this.myOutstandingQueue.add(l);
            RollbackData rollbackData = this.myPendingQueue.getMetaData(l);
            if (rollbackData == null) {
                rollbackData = new RollbackData();
            }
            rollbackData.incrementRedeliveryCount();
            this.myOutstandingQueue.putMetaData(l, rollbackData);
            this.myPendingQueue.clear(l);
            this.myStatus.setLastRead(fTimer.currentTimeMillis());
        } else {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Rollback for an event we have no record of, this typically means the event has been purged or removed from the Shared Durable, unable to rollback");
            if (this.storeTraceLogger.isWarnEnabled()) {
                this.storeTraceLogger.warn("Failed to rollback event, the event is not marked as pending acknowledgement/rollback. " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
            }
        }
    }

    @Override
    public void clusterRecoveryWrite(fLongOrderedQueueSerialize fLongOrderedQueueSerialize2) throws Exception {
        fLongOrderedQueueSerialize2.setIndexType(IndexType.outstanding);
        this.myOutstandingQueue.writeExternal(fLongOrderedQueueSerialize2);
        fLongOrderedQueueSerialize2.setIndexType(IndexType.transactional);
        this.myPendingQueue.writeExternal(fLongOrderedQueueSerialize2);
    }

    @Override
    public void clusterRecoveryRead(fLongOrderedQueueDeserialize fLongOrderedQueueDeserialize2) throws Exception {
        if (fLongOrderedQueueDeserialize2.isFirstEvent()) {
            this.myOutstandingQueue.clear();
            this.myPendingQueue.clear();
            this.myTransientLists.clear();
        }
        if (fLongOrderedQueueDeserialize2.getIndexType() == IndexType.outstanding) {
            this.myOutstandingQueue.readExternal(fLongOrderedQueueDeserialize2);
        } else {
            this.myPendingQueue.readExternal(fLongOrderedQueueDeserialize2);
        }
    }

    @Override
    public void rebuildVolatileList(String string) {
        fVolatileLongOrderedQueue<RollbackData> fVolatileLongOrderedQueue2 = new fVolatileLongOrderedQueue<RollbackData>(this.myBitSetSize);
        ConsumerDetails consumerDetails = new ConsumerDetails(this.myStatus.addConnection(string, true, -1), fVolatileLongOrderedQueue2, -1, false, true);
        for (Long l : this.myPendingQueue) {
            fVolatileLongOrderedQueue2.offer(l);
        }
        this.myTransientLists.put(string, consumerDetails);
        if (fConstants.logger.isInfoEnabled()) {
            fConstants.logger.info(LOG_PREFIX + this.myName + " Registered master realm consumer " + string + ", async: true, windowSize: " + consumerDetails.getWindowSize() + ", autoAck: " + consumerDetails.isAutoAck());
        }
        this.rebuildPurgeReadyList();
        if (this.storeTraceLogger.isTraceEnabled()) {
            this.storeTraceLogger.trace("Volatile index rebuilt. Consumer details list size=" + this.myTransientLists.size(), CLASS_NAME);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Outstanding:").append(this.myOutstandingQueue.toString()).append("\n");
        stringBuffer.append("Transaction:").append(this.myPendingQueue.toString());
        for (ConsumerDetails consumerDetails : this.myTransientLists.values()) {
            stringBuffer.append("\t").append(consumerDetails.toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    protected abstract fLongOrderedQueue<RollbackData> openOrCreate(String var1, fEventManager var2, long var3, fFilter var5);

    protected abstract void startUpReset();

    @Override
    public int rollback(String string) {
        long[] lArray = null;
        int n = 0;
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails != null) {
            lArray = new long[consumerDetails.getPendingEventsSize()];
            for (Long l : consumerDetails.pendingEvents()) {
                lArray[n] = l;
                ++n;
            }
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Rolling back all events for the consumer. consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
            for (Object object : (Object)lArray) {
                consumerDetails.rollback((long)object);
                this.rollbackEvent((long)object);
            }
            consumerDetails.clearPendingEvents();
        } else if (this.storeTraceLogger.isWarnEnabled()) {
            this.storeTraceLogger.warn("StoreIndex> Failed to roll all events for consumer, because the consumer doesn't exist. consumerId=" + string, CLASS_NAME);
        }
        return n;
    }

    @Override
    public int acknowledge(String string) {
        int n = 0;
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails != null) {
            fLongOrderedQueue<RollbackData> fLongOrderedQueue2 = consumerDetails.getQueue();
            long[] lArray = new long[consumerDetails.getQueue().size()];
            for (Long l : consumerDetails.getQueue()) {
                lArray[n] = l;
                ++n;
            }
            if (this.storeTraceLogger.isTraceEnabled()) {
                this.storeTraceLogger.trace("Acknowledging all events for the consumer. consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(lArray), CLASS_NAME);
            }
            for (Object object : (Object)lArray) {
                consumerDetails.ack((long)object);
                this.acknowledgeEvent((long)object);
            }
            fLongOrderedQueue2.clear();
        } else if (this.storeTraceLogger.isWarnEnabled()) {
            this.storeTraceLogger.warn("Failed to acknowledge all events for consumer,because consumer is not found.  consumerId=" + string, CLASS_NAME);
        }
        return n;
    }

    @Override
    public void pause() {
        this.myMonitor.pause();
    }

    @Override
    public void resume() {
        this.myMonitor.resume();
    }

    @Override
    public long[] getPendingEidSequence(String string, long l, boolean bl) {
        ConsumerDetails consumerDetails = this.myTransientLists.get(string);
        if (consumerDetails != null) {
            fLongOrderedQueue<RollbackData> fLongOrderedQueue2 = consumerDetails.getQueue();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            if (bl) {
                this.getEidsUpToEvent(arrayList, fLongOrderedQueue2, l);
            } else {
                this.getEidsStartingFrom(arrayList, fLongOrderedQueue2, l);
            }
            long[] lArray = new long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                lArray[i] = arrayList.get(i);
            }
            return lArray;
        }
        fConstants.logger.info(LOG_PREFIX + this.myName + " could not find ConsumerDetails with id: " + string + " to retrieve event eids.");
        return new long[0];
    }

    private void getEidsUpToEvent(List<Long> list, fLongOrderedQueue fLongOrderedQueue2, long l) {
        long l2;
        Iterator<Long> iterator = fLongOrderedQueue2.iterator();
        while (iterator.hasNext() && (l2 = iterator.next().longValue()) <= l) {
            list.add(l2);
        }
    }

    private void getEidsStartingFrom(List<Long> list, fLongOrderedQueue fLongOrderedQueue2, long l) {
        long l2;
        Iterator<Long> iterator = fLongOrderedQueue2.iterator();
        while (iterator.hasNext() && (l2 = iterator.next().longValue()) >= l) {
            list.add(l2);
        }
    }

    private void traceAck(long l, String string) {
        if (this.storeTraceLogger.isInfoEnabled()) {
            this.storeTraceLogger.info("Acknowledged event for consumer. consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
        }
    }

    private void traceRollback(long l, String string) {
        if (this.storeTraceLogger.isInfoEnabled()) {
            this.storeTraceLogger.info("Rolled back event for consumer. consumerId=" + string + ", " + EventTraceLoggerContext.eidFormat(l), CLASS_NAME);
        }
    }

    protected void rebuildPurgeReadyList() {
        this.purgeReadyList.clear();
        if (!this.maintainPurgeReadyList) {
            return;
        }
        long l = fTimer.currentTimeMillis();
        fEventIterator fEventIterator2 = this.myStore.getEventIterator();
        for (int i = 0; i < fEventIterator2.size(); ++i) {
            long l2 = fEventIterator2.keyAt(i);
            if (l2 <= this.startEID || this.myOutstandingQueue.contains(l2) || this.myPendingQueue.contains(l2)) continue;
            this.purgeReadyList.add(l2);
        }
        fEventIterator2.close();
        long l3 = fTimer.currentTimeMillis() - l;
        fLogLevel fLogLevel2 = fLogLevel.INFO;
        if (l3 > 1000L) {
            fLogLevel2 = fLogLevel.WARN;
        }
        if (fConstants.logger.canLog(fLogLevel2)) {
            fConstants.logger.report(fLogLevel2, "StoreIndex>Purge Ready List rebuilt for durable:" + this.myName + ". Size: " + this.purgeReadyList.size() + " First EID: " + this.purgeReadyList.peek() + ", Last EID:" + this.purgeReadyList.last() + ". Took: " + l3);
        }
    }

    @Override
    public Collection<Long> getPurgeReadyList() {
        return this.purgeReadyList;
    }
}

