/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store.index;

import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueDeserialize;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueueSerialize;
import com.pcbsys.foundation.persist.bitset.fVolatileLongOrderedQueue;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.store.fEventIndexManager;
import com.pcbsys.foundation.store.fStoreImpl;
import com.pcbsys.foundation.store.index.ClearConsumerResult;
import com.pcbsys.foundation.store.index.RollbackData;
import com.pcbsys.foundation.store.index.fEventExclusiveIndexManager;
import com.pcbsys.foundation.store.index.fStoreIndexStatus;
import java.util.Iterator;

public class fFilteredExclusiveIndexManager
extends fEventExclusiveIndexManager {
    private static long BATCH_SIZE = 100L;
    private fEventIndexManager myBaseIndex = null;
    private fEventManager myBaseManager;
    private fFilter myFilter;
    private long lastProcessedEID;
    private long processThresholdEID;

    public fFilteredExclusiveIndexManager(fStoreImpl fStoreImpl2, String string, fFilter fFilter2, fEventIndexManager fEventIndexManager2, StoreLogger storeLogger) {
        super(fStoreImpl2, string, -1L, fFilter2, 4096, new fStoreIndexStatus(), false, storeLogger);
        this.myBaseIndex = fEventIndexManager2;
    }

    @Override
    protected fLongOrderedQueue<RollbackData> openOrCreate(String string, fEventManager fEventManager2, long l, fFilter fFilter2) {
        fVolatileLongOrderedQueue<RollbackData> fVolatileLongOrderedQueue2 = new fVolatileLongOrderedQueue<RollbackData>(this.myBitSetSize);
        if (fEventManager2 != null) {
            this.myFilter = fFilter2;
            this.myBaseManager = fEventManager2;
            this.processThresholdEID = this.myBaseManager.getLastKey();
            this.lastProcessedEID = -1L;
            this.updateOutstandingEvents(fVolatileLongOrderedQueue2, l);
        }
        return fVolatileLongOrderedQueue2;
    }

    @Override
    public long getNextAfter(long l) {
        long l2 = l;
        do {
            l2 = this.myOutstandingQueue.nextFrom(l2);
            if (!(this.hasReachedThresholdOrLastStoredEvent() || l2 >= 0L && l2 <= this.processThresholdEID)) {
                int n = this.myOutstandingQueue.size();
                do {
                    this.updateOutstandingEvents(this.myOutstandingQueue, this.lastProcessedEID);
                } while (this.myOutstandingQueue.size() == n && !this.hasReachedThresholdOrLastStoredEvent());
                l2 = this.myOutstandingQueue.nextFrom(l);
            }
            if (!this.myBaseIndex.hasOutstandingEvent(l2)) continue;
            return l2;
        } while (l2 != -1L);
        return l2;
    }

    @Override
    protected void startUpReset() {
    }

    private boolean hasReachedThresholdOrLastStoredEvent() {
        return this.lastProcessedEID >= this.processThresholdEID || this.lastProcessedEID >= this.myBaseManager.getLastStoredKey();
    }

    private void updateOutstandingEvents(fLongOrderedQueue<RollbackData> fLongOrderedQueue2, long l) {
        long l2 = l + BATCH_SIZE;
        if (l2 > this.processThresholdEID) {
            l2 = this.processThresholdEID;
        }
        this.lastProcessedEID = this.myBaseManager.copy(fLongOrderedQueue2, this.myFilter, l, l2);
    }

    @Override
    public int acknowledge(String string) {
        int n = 0;
        fLongOrderedQueue<RollbackData> fLongOrderedQueue2 = this.myBaseIndex.getConsumerDetails(string).getQueue();
        Iterator<Long> iterator = fLongOrderedQueue2.iterator();
        while (iterator.hasNext()) {
            this.myOutstandingQueue.clear(iterator.next());
            ++n;
        }
        return n;
    }

    @Override
    public int acknowledgeEvent(String string, long l) {
        int n = 0;
        this.myOutstandingQueue.clear(l);
        return ++n;
    }

    @Override
    public int acknowledgeEvents(String string, long[] lArray) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.myOutstandingQueue.clear(lArray[i]);
            ++n;
        }
        return n;
    }

    @Override
    public int acknowledgeUpToEvent(String string, long l) {
        long l2;
        int n = 0;
        fLongOrderedQueue<RollbackData> fLongOrderedQueue2 = this.myBaseIndex.getConsumerDetails(string).getQueue();
        Iterator<Long> iterator = fLongOrderedQueue2.iterator();
        while (iterator.hasNext() && (l2 = iterator.next().longValue()) <= l) {
            this.myOutstandingQueue.clear(l2);
            ++n;
        }
        return n;
    }

    @Override
    public long get(String string, long l) {
        return -1L;
    }

    @Override
    public void register(String string, boolean bl, int n, boolean bl2) {
    }

    @Override
    public ClearConsumerResult clearConsumer(String string) {
        return null;
    }

    @Override
    public ClearConsumerResult clearConsumer(String string, boolean bl) {
        return null;
    }

    @Override
    public long[] getPendingEidSequence(String string, long l, boolean bl) {
        return null;
    }

    @Override
    public int rollback(String string) {
        return 0;
    }

    @Override
    public int rollbackEvent(String string, long l) {
        return 0;
    }

    @Override
    public void rollbackEvent(long l) {
    }

    @Override
    public void rollbackAllEvents() {
    }

    @Override
    public int rollbackEvents(String string, long[] lArray) {
        return 0;
    }

    @Override
    public int rollbackEventsStartingFrom(String string, long l) {
        return 0;
    }

    @Override
    public long getUnAcknowledgeDepth() {
        return 0L;
    }

    @Override
    public long getUnAcknowledgeDepth(String string) {
        return 0L;
    }

    @Override
    public boolean atMaxPending(String string) {
        return false;
    }

    @Override
    public int getFreeEventSize(String string) {
        return 0;
    }

    @Override
    public long allocateEvent(String string, long l, boolean bl) {
        return 0L;
    }

    @Override
    public long getRedeliveryCount(long l) {
        return 0L;
    }

    @Override
    public void clusterRecoveryWrite(fLongOrderedQueueSerialize fLongOrderedQueueSerialize2) {
    }

    @Override
    public void clusterRecoveryRead(fLongOrderedQueueDeserialize fLongOrderedQueueDeserialize2) {
    }
}

