/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store.index;

import com.pcbsys.foundation.base.fBaseApplication;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.filters.fFilter;
import com.pcbsys.foundation.logger.storelogger.StoreLogger;
import com.pcbsys.foundation.persist.bitset.fLongOrderedQueue;
import com.pcbsys.foundation.persist.bitset.fPersistentLongOrderedQueue;
import com.pcbsys.foundation.persist.fEventManager;
import com.pcbsys.foundation.store.fStoreImpl;
import com.pcbsys.foundation.store.index.RollbackData;
import com.pcbsys.foundation.store.index.fEventExclusiveIndexManager;
import com.pcbsys.foundation.store.index.fStoreIndexStatus;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class fPersistentExclusiveIndexManager
extends fEventExclusiveIndexManager {
    public fPersistentExclusiveIndexManager(fStoreImpl fStoreImpl2, String string, long l, fFilter fFilter2, int n, fStoreIndexStatus fStoreIndexStatus2, boolean bl, StoreLogger storeLogger) throws IOException {
        super(fStoreImpl2, string, l, fFilter2, n, fStoreIndexStatus2, bl, storeLogger);
    }

    @Override
    protected void startUpReset() {
        this.rollbackAllEvents();
        Iterator<Long> iterator = this.myOutstandingQueue.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            if (this.myStore.getEventStore().containsEvent(l)) continue;
            iterator.remove();
        }
        this.rebuildPurgeReadyList();
        this.myOutstandingQueue.calcSize();
        fConstants.logger.info("StoreIndex>" + this.getName() + " Startup reset complete");
    }

    @Override
    protected fLongOrderedQueue<RollbackData> openOrCreate(String string, fEventManager fEventManager2, long l, fFilter fFilter2) {
        fPersistentLongOrderedQueue<RollbackData> fPersistentLongOrderedQueue2 = null;
        try {
            File file = new File(string);
            if (!file.exists()) {
                fPersistentLongOrderedQueue2 = new fPersistentLongOrderedQueue<RollbackData>(string, this.myBitSetSize, new RollbackData());
                if (fEventManager2 != null) {
                    fEventManager2.copy(fPersistentLongOrderedQueue2, fFilter2, l);
                    while (l >= fPersistentLongOrderedQueue2.peek() && !fPersistentLongOrderedQueue2.isEmpty()) {
                        fPersistentLongOrderedQueue2.poll();
                    }
                }
                fConstants.logger.info("StoreIndex>" + this.getName() + " Added " + fPersistentLongOrderedQueue2.size() + " events to the queue");
            } else {
                fPersistentLongOrderedQueue2 = new fPersistentLongOrderedQueue<RollbackData>(string, this.myBitSetSize, new RollbackData());
                fConstants.logger.info("StoreIndex>" + this.getName() + " Reloaded " + fPersistentLongOrderedQueue2.size() + " events in the Index");
            }
        }
        catch (IOException iOException) {
            fBaseApplication.getApplication().fileOperationFailure("Failed during openOrCreate " + iOException.getMessage());
        }
        return fPersistentLongOrderedQueue2;
    }
}

