/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store.index;

import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Observable;

public class fStoreIndexConnectionStatus
extends Observable
implements fExternalable {
    private static final byte sLastRead = 0;
    private static final byte sLastAck = 1;
    private static final byte sTranSize = 2;
    private static final byte sEventsAck = 3;
    private static final byte sEventsRolled = 4;
    private static final byte sWindowSize = 5;
    private static final byte sSyncOrAsync = 6;
    private String myConId;
    private final long[] myLongData = new long[7];
    private boolean hasChanged = true;

    public fStoreIndexConnectionStatus() {
    }

    public fStoreIndexConnectionStatus(String string) {
        this.myConId = string;
        this.myLongData[0] = fTimer.currentTimeMillis();
        this.myLongData[1] = fTimer.currentTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Connection:").append(this.myConId);
        stringBuffer.append(" LastRead:").append(new Date(this.myLongData[0]));
        stringBuffer.append(" LastAck:").append(new Date(this.myLongData[1]));
        stringBuffer.append(" UnAcked:").append(this.myLongData[2]);
        stringBuffer.append(" Acked:").append(this.myLongData[3]);
        stringBuffer.append(" Rolled:").append(this.myLongData[4]);
        stringBuffer.append(" WindowSize:").append(this.myLongData[5]);
        stringBuffer.append(" Async:").append(this.myLongData[6] == 1L);
        return stringBuffer.toString();
    }

    public String getUniqueID() {
        return this.myConId;
    }

    public long getLastRead() {
        return this.myLongData[0];
    }

    public long getLastAck() {
        return this.myLongData[1];
    }

    public long getTransactionDepth() {
        return this.myLongData[2];
    }

    public long getEventsAcked() {
        return this.myLongData[3];
    }

    public long getEventsRolled() {
        return this.myLongData[4];
    }

    public int getWindowSize() {
        return (int)this.myLongData[5];
    }

    public boolean isAsync() {
        return this.myLongData[6] == 1L;
    }

    public void setAsync(boolean bl) {
        this.myLongData[6] = !bl ? 0L : 1L;
    }

    public void setLastRead(long l) {
        this.myLongData[0] = l;
    }

    public void setLastAck(long l) {
        this.myLongData[1] = l;
    }

    public void setTransactionDepth(long l) {
        this.myLongData[2] = l;
    }

    public void setEventsAcked(long l) {
        this.myLongData[3] = l;
    }

    public void setEventsRolled(long l) {
        this.myLongData[4] = l;
    }

    public void setWindowSize(int n) {
        this.myLongData[5] = n;
    }

    public void incrementEventsRolled() {
        this.myLongData[4] = this.myLongData[4] + 1L;
    }

    public void incrementEventsAcked() {
        this.myLongData[3] = this.myLongData[3] + 1L;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        this.myConId = fEventInputStream2.readString();
        int n = fEventInputStream2.readByte();
        for (int i = 0; i < n; ++i) {
            this.myLongData[i] = fEventInputStream2.readLong();
        }
    }

    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeString(this.myConId);
        fEventOutputStream2.writeByte((byte)this.myLongData.length);
        for (long l : this.myLongData) {
            fEventOutputStream2.writeLong(l);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean bl) {
        if (this.hasChanged && !bl) {
            super.setChanged();
            super.notifyObservers();
        }
        this.hasChanged = bl;
    }

    public void update(fStoreIndexConnectionStatus fStoreIndexConnectionStatus2) {
        System.arraycopy(fStoreIndexConnectionStatus2.myLongData, 0, this.myLongData, 0, this.myLongData.length);
    }

    public boolean changes(fStoreIndexConnectionStatus fStoreIndexConnectionStatus2) {
        for (int i = 0; i < this.myLongData.length; ++i) {
            if (this.myLongData[i] == fStoreIndexConnectionStatus2.myLongData[i]) continue;
            return true;
        }
        return false;
    }
}

