/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.store.index;

import com.pcbsys.foundation.base.fExternalable;
import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.io.fEventInputStream;
import com.pcbsys.foundation.io.fEventOutputStream;
import com.pcbsys.foundation.store.index.fStoreIndexConnectionStatus;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public class fStoreIndexStatus
extends Observable
implements fExternalable {
    private static final byte sLastRead = 0;
    private static final byte sLastWrite = 1;
    private static final byte sDepth = 2;
    private static final byte sTranSize = 3;
    private static final byte sEventId = 4;
    private static final byte sStoreSize = 5;
    private final long[] myLongData = new long[6];
    private final AbstractMap<String, fStoreIndexConnectionStatus> myConnectionStatus = new ConcurrentHashMap<String, fStoreIndexConnectionStatus>();
    private boolean hasChanged = true;

    public fStoreIndexStatus() {
        this.myLongData[0] = fTimer.currentTimeMillis();
        this.myLongData[1] = fTimer.currentTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" LastRead:").append(new Date(this.myLongData[0]));
        stringBuffer.append(" LastWrite:").append(new Date(this.myLongData[0]));
        stringBuffer.append(" Depth:").append(this.myLongData[2]);
        stringBuffer.append(" UnAcked:").append(this.myLongData[3]);
        stringBuffer.append(" EventId:").append(this.myLongData[4]);
        stringBuffer.append(" Size:").append(this.myLongData[5]).append("\n");
        for (fStoreIndexConnectionStatus fStoreIndexConnectionStatus2 : this.myConnectionStatus.values()) {
            stringBuffer.append("\t").append(fStoreIndexConnectionStatus2).append("\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConnections() {
        AbstractMap<String, fStoreIndexConnectionStatus> abstractMap = this.myConnectionStatus;
        synchronized (abstractMap) {
            this.myConnectionStatus.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public fStoreIndexConnectionStatus addConnection(String string, boolean bl, int n) {
        AbstractMap<String, fStoreIndexConnectionStatus> abstractMap = this.myConnectionStatus;
        synchronized (abstractMap) {
            fStoreIndexConnectionStatus fStoreIndexConnectionStatus2 = new fStoreIndexConnectionStatus(string);
            fStoreIndexConnectionStatus2.setWindowSize(n);
            fStoreIndexConnectionStatus2.setAsync(bl);
            this.myConnectionStatus.put(string, fStoreIndexConnectionStatus2);
            return fStoreIndexConnectionStatus2;
        }
    }

    public fStoreIndexConnectionStatus getConnection(String string) {
        return this.myConnectionStatus.get(string);
    }

    public fStoreIndexConnectionStatus removeConnection(String string) {
        return this.myConnectionStatus.remove(string);
    }

    public Iterator<fStoreIndexConnectionStatus> getConnectionIterator() {
        return this.myConnectionStatus.values().iterator();
    }

    public long getEventId() {
        return this.myLongData[4];
    }

    public int getConnectionCount() {
        return this.myConnectionStatus.size();
    }

    public long getLastRead() {
        return this.myLongData[0];
    }

    public long getLastWrite() {
        return this.myLongData[1];
    }

    public long getDepth() {
        return this.myLongData[2];
    }

    public long getTransactionDepth() {
        return this.myLongData[3];
    }

    public long getStoreSize() {
        return this.myLongData[5];
    }

    public void setLastRead(long l) {
        this.myLongData[0] = l;
    }

    public void setLastWrite(long l) {
        this.myLongData[1] = l;
    }

    public void setDepth(long l) {
        this.myLongData[2] = l;
    }

    public void setTransactionDepth(long l) {
        this.myLongData[3] = l;
    }

    public void setStoreSize(long l) {
        this.myLongData[5] = l;
    }

    public void setEventId(long l) {
        this.myLongData[4] = l;
    }

    @Override
    public void readExternal(fEventInputStream fEventInputStream2) throws IOException {
        int n;
        int n2 = fEventInputStream2.readByte();
        for (n = 0; n < n2; ++n) {
            this.myLongData[n] = fEventInputStream2.readLong();
        }
        n = fEventInputStream2.readInt();
        for (int i = 0; i < n; ++i) {
            fStoreIndexConnectionStatus fStoreIndexConnectionStatus2 = new fStoreIndexConnectionStatus();
            fStoreIndexConnectionStatus2.readExternal(fEventInputStream2);
            this.myConnectionStatus.put(fStoreIndexConnectionStatus2.getUniqueID(), fStoreIndexConnectionStatus2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(fEventOutputStream fEventOutputStream2) throws IOException {
        fEventOutputStream2.writeByte((byte)this.myLongData.length);
        for (long l : this.myLongData) {
            fEventOutputStream2.writeLong(l);
        }
        AbstractMap<String, fStoreIndexConnectionStatus> abstractMap = this.myConnectionStatus;
        synchronized (abstractMap) {
            fEventOutputStream2.writeInt(this.myConnectionStatus.size());
            for (fStoreIndexConnectionStatus fStoreIndexConnectionStatus2 : this.myConnectionStatus.values()) {
                fStoreIndexConnectionStatus2.writeExternal(fEventOutputStream2);
            }
        }
    }

    public int getSize() {
        return 1;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean bl) {
        if (this.hasChanged && !bl) {
            super.setChanged();
            super.notifyObservers();
        }
        this.hasChanged = bl;
    }
}

