/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.utils.fEnvironment;
import com.pcbsys.foundation.utils.fSystemConfiguration;

public class Constants {
    public static final boolean sMappingSupported;
    public static final boolean sEnableSwapping;
    public static final boolean sDebug;
    public static final boolean sValidate;

    public static void debugMsg(String string) {
        if (sDebug) {
            System.err.println("[**** (DEBUG MODE) ****] MappedMemory> " + string);
        }
        if (sDebug) {
            fConstants.logger.info(string);
        }
    }

    public static void debugMsg(Throwable throwable) {
        if (sDebug) {
            fConstants.logger.log(throwable);
        }
    }

    public static void log(String string) {
        fConstants.logger.info("PagedManager> " + string);
    }

    public static void log(Throwable throwable) {
        fConstants.logger.log(throwable);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            String string = fSystemConfiguration.getProperty("os.name").toLowerCase();
            bl4 = string.contains("hp-ux");
            bl3 = string.startsWith("sunos");
            bl2 = fSystemConfiguration.getProperty("os.arch").startsWith("sparc");
            bl = Integer.parseInt(fSystemConfiguration.getProperty("java.version").split("\\.")[1]) == 8;
        }
        catch (Exception exception) {
            // empty catch block
        }
        sMappingSupported = (!bl || !bl2 || !bl3) && !bl4;
        bl = true;
        String string = fSystemConfiguration.getProperty("OffHeapPaging", "true");
        if (string != null) {
            bl = Boolean.parseBoolean(string);
            if (bl) {
                fConstants.logger.log("Enabling Off Heap memory page swapping");
            } else {
                fConstants.logger.log("Disabling Off Heap memory page swapping");
            }
        }
        sEnableSwapping = bl;
        sDebug = fEnvironment.isDebugEnabled("MappedMemory");
        sValidate = fEnvironment.isDebugEnabled("MemoryValidate");
    }
}

