/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.Swapable;
import com.pcbsys.foundation.system.memory.fMemoryPageManager;
import com.pcbsys.foundation.system.memory.fOffHeapAllocator;
import com.pcbsys.foundation.system.memory.fPageSwapOutManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public final class SimplePageSwapImpl
implements fPageSwapOutManager {
    private static final Comparator<fMemoryPageManager> myComparitor = new ManagerComparatorBySize();
    private final ArrayList<fMemoryPageManager> myWorkingList;
    private final float myPercentFree;
    private final long myIdleTime;

    public SimplePageSwapImpl(float f, long l) {
        this.myIdleTime = l;
        this.myPercentFree = f;
        this.myWorkingList = new ArrayList();
        Constants.log("Initiating simple page management. Pages will be released after " + this.myIdleTime / 100L + " seconds");
    }

    @Override
    public void scanMapManagers(LinkedList<fMemoryPageManager> linkedList, boolean bl) {
        double d = fOffHeapAllocator.getAllocator().getTotalDirectMemory() - fOffHeapAllocator.getAllocator().getUsedDirectMemory();
        d = d * 100.0 / (double)fOffHeapAllocator.getAllocator().getTotalDirectMemory();
        if (bl || d < (double)this.myPercentFree) {
            this.myWorkingList.addAll(linkedList);
            Collections.sort(this.myWorkingList, myComparitor);
            long l = 0L;
            for (fMemoryPageManager fMemoryPageManager2 : this.myWorkingList) {
                if (fMemoryPageManager2 == null) continue;
                l += fMemoryPageManager2.unMapIdlePages();
            }
            this.myWorkingList.clear();
            if (l != 0L) {
                Constants.log("Paged out " + l / 1024L * 1024L + "MB of Memory Mapped file memory back");
            }
        }
    }

    @Override
    public boolean unmap(Swapable swapable) throws IOException {
        if (swapable.isSwappedIn() && swapable.getAccessTime() + this.myIdleTime < fTimer.currentTimeMillis()) {
            swapable.swapOut();
            if (Constants.sDebug) {
                Constants.debugMsg("Swapping out idle " + swapable.toString());
            }
            return true;
        }
        return false;
    }

    private static final class ManagerComparatorBySize
    implements Comparator<fMemoryPageManager>,
    Serializable {
        private ManagerComparatorBySize() {
        }

        @Override
        public int compare(fMemoryPageManager fMemoryPageManager2, fMemoryPageManager fMemoryPageManager3) {
            return fMemoryPageManager2.getUsedListSize() - fMemoryPageManager3.getUsedListSize();
        }
    }
}

