/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fPage;
import java.io.IOException;
import java.io.RandomAccessFile;

public class fFilePage
extends fPage {
    private static final byte[] sByteHead = new byte[8];
    private static final byte[] sByteFree;
    private static final byte[] sByteChained;
    private final RandomAccessFile myFile;
    private final long myFileOffset;
    private final byte[] myTmpBuf = new byte[16];
    private int myPos;

    public fFilePage(RandomAccessFile randomAccessFile, long l, int n, long l2) throws IOException {
        super(l2, n);
        this.myFile = randomAccessFile;
        this.myFileOffset = l;
        this.myPos = 0;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void clear() {
        try {
            this.myFile.seek(this.myFileOffset);
            this.myFile.write(sByteFree);
            this.myFile.write(sByteFree);
            if (Constants.sValidate) {
                this.myPos = 16;
                while (this.myPos < this.mySize && this.mySize - this.myPos < 8) {
                    this.myFile.writeLong(0L);
                    this.myPos += 8;
                }
                if (this.myPos != this.mySize) {
                    while (this.myPos < this.mySize) {
                        this.myFile.write(0);
                        ++this.myPos;
                    }
                }
            }
        }
        catch (Exception exception) {
            fConstants.logger.fatal(exception);
        }
        this.myPos = 16;
    }

    @Override
    public void sync() throws IOException {
        this.myFile.getFD().sync();
    }

    @Override
    public fPage.type getType() {
        try {
            this.myFile.seek(this.myFileOffset);
            return this.lookupType(this.myFile.readLong());
        }
        catch (IOException iOException) {
            fConstants.logger.fatal(iOException);
            throw new Error("MappedMemory Header is corrupt, expected 0x0");
        }
    }

    @Override
    public fPage getChain() {
        if (this.link != null) {
            fFilePage fFilePage2 = (fFilePage)this.link;
            fFilePage2.seek(0);
        }
        return super.getChain();
    }

    @Override
    public boolean isMemoryMapped() {
        return false;
    }

    @Override
    public void allocate() throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate) {
            this.myFile.seek(this.myFileOffset);
            if (this.myFile.readLong() != 0L) {
                this.myFile.seek(this.myFileOffset);
                Constants.debugMsg("Buffer being allocated but is already allocated " + Long.toHexString(this.myFile.readLong()));
                throw new IOException("Buffer being allocated but is already allocated " + Long.toHexString(this.myFile.readLong()));
            }
        }
        if (Constants.sDebug) {
            Constants.debugMsg("Allocating page " + this.myFileOffset);
        }
        this.myFile.seek(this.myFileOffset);
        this.myFile.write(sByteHead);
        this.myPos = 16;
    }

    @Override
    public void deallocate() throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate) {
            this.myFile.seek(this.myFileOffset);
            if (this.myFile.readLong() == 0L) {
                this.myFile.seek(this.myFileOffset);
                Constants.debugMsg("Buffer being deallocated but is not allocated " + Long.toHexString(this.myFile.readLong()));
                throw new IOException("Buffer being freed but is not allocated");
            }
        }
        if (Constants.sDebug) {
            Constants.debugMsg("Deallocating page " + this.myFileOffset);
        }
        this.clear();
        this.link = null;
        this.myRemapListener = null;
    }

    @Override
    public void chain(fPage fPage2) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate) {
            fPage2.seek((int)this.myFileOffset);
            long l = this.getLong();
            if (l != 0L) {
                throw new IOException("Buffer being chained but is already allocated " + Long.toHexString(l));
            }
        }
        fFilePage fFilePage2 = (fFilePage)fPage2;
        fFilePage2.myFile.seek(fFilePage2.myFileOffset);
        fFilePage2.myFile.write(sByteChained);
        this.myFile.seek(this.myFileOffset + 8L);
        fFilePage.writeLong(this.myTmpBuf, fPage2.getUniqueId());
        this.myFile.write(this.myTmpBuf);
        fFilePage2.seek(0);
        this.link = fPage2;
        if (Constants.sDebug) {
            Constants.debugMsg("Chaining " + this.getUniqueId() + " with " + fPage2.getUniqueId());
        }
    }

    @Override
    public void copy(fPage fPage2) throws IOException {
        fFilePage fFilePage2 = (fFilePage)fPage2;
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (fFilePage2.mySize > this.mySize) {
            throw new IOException("Source page size is greater then the destination");
        }
        byte[] byArray = new byte[this.mySize - 16];
        fFilePage2.myFile.seek(fFilePage2.myFileOffset + 16L);
        fFilePage2.myFile.read(byArray, 0, byArray.length);
        this.myFile.seek(this.myFileOffset + 16L);
        this.myFile.write(byArray);
        this.myPos = ((fFilePage)fPage2).myPos;
        this.myRemapListener = fPage2.myRemapListener;
    }

    @Override
    public int available() {
        return this.mySize - this.myPos;
    }

    @Override
    public int getPosition() {
        return this.myPos;
    }

    @Override
    public void seek(int n) {
        try {
            this.myPos = n + 16;
            this.myFile.seek((long)this.myPos + this.myFileOffset);
        }
        catch (IOException iOException) {
            throw new Error(iOException.getCause());
        }
    }

    @Override
    public long getChainUniqueId() {
        try {
            this.myFile.seek(this.myFileOffset + 8L);
            return this.myFile.readLong();
        }
        catch (IOException iOException) {
            throw new Error(iOException.getCause());
        }
    }

    @Override
    public boolean isLoaded() throws IOException {
        return true;
    }

    @Override
    public void load() throws IOException {
    }

    @Override
    public void force() throws IOException {
    }

    @Override
    public void flip() throws IOException {
        this.seek(0);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",bytebyte[]() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.write(byArray);
        this.myPos += byArray.length;
    }

    @Override
    public void put(byte[] byArray, int n, int n2) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",bytebyte[]() File Off:<" + this.myFileOffset + "> (Off:" + n + ",len:" + n2 + ")");
        }
        this.myFile.write(byArray, n, n2);
        this.myPos += n2;
    }

    @Override
    public void put(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",bytebyte[]() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.write(byArray, n2, n3);
    }

    @Override
    public void putOrderedLong(long l) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeLong(l);
        this.myPos += 8;
    }

    @Override
    public void putOrderedLong(int n, long l) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeLong(l);
        this.myPos += 8;
    }

    @Override
    public void putLong(long l) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeLong(l);
        this.myPos += 8;
    }

    @Override
    public void putLong(int n, long l) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeLong(l);
        this.myPos += 8;
    }

    @Override
    public void putDouble(double d) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeDouble(d);
        this.myPos += 8;
    }

    @Override
    public void putDouble(int n, double d) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putDouble() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeDouble(d);
        this.myPos += 8;
    }

    @Override
    public void putFloat(float f) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putFloat() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeFloat(f);
        this.myPos += 4;
    }

    @Override
    public void putFloat(int n, float f) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putFloat() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeFloat(f);
        this.myPos += 4;
    }

    @Override
    public void putInt(int n) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putInt() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeInt(n);
        this.myPos += 4;
    }

    @Override
    public void putInt(int n, int n2) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putInt() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeInt(n2);
        this.myPos += 4;
    }

    @Override
    public void putShort(short s) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putShort() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeShort(s);
        this.myPos += 2;
    }

    @Override
    public void putShort(int n, short s) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putShort() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeShort(s);
        this.myPos += 2;
    }

    @Override
    public void putByte(byte by) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.write(by);
        ++this.myPos;
    }

    @Override
    public void putByte(int n, byte by) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putByte() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.write(by);
        ++this.myPos;
    }

    @Override
    public void putLongVolatile(long l) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeLong(l);
        this.myPos += 8;
    }

    @Override
    public void putLongVolatile(int n, long l) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putLong() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeLong(l);
        this.myPos += 8;
    }

    @Override
    public void putVolatileDouble(double d) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeDouble(d);
        this.myPos += 8;
    }

    @Override
    public void putVolatileDouble(int n, double d) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putDouble() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeDouble(d);
        this.myPos += 8;
    }

    @Override
    public void putVolatileFloat(float f) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putFloat() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeFloat(f);
        this.myPos += 4;
    }

    @Override
    public void putVolatileFloat(int n, float f) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putFloat() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeFloat(f);
        this.myPos += 4;
    }

    @Override
    public void putVolatileInt(int n) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putInt() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeInt(n);
        this.myPos += 4;
    }

    @Override
    public void putVolatileInt(int n, int n2) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putInt() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeInt(n2);
        this.myPos += 4;
    }

    @Override
    public void putVolatileShort(short s) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putShort() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.writeShort(s);
        this.myPos += 2;
    }

    @Override
    public void putVolatileShort(int n, short s) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putShort() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.writeShort(s);
        this.myPos += 2;
    }

    @Override
    public void putVolatileByte(byte by) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putByte() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.write(by);
        ++this.myPos;
    }

    @Override
    public void putVolatileByte(int n, byte by) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",putByte() Off:<" + this.myFileOffset + ">");
        }
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        this.myFile.write(by);
        ++this.myPos;
    }

    @Override
    public void get(byte[] byArray, int n, int n2) throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getByte[]() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.read(byArray, n, n2);
    }

    @Override
    public void get(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getByte[]() Off:<" + this.myFileOffset + ">");
        }
        this.myFile.read(byArray, n2, n3);
        this.myPos += n3;
    }

    @Override
    public long getLongVolatile() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getLong() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readLong();
    }

    @Override
    public long getLongVolatile(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getLong() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readLong();
    }

    @Override
    public double getDoubleVolatile() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readDouble();
    }

    @Override
    public double getDoubleVolatile(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readDouble();
    }

    @Override
    public int getIntVolatile() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getInt() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readInt();
    }

    @Override
    public int getIntVolatile(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getInt() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readInt();
    }

    @Override
    public float getFloatVolatile() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getFloat() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readFloat();
    }

    @Override
    public float getFloatVolatile(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getFloat() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readFloat();
    }

    @Override
    public short getShortVolatile() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getShort() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 2;
        return this.myFile.readShort();
    }

    @Override
    public short getShortVolatile(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getShort() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 2;
        return this.myFile.readShort();
    }

    @Override
    public byte getByteVolatile() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getByte() Off:<" + this.myFileOffset + ">");
        }
        ++this.myPos;
        return (byte)this.myFile.read();
    }

    @Override
    public byte getByteVolatile(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getByte() Off:<" + this.myFileOffset + ">");
        }
        ++this.myPos;
        return (byte)this.myFile.read();
    }

    @Override
    public long getLong() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readLong();
    }

    @Override
    public long getLong(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getLong() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readLong();
    }

    @Override
    public double getDouble() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readDouble();
    }

    @Override
    public double getDouble(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getDouble() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 8;
        return this.myFile.readDouble();
    }

    @Override
    public int getInt() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getInt() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readInt();
    }

    @Override
    public int getInt(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getInt() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readInt();
    }

    @Override
    public float getFloat() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getFloat() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readFloat();
    }

    @Override
    public float getFloat(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getFloat() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 4;
        return this.myFile.readFloat();
    }

    @Override
    public short getShort() throws IOException {
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getShort() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 2;
        return this.myFile.readShort();
    }

    @Override
    public short getShort(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        if (sDebug) {
            Constants.debugMsg("put(" + this.myPos + ",getShort() Off:<" + this.myFileOffset + ">");
        }
        this.myPos += 2;
        return this.myFile.readShort();
    }

    @Override
    public byte getByte() throws IOException {
        if (sDebug) {
            Constants.debugMsg("get(" + this.myPos + ",getByte() Off:<" + this.myFileOffset + ">");
        }
        ++this.myPos;
        return (byte)this.myFile.read();
    }

    @Override
    public byte getByte(int n) throws IOException {
        if (n != this.myPos) {
            this.myFile.seek(this.myFileOffset + (long)n);
            this.myPos = n;
        }
        ++this.myPos;
        return (byte)this.myFile.read();
    }

    @Override
    public boolean isSwappedIn() {
        return true;
    }

    @Override
    public boolean swapIn() throws IOException {
        return false;
    }

    @Override
    public boolean swapOut() throws IOException {
        return false;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    private static void writeLong(byte[] byArray, long l) {
        byArray[0] = (byte)(l >>> 56 & 0xFFL);
        byArray[1] = (byte)(l >>> 48 & 0xFFL);
        byArray[2] = (byte)(l >>> 40 & 0xFFL);
        byArray[3] = (byte)(l >>> 32 & 0xFFL);
        byArray[4] = (byte)(l >>> 24 & 0xFFL);
        byArray[5] = (byte)(l >>> 16 & 0xFFL);
        byArray[6] = (byte)(l >>> 8 & 0xFFL);
        byArray[7] = (byte)l;
    }

    static {
        fFilePage.writeLong(sByteHead, Long.MAX_VALUE);
        sByteFree = new byte[8];
        fFilePage.writeLong(sByteFree, 0L);
        sByteChained = new byte[8];
        fFilePage.writeLong(sByteChained, 0x7777777777777777L);
    }
}

