/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.drivers.jdk.fJDKHelperBase;
import com.pcbsys.foundation.drivers.jdk.fUnSafe;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fMemoryAllocator;
import com.pcbsys.foundation.system.memory.fPage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class fMemoryPage
extends fPage {
    private static final fUnSafe unsafe = fJDKHelperBase.getUnsafe();
    private static final long BYTE_ARRAY_OFFSET = unsafe.arrayBaseOffset(byte[].class);
    protected static final Method addressMethod;
    protected final long myFileOffset;
    protected final fMemoryAllocator myAllocator;
    protected transient boolean isActive;
    protected long B0;
    protected long B1;
    protected long B2;
    protected long B3;
    protected long B4;
    protected long B5;
    protected long B6;
    protected long myAddress;
    private int myPos;
    protected ByteBuffer myMap;
    protected int myMapOffset;
    protected boolean isMapped;

    public static int SystemPageSize() {
        return unsafe.pageSize();
    }

    public fMemoryPage(ByteBuffer byteBuffer, long l, fMemoryAllocator fMemoryAllocator2) {
        this(byteBuffer, l, fMemoryAllocator2, 0, byteBuffer.capacity(), 0L);
    }

    public fMemoryPage(ByteBuffer byteBuffer, long l, fMemoryAllocator fMemoryAllocator2, int n, int n2, long l2) {
        super(l, n2);
        this.myMap = byteBuffer;
        this.isMapped = true;
        this.myAllocator = fMemoryAllocator2;
        this.myMapOffset = n;
        this.myFileOffset = l2;
        try {
            this.myAddress = (Long)addressMethod.invoke((Object)byteBuffer, new Object[0]) + (long)this.myMapOffset;
        }
        catch (Exception exception) {
            throw new RuntimeException("Method not supported");
        }
        this.isActive = true;
        this.myPos = 16;
        if (Constants.sValidate) {
            byte[] byArray = new byte[n2 - 16];
            unsafe.copyMemory(null, this.myAddress + 16L, byArray, BYTE_ARRAY_OFFSET, byArray.length);
            this.getType();
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        this.myAllocator.release(this);
        this.isMapped = false;
    }

    @Override
    public void clear() {
        unsafe.putOrderedLong(null, this.myAddress, 0L);
        unsafe.putOrderedLong(null, this.myAddress + 8L, 0L);
        if (Constants.sValidate) {
            unsafe.setMemory(this.myAddress, this.mySize, (byte)0);
        }
        this.myPos = 16;
    }

    @Override
    public void sync() throws IOException {
    }

    @Override
    public boolean isMemoryMapped() {
        return true;
    }

    @Override
    public boolean isSwappedIn() {
        return this.isMapped;
    }

    @Override
    public boolean swapOut() throws IOException {
        return false;
    }

    @Override
    public boolean swapIn() throws IOException {
        return false;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    public String getName() {
        return "fMemoryPage";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(" >");
        stringBuilder.append(" UniqueId:").append(this.myUniqueId);
        stringBuilder.append(" Size:").append(this.mySize);
        stringBuilder.append(" Last Access:").append(this.myLastAccessTime);
        stringBuilder.append(" FileOffset:").append(this.myFileOffset);
        if (this.isMapped) {
            stringBuilder.append(" Mapped:True Address:[").append(Long.toHexString(this.myAddress)).append("]");
        } else {
            stringBuilder.append(" Mapped:False ");
        }
        if (this.link != null) {
            stringBuilder.append("Chained to : ").append(this.link.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public fPage.type getType() {
        return this.lookupType(unsafe.getLong(this.myAddress));
    }

    @Override
    public void allocate() throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && unsafe.getLong(null, this.myAddress) != 0L) {
            Constants.debugMsg("Buffer being allocated but is already allocated " + Long.toHexString(unsafe.getLong(null, this.myAddress)));
            throw new IOException("Buffer being allocated but is already allocated " + Long.toHexString(unsafe.getLong(null, this.myAddress)));
        }
        unsafe.putLong(null, this.myAddress, Long.MAX_VALUE);
        unsafe.putLong(null, this.myAddress + 8L, 0L);
        this.myPos = 16;
    }

    @Override
    public void deallocate() throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && unsafe.getLong(null, this.myAddress) == 0L) {
            Constants.debugMsg("Buffer being deallocated but is not allocated " + Long.toHexString(unsafe.getLong(null, this.myAddress)));
            throw new IOException("Buffer being freed but is not allocated");
        }
        this.clear();
        this.link = null;
        this.myRemapListener = null;
    }

    @Override
    public void chain(fPage fPage2) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && unsafe.getLong(null, ((fMemoryPage)fPage2).myAddress) != 0L) {
            throw new IOException("Buffer being chained but is already allocated " + Long.toHexString(unsafe.getLong(null, ((fMemoryPage)fPage2).myAddress)));
        }
        unsafe.putLong(null, ((fMemoryPage)fPage2).myAddress, 0x7777777777777777L);
        unsafe.putLong(null, this.myAddress + 8L, ((fMemoryPage)fPage2).myUniqueId);
        this.link = fPage2;
        if (Constants.sDebug) {
            Constants.debugMsg("Chaining " + this.myUniqueId + " with " + ((fMemoryPage)fPage2).myUniqueId);
        }
    }

    @Override
    public void copy(fPage fPage2) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (((fMemoryPage)fPage2).mySize > this.mySize) {
            throw new IOException("Source page size is greater then the destination");
        }
        if (Constants.sValidate) {
            unsafe.setMemory(this.myAddress + 16L, this.mySize - 16, (byte)0);
        }
        unsafe.copyMemory(((fMemoryPage)fPage2).myAddress + 16L, this.myAddress + 16L, this.myAllocator.getBufferSize() - 16);
        this.myPos = ((fMemoryPage)fPage2).myPos;
        this.myRemapListener = ((fMemoryPage)fPage2).myRemapListener;
    }

    @Override
    public int available() {
        return this.mySize - this.myPos;
    }

    @Override
    public int getPosition() {
        return this.myPos;
    }

    @Override
    public void seek(int n) {
        this.myPos = n + 16;
    }

    @Override
    public long getChainUniqueId() {
        return unsafe.getLong(null, this.myAddress + 8L);
    }

    @Override
    public boolean isLoaded() throws IOException {
        if (!this.isActive) {
            throw new IOException("Buffer closed");
        }
        return true;
    }

    @Override
    public void load() throws IOException {
        if (!this.isActive) {
            throw new IOException("Buffer closed");
        }
    }

    @Override
    public void force() throws IOException {
        if (!this.isActive) {
            throw new IOException("Buffer closed");
        }
    }

    @Override
    public void flip() throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        this.myPos = 16;
        if (this.link != null) {
            this.link.flip();
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void put(byte[] byArray) throws IOException {
        this.put(byArray, 0, byArray.length);
    }

    @Override
    public void put(byte[] byArray, int n, int n2) throws IOException {
        if (n2 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.put(this.myPos, byArray, n, n2);
        this.myPos += n2;
    }

    @Override
    public void put(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + n3 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",byte[" + byArray.length + "]," + n2 + "," + n3 + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.copyMemory(byArray, BYTE_ARRAY_OFFSET + (long)n2, null, this.myAddress + (long)n, n3);
    }

    @Override
    public void putOrderedLong(long l) throws IOException {
        if (8 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putOrderedLong(this.myPos, l);
        this.myPos += 8;
    }

    @Override
    public void putOrderedLong(int n, long l) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",long:" + l + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putOrderedLong(null, this.myAddress + (long)n, l);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putLong(long l) throws IOException {
        if (8 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putLong(this.myPos, l);
        this.myPos += 8;
    }

    @Override
    public void putLong(int n, long l) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",long:" + l + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putLong(this.myAddress + (long)n, l);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putDouble(double d) throws IOException {
        if (8 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putDouble(this.myPos, d);
        this.myPos += 8;
    }

    @Override
    public void putDouble(int n, double d) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",double:" + d + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putDouble(this.myAddress + (long)n, d);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putFloat(float f) throws IOException {
        if (4 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putFloat(this.myPos, f);
        this.myPos += 4;
    }

    @Override
    public void putFloat(int n, float f) throws IOException {
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",float:" + f + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putFloat(this.myAddress + (long)n, f);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putInt(int n) throws IOException {
        if (4 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putInt(this.myPos, n);
        this.myPos += 4;
    }

    @Override
    public void putInt(int n, int n2) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",int:" + n2 + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putInt(this.myAddress + (long)n, n2);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putShort(short s) throws IOException {
        if (2 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putShort(this.myPos, s);
        this.myPos += 2;
    }

    @Override
    public void putShort(int n, short s) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 2 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",short:" + s + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putShort(this.myAddress + (long)n, s);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putByte(byte by) throws IOException {
        if (1 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putByte(this.myPos, by);
        ++this.myPos;
    }

    @Override
    public void putByte(int n, byte by) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 1 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",byte:" + by + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putByte(this.myAddress + (long)n, by);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putLongVolatile(long l) throws IOException {
        if (8 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putLongVolatile(this.myPos, l);
        this.myPos += 8;
    }

    @Override
    public void putLongVolatile(int n, long l) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",long_v:" + l + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putLongVolatile(null, this.myAddress + (long)n, l);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putVolatileDouble(double d) throws IOException {
        if (8 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putVolatileDouble(this.myPos, d);
        this.myPos += 8;
    }

    @Override
    public void putVolatileDouble(int n, double d) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",double_v:" + d + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putDoubleVolatile(null, this.myAddress + (long)n, d);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putVolatileFloat(float f) throws IOException {
        if (4 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putVolatileFloat(this.myPos, f);
        this.myPos += 4;
    }

    @Override
    public void putVolatileFloat(int n, float f) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",float_v:" + f + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putFloatVolatile(null, this.myAddress + (long)n, f);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putVolatileInt(int n) throws IOException {
        if (4 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putVolatileInt(this.myPos, n);
        this.myPos += 4;
    }

    @Override
    public void putVolatileInt(int n, int n2) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",int_v:" + n2 + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putIntVolatile(null, this.myAddress + (long)n, n2);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putVolatileShort(short s) throws IOException {
        if (2 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putVolatileShort(this.myPos, s);
        this.myPos += 2;
    }

    @Override
    public void putVolatileShort(int n, short s) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 2 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",short_v:" + s + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putShortVolatile(null, this.myAddress + (long)n, s);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void putVolatileByte(byte by) throws IOException {
        if (1 + this.myPos > this.mySize) {
            throw new IOException("Buffer Overrun");
        }
        this.putVolatileByte(this.myPos, by);
        ++this.myPos;
    }

    @Override
    public void putVolatileByte(int n, byte by) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 1 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("put(" + n + ",byte_v:" + by + ") <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.putByteVolatile(null, this.myAddress + (long)n, by);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public void get(byte[] byArray, int n, int n2) throws IOException {
        this.get(this.myPos, byArray, n, n2);
        this.myPos += n2;
    }

    @Override
    public void get(int n, byte[] byArray, int n2, int n3) throws IOException {
        if (Constants.sValidate && n + n3 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",byte:[" + byArray.length + "]) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        unsafe.copyMemory(null, this.myAddress + (long)n, byArray, BYTE_ARRAY_OFFSET + (long)n2, n3);
        if (Constants.sValidate) {
            this.getType();
        }
    }

    @Override
    public long getLongVolatile() throws IOException {
        long l = this.getLongVolatile(this.myPos);
        this.myPos += 8;
        return l;
    }

    @Override
    public long getLongVolatile(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",long) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getLongVolatile(null, this.myAddress + (long)n);
    }

    @Override
    public double getDoubleVolatile() throws IOException {
        double d = this.getDoubleVolatile(this.myPos);
        this.myPos += 8;
        return d;
    }

    @Override
    public double getDoubleVolatile(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",double) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getDoubleVolatile(null, this.myAddress + (long)n);
    }

    @Override
    public int getIntVolatile() throws IOException {
        int n = this.getIntVolatile(this.myPos);
        this.myPos += 4;
        return n;
    }

    @Override
    public int getIntVolatile(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",int_v) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getIntVolatile(null, this.myAddress + (long)n);
    }

    @Override
    public float getFloatVolatile() throws IOException {
        float f = this.getFloatVolatile(this.myPos);
        this.myPos += 4;
        return f;
    }

    @Override
    public float getFloatVolatile(int n) throws IOException {
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",float) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getFloatVolatile(null, this.myAddress + (long)n);
    }

    @Override
    public short getShortVolatile() throws IOException {
        short s = this.getShortVolatile(this.myPos);
        this.myPos += 2;
        return s;
    }

    @Override
    public short getShortVolatile(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 2 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",short) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getShortVolatile(null, this.myAddress + (long)n);
    }

    @Override
    public byte getByteVolatile() throws IOException {
        byte by = this.getByteVolatile(this.myPos);
        ++this.myPos;
        return by;
    }

    @Override
    public byte getByteVolatile(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 1 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",byte) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getByteVolatile(null, this.myAddress + (long)n);
    }

    @Override
    public long getLong() throws IOException {
        long l = this.getLong(this.myPos);
        this.myPos += 8;
        return l;
    }

    @Override
    public long getLong(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",long) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getLong(this.myAddress + (long)n);
    }

    @Override
    public double getDouble() throws IOException {
        double d = this.getDouble(this.myPos);
        this.myPos += 8;
        return d;
    }

    @Override
    public double getDouble(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 8 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",double) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getDouble(this.myAddress + (long)n);
    }

    @Override
    public int getInt() throws IOException {
        int n = this.getInt(this.myPos);
        this.myPos += 4;
        return n;
    }

    @Override
    public int getInt(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",int) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getInt(this.myAddress + (long)n);
    }

    @Override
    public float getFloat() throws IOException {
        float f = this.getFloat(this.myPos);
        this.myPos += 4;
        return f;
    }

    @Override
    public float getFloat(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 4 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",float) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getFloat(this.myAddress + (long)n);
    }

    @Override
    public short getShort() throws IOException {
        short s = this.getShort(this.myPos);
        this.myPos += 2;
        return s;
    }

    @Override
    public short getShort(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 2 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",short) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getShort(this.myAddress + (long)n);
    }

    @Override
    public byte getByte() throws IOException {
        byte by = this.getByte(this.myPos);
        ++this.myPos;
        return by;
    }

    @Override
    public byte getByte(int n) throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        if (Constants.sValidate && n + 1 > this.mySize) {
            throw new IOException("Put exceeded buffer size");
        }
        if (sDebug) {
            Constants.debugMsg("get(" + n + ",byte) <ID:" + this.myUniqueId + "> Addr:<" + this.myAddress + ">");
        }
        return unsafe.getByte(this.myAddress + (long)n);
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        Method method = null;
        try {
            method = byteBuffer.getClass().getDeclaredMethod("address", new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constants.debugMsg(noSuchMethodException);
        }
        addressMethod = method;
    }
}

