/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.system.memory.fMemoryAllocator;
import com.pcbsys.foundation.system.memory.fMemoryPage;
import com.pcbsys.foundation.system.memory.fOffHeapAllocator;
import com.pcbsys.foundation.system.memory.fPage;
import java.io.IOException;
import java.nio.ByteBuffer;

public class fMemoryPageAllocator
implements fMemoryAllocator {
    private final int myPageSize;
    private int allocationCount;

    public fMemoryPageAllocator(int n) {
        this.myPageSize = n;
        this.allocationCount = 0;
    }

    @Override
    public fMemoryPage allocate(long l) throws IOException {
        ++this.allocationCount;
        return new fMemoryPage(this.allocate(), l, this);
    }

    @Override
    public String getName() {
        return "OffHeap";
    }

    @Override
    public long extend() throws IOException {
        return 10L;
    }

    @Override
    public int getBufferSize() {
        return this.myPageSize;
    }

    @Override
    public boolean supportSwapOut() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean reload() {
        return false;
    }

    public int bufferSize() {
        return this.myPageSize;
    }

    @Override
    public int initialAllocation() {
        return 1;
    }

    @Override
    public int allocated() {
        return this.allocationCount;
    }

    private ByteBuffer allocate() throws IOException {
        return fOffHeapAllocator.getAllocator().allocate(this.myPageSize);
    }

    @Override
    public void release(fPage fPage2) throws IOException {
        --this.allocationCount;
        fOffHeapAllocator.getAllocator().release(this.myPageSize);
        fPage2.clear();
    }

    @Override
    public long unMapIdlePages() {
        return 0L;
    }

    @Override
    public void compact() throws IOException {
    }

    @Override
    public void trim(long l) {
    }

    @Override
    public int getUsableBufferSize() {
        return this.myPageSize - 16;
    }
}

