/*
 * Decompiled with CFR 0.152.
 */
package com.pcbsys.foundation.system.memory;

import com.pcbsys.foundation.base.fTimer;
import com.pcbsys.foundation.fConstants;
import com.pcbsys.foundation.system.memory.Constants;
import com.pcbsys.foundation.system.memory.fMemoryAllocator;
import com.pcbsys.foundation.system.memory.fMemoryPage;
import com.pcbsys.foundation.system.memory.fMemoryPageFileAllocator;
import com.pcbsys.foundation.system.memory.fPage;
import java.io.IOException;
import java.nio.MappedByteBuffer;

public class fMemoryPageFile
extends fMemoryPage {
    public fMemoryPageFile(MappedByteBuffer mappedByteBuffer, long l, fMemoryAllocator fMemoryAllocator2, long l2) {
        super(mappedByteBuffer, l, fMemoryAllocator2, 0, mappedByteBuffer.capacity(), l2);
        this.isMapped = true;
    }

    @Override
    public fPage.type getType() {
        try {
            this.swapIn();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.getType();
    }

    @Override
    public void allocate() throws IOException {
        if (!this.isActive()) {
            throw new IOException("Buffer closed");
        }
        try {
            this.swapIn();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.allocate();
    }

    @Override
    public boolean isActive() {
        if (!this.isMapped) {
            try {
                this.swapIn();
            }
            catch (Exception exception) {
                fConstants.logger.warn(exception);
            }
        }
        this.myLastAccessTime = fTimer.currentTimeMillis();
        return this.isActive;
    }

    @Override
    public synchronized boolean swapOut() throws IOException {
        if (this.isMapped) {
            this.myAllocator.release(this);
            this.isMapped = false;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean swapIn() throws IOException {
        if (!this.isMapped) {
            this.myLastAccessTime = fTimer.currentTimeMillis();
            this.myMap = ((fMemoryPageFileAllocator)this.myAllocator).allocate(this.myFileOffset, this.myAllocator.getBufferSize());
            try {
                this.myAddress = (Long)addressMethod.invoke((Object)this.myMap, new Object[0]) + (long)this.myMapOffset;
            }
            catch (Exception exception) {
                throw new RuntimeException("Method not supported");
            }
            this.isMapped = true;
            if (this.link != null) {
                if (Constants.sDebug) {
                    Constants.debugMsg("Swapping in chained page " + this.link.getUniqueId());
                }
                return this.link.swapIn();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoaded() throws IOException {
        if (!this.isActive) {
            throw new IOException("Buffer closed");
        }
        return ((MappedByteBuffer)this.myMap).isLoaded();
    }

    @Override
    public void load() throws IOException {
        if (!this.isActive) {
            throw new IOException("Buffer closed");
        }
        ((MappedByteBuffer)this.myMap).load();
    }

    @Override
    public void force() throws IOException {
        if (!this.isActive) {
            throw new IOException("Buffer closed");
        }
        ((MappedByteBuffer)this.myMap).force();
    }

    @Override
    public String getName() {
        return "fMemoryPageFile";
    }
}

